# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = ['DeploymentArgs', 'Deployment']

@pulumi.input_type
class DeploymentArgs:
    def __init__(__self__, *,
                 api_deployment_id: pulumi.Input[str],
                 api_id: pulumi.Input[str],
                 access_guidance: Optional[pulumi.Input[str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 api_spec_revision: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 endpoint_uri: Optional[pulumi.Input[str]] = None,
                 external_channel_uri: Optional[pulumi.Input[str]] = None,
                 intended_audience: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Deployment resource.
        :param pulumi.Input[str] api_deployment_id: Required. The ID to use for the deployment, which will become the final component of the deployment's resource name. This value should be 4-63 characters, and valid characters are /a-z-/. Following AIP-162, IDs must not have the form of a UUID.
        :param pulumi.Input[str] access_guidance: Text briefly describing how to access the endpoint. Changes to this value will not affect the revision.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations attach non-identifying metadata to resources. Annotation keys and values are less restricted than those of labels, but should be generally used for small values of broad interest. Larger, topic- specific metadata should be stored in Artifacts.
        :param pulumi.Input[str] api_spec_revision: The full resource name (including revision id) of the spec of the API being served by the deployment. Changes to this value will update the revision. Format: apis/{api}/deployments/{deployment}
        :param pulumi.Input[str] description: A detailed description.
        :param pulumi.Input[str] display_name: Human-meaningful name.
        :param pulumi.Input[str] endpoint_uri: The address where the deployment is serving. Changes to this value will update the revision.
        :param pulumi.Input[str] external_channel_uri: The address of the external channel of the API (e.g. the Developer Portal). Changes to this value will not affect the revision.
        :param pulumi.Input[str] intended_audience: Text briefly identifying the intended audience of the API. Changes to this value will not affect the revision.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels attach identifying metadata to resources. Identifying metadata can be used to filter list operations. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. No more than 64 user labels can be associated with one resource (System labels are excluded). See https://goo.gl/xmQnxf for more information and examples of labels. System reserved label keys are prefixed with "apigeeregistry.googleapis.com/" and cannot be changed.
        :param pulumi.Input[str] name: Resource name.
        """
        pulumi.set(__self__, "api_deployment_id", api_deployment_id)
        pulumi.set(__self__, "api_id", api_id)
        if access_guidance is not None:
            pulumi.set(__self__, "access_guidance", access_guidance)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if api_spec_revision is not None:
            pulumi.set(__self__, "api_spec_revision", api_spec_revision)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        if external_channel_uri is not None:
            pulumi.set(__self__, "external_channel_uri", external_channel_uri)
        if intended_audience is not None:
            pulumi.set(__self__, "intended_audience", intended_audience)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="apiDeploymentId")
    def api_deployment_id(self) -> pulumi.Input[str]:
        """
        Required. The ID to use for the deployment, which will become the final component of the deployment's resource name. This value should be 4-63 characters, and valid characters are /a-z-/. Following AIP-162, IDs must not have the form of a UUID.
        """
        return pulumi.get(self, "api_deployment_id")

    @api_deployment_id.setter
    def api_deployment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_deployment_id", value)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter(name="accessGuidance")
    def access_guidance(self) -> Optional[pulumi.Input[str]]:
        """
        Text briefly describing how to access the endpoint. Changes to this value will not affect the revision.
        """
        return pulumi.get(self, "access_guidance")

    @access_guidance.setter
    def access_guidance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_guidance", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Annotations attach non-identifying metadata to resources. Annotation keys and values are less restricted than those of labels, but should be generally used for small values of broad interest. Larger, topic- specific metadata should be stored in Artifacts.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="apiSpecRevision")
    def api_spec_revision(self) -> Optional[pulumi.Input[str]]:
        """
        The full resource name (including revision id) of the spec of the API being served by the deployment. Changes to this value will update the revision. Format: apis/{api}/deployments/{deployment}
        """
        return pulumi.get(self, "api_spec_revision")

    @api_spec_revision.setter
    def api_spec_revision(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_spec_revision", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A detailed description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-meaningful name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The address where the deployment is serving. Changes to this value will update the revision.
        """
        return pulumi.get(self, "endpoint_uri")

    @endpoint_uri.setter
    def endpoint_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_uri", value)

    @property
    @pulumi.getter(name="externalChannelUri")
    def external_channel_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The address of the external channel of the API (e.g. the Developer Portal). Changes to this value will not affect the revision.
        """
        return pulumi.get(self, "external_channel_uri")

    @external_channel_uri.setter
    def external_channel_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_channel_uri", value)

    @property
    @pulumi.getter(name="intendedAudience")
    def intended_audience(self) -> Optional[pulumi.Input[str]]:
        """
        Text briefly identifying the intended audience of the API. Changes to this value will not affect the revision.
        """
        return pulumi.get(self, "intended_audience")

    @intended_audience.setter
    def intended_audience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "intended_audience", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels attach identifying metadata to resources. Identifying metadata can be used to filter list operations. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. No more than 64 user labels can be associated with one resource (System labels are excluded). See https://goo.gl/xmQnxf for more information and examples of labels. System reserved label keys are prefixed with "apigeeregistry.googleapis.com/" and cannot be changed.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class Deployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_guidance: Optional[pulumi.Input[str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 api_deployment_id: Optional[pulumi.Input[str]] = None,
                 api_id: Optional[pulumi.Input[str]] = None,
                 api_spec_revision: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 endpoint_uri: Optional[pulumi.Input[str]] = None,
                 external_channel_uri: Optional[pulumi.Input[str]] = None,
                 intended_audience: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        CreateApiDeployment creates a specified deployment.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_guidance: Text briefly describing how to access the endpoint. Changes to this value will not affect the revision.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations attach non-identifying metadata to resources. Annotation keys and values are less restricted than those of labels, but should be generally used for small values of broad interest. Larger, topic- specific metadata should be stored in Artifacts.
        :param pulumi.Input[str] api_deployment_id: Required. The ID to use for the deployment, which will become the final component of the deployment's resource name. This value should be 4-63 characters, and valid characters are /a-z-/. Following AIP-162, IDs must not have the form of a UUID.
        :param pulumi.Input[str] api_spec_revision: The full resource name (including revision id) of the spec of the API being served by the deployment. Changes to this value will update the revision. Format: apis/{api}/deployments/{deployment}
        :param pulumi.Input[str] description: A detailed description.
        :param pulumi.Input[str] display_name: Human-meaningful name.
        :param pulumi.Input[str] endpoint_uri: The address where the deployment is serving. Changes to this value will update the revision.
        :param pulumi.Input[str] external_channel_uri: The address of the external channel of the API (e.g. the Developer Portal). Changes to this value will not affect the revision.
        :param pulumi.Input[str] intended_audience: Text briefly identifying the intended audience of the API. Changes to this value will not affect the revision.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels attach identifying metadata to resources. Identifying metadata can be used to filter list operations. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. No more than 64 user labels can be associated with one resource (System labels are excluded). See https://goo.gl/xmQnxf for more information and examples of labels. System reserved label keys are prefixed with "apigeeregistry.googleapis.com/" and cannot be changed.
        :param pulumi.Input[str] name: Resource name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        CreateApiDeployment creates a specified deployment.

        :param str resource_name: The name of the resource.
        :param DeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_guidance: Optional[pulumi.Input[str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 api_deployment_id: Optional[pulumi.Input[str]] = None,
                 api_id: Optional[pulumi.Input[str]] = None,
                 api_spec_revision: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 endpoint_uri: Optional[pulumi.Input[str]] = None,
                 external_channel_uri: Optional[pulumi.Input[str]] = None,
                 intended_audience: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentArgs.__new__(DeploymentArgs)

            __props__.__dict__["access_guidance"] = access_guidance
            __props__.__dict__["annotations"] = annotations
            if api_deployment_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_deployment_id'")
            __props__.__dict__["api_deployment_id"] = api_deployment_id
            if api_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_id'")
            __props__.__dict__["api_id"] = api_id
            __props__.__dict__["api_spec_revision"] = api_spec_revision
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["endpoint_uri"] = endpoint_uri
            __props__.__dict__["external_channel_uri"] = external_channel_uri
            __props__.__dict__["intended_audience"] = intended_audience
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["revision_create_time"] = None
            __props__.__dict__["revision_id"] = None
            __props__.__dict__["revision_update_time"] = None
        super(Deployment, __self__).__init__(
            'google-native:apigeeregistry/v1:Deployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Deployment':
        """
        Get an existing Deployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DeploymentArgs.__new__(DeploymentArgs)

        __props__.__dict__["access_guidance"] = None
        __props__.__dict__["annotations"] = None
        __props__.__dict__["api_spec_revision"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["endpoint_uri"] = None
        __props__.__dict__["external_channel_uri"] = None
        __props__.__dict__["intended_audience"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["revision_create_time"] = None
        __props__.__dict__["revision_id"] = None
        __props__.__dict__["revision_update_time"] = None
        return Deployment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessGuidance")
    def access_guidance(self) -> pulumi.Output[str]:
        """
        Text briefly describing how to access the endpoint. Changes to this value will not affect the revision.
        """
        return pulumi.get(self, "access_guidance")

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Annotations attach non-identifying metadata to resources. Annotation keys and values are less restricted than those of labels, but should be generally used for small values of broad interest. Larger, topic- specific metadata should be stored in Artifacts.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="apiSpecRevision")
    def api_spec_revision(self) -> pulumi.Output[str]:
        """
        The full resource name (including revision id) of the spec of the API being served by the deployment. Changes to this value will update the revision. Format: apis/{api}/deployments/{deployment}
        """
        return pulumi.get(self, "api_spec_revision")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Creation timestamp; when the deployment resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        A detailed description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Human-meaningful name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> pulumi.Output[str]:
        """
        The address where the deployment is serving. Changes to this value will update the revision.
        """
        return pulumi.get(self, "endpoint_uri")

    @property
    @pulumi.getter(name="externalChannelUri")
    def external_channel_uri(self) -> pulumi.Output[str]:
        """
        The address of the external channel of the API (e.g. the Developer Portal). Changes to this value will not affect the revision.
        """
        return pulumi.get(self, "external_channel_uri")

    @property
    @pulumi.getter(name="intendedAudience")
    def intended_audience(self) -> pulumi.Output[str]:
        """
        Text briefly identifying the intended audience of the API. Changes to this value will not affect the revision.
        """
        return pulumi.get(self, "intended_audience")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Labels attach identifying metadata to resources. Identifying metadata can be used to filter list operations. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. No more than 64 user labels can be associated with one resource (System labels are excluded). See https://goo.gl/xmQnxf for more information and examples of labels. System reserved label keys are prefixed with "apigeeregistry.googleapis.com/" and cannot be changed.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="revisionCreateTime")
    def revision_create_time(self) -> pulumi.Output[str]:
        """
        Revision creation timestamp; when the represented revision was created.
        """
        return pulumi.get(self, "revision_create_time")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> pulumi.Output[str]:
        """
        Immutable. The revision ID of the deployment. A new revision is committed whenever the deployment contents are changed. The format is an 8-character hexadecimal string.
        """
        return pulumi.get(self, "revision_id")

    @property
    @pulumi.getter(name="revisionUpdateTime")
    def revision_update_time(self) -> pulumi.Output[str]:
        """
        Last update timestamp: when the represented revision was last modified.
        """
        return pulumi.get(self, "revision_update_time")

