# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetOrganizationResult',
    'AwaitableGetOrganizationResult',
    'get_organization',
    'get_organization_output',
]

@pulumi.output_type
class GetOrganizationResult:
    def __init__(__self__, addons_config=None, analytics_region=None, apigee_project_id=None, attributes=None, authorized_network=None, billing_type=None, ca_certificate=None, created_at=None, customer_name=None, description=None, display_name=None, environments=None, expires_at=None, last_modified_at=None, name=None, portal_disabled=None, project=None, properties=None, runtime_database_encryption_key_name=None, runtime_type=None, state=None, subscription_type=None, type=None):
        if addons_config and not isinstance(addons_config, dict):
            raise TypeError("Expected argument 'addons_config' to be a dict")
        pulumi.set(__self__, "addons_config", addons_config)
        if analytics_region and not isinstance(analytics_region, str):
            raise TypeError("Expected argument 'analytics_region' to be a str")
        if analytics_region is not None:
            warnings.warn("""Required. DEPRECATED: This field will be deprecated once Apigee supports DRZ. Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).""", DeprecationWarning)
            pulumi.log.warn("""analytics_region is deprecated: Required. DEPRECATED: This field will be deprecated once Apigee supports DRZ. Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).""")

        pulumi.set(__self__, "analytics_region", analytics_region)
        if apigee_project_id and not isinstance(apigee_project_id, str):
            raise TypeError("Expected argument 'apigee_project_id' to be a str")
        pulumi.set(__self__, "apigee_project_id", apigee_project_id)
        if attributes and not isinstance(attributes, list):
            raise TypeError("Expected argument 'attributes' to be a list")
        pulumi.set(__self__, "attributes", attributes)
        if authorized_network and not isinstance(authorized_network, str):
            raise TypeError("Expected argument 'authorized_network' to be a str")
        pulumi.set(__self__, "authorized_network", authorized_network)
        if billing_type and not isinstance(billing_type, str):
            raise TypeError("Expected argument 'billing_type' to be a str")
        pulumi.set(__self__, "billing_type", billing_type)
        if ca_certificate and not isinstance(ca_certificate, str):
            raise TypeError("Expected argument 'ca_certificate' to be a str")
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if customer_name and not isinstance(customer_name, str):
            raise TypeError("Expected argument 'customer_name' to be a str")
        pulumi.set(__self__, "customer_name", customer_name)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if environments and not isinstance(environments, list):
            raise TypeError("Expected argument 'environments' to be a list")
        pulumi.set(__self__, "environments", environments)
        if expires_at and not isinstance(expires_at, str):
            raise TypeError("Expected argument 'expires_at' to be a str")
        pulumi.set(__self__, "expires_at", expires_at)
        if last_modified_at and not isinstance(last_modified_at, str):
            raise TypeError("Expected argument 'last_modified_at' to be a str")
        pulumi.set(__self__, "last_modified_at", last_modified_at)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if portal_disabled and not isinstance(portal_disabled, bool):
            raise TypeError("Expected argument 'portal_disabled' to be a bool")
        pulumi.set(__self__, "portal_disabled", portal_disabled)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if properties and not isinstance(properties, dict):
            raise TypeError("Expected argument 'properties' to be a dict")
        pulumi.set(__self__, "properties", properties)
        if runtime_database_encryption_key_name and not isinstance(runtime_database_encryption_key_name, str):
            raise TypeError("Expected argument 'runtime_database_encryption_key_name' to be a str")
        pulumi.set(__self__, "runtime_database_encryption_key_name", runtime_database_encryption_key_name)
        if runtime_type and not isinstance(runtime_type, str):
            raise TypeError("Expected argument 'runtime_type' to be a str")
        pulumi.set(__self__, "runtime_type", runtime_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subscription_type and not isinstance(subscription_type, str):
            raise TypeError("Expected argument 'subscription_type' to be a str")
        if subscription_type is not None:
            warnings.warn("""Output only. DEPRECATED: This will eventually be replaced by BillingType. Subscription type of the Apigee organization. Valid values include trial (free, limited, and for evaluation purposes only) or paid (full subscription has been purchased). See [Apigee pricing](https://cloud.google.com/apigee/pricing/).""", DeprecationWarning)
            pulumi.log.warn("""subscription_type is deprecated: Output only. DEPRECATED: This will eventually be replaced by BillingType. Subscription type of the Apigee organization. Valid values include trial (free, limited, and for evaluation purposes only) or paid (full subscription has been purchased). See [Apigee pricing](https://cloud.google.com/apigee/pricing/).""")

        pulumi.set(__self__, "subscription_type", subscription_type)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="addonsConfig")
    def addons_config(self) -> 'outputs.GoogleCloudApigeeV1AddonsConfigResponse':
        """
        Addon configurations of the Apigee organization.
        """
        return pulumi.get(self, "addons_config")

    @property
    @pulumi.getter(name="analyticsRegion")
    def analytics_region(self) -> str:
        """
        DEPRECATED: This field will be deprecated once Apigee supports DRZ. Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
        """
        return pulumi.get(self, "analytics_region")

    @property
    @pulumi.getter(name="apigeeProjectId")
    def apigee_project_id(self) -> str:
        """
        Apigee Project ID associated with the organization. Use this project to allowlist Apigee in the Service Attachment when using private service connect with Apigee.
        """
        return pulumi.get(self, "apigee_project_id")

    @property
    @pulumi.getter
    def attributes(self) -> Sequence[str]:
        """
        Not used by Apigee.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> str:
        """
        Compute Engine network used for Service Networking to be peered with Apigee runtime instances. See [Getting started with the Service Networking API](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started). Valid only when [RuntimeType](#RuntimeType) is set to `CLOUD`. The value must be set before the creation of a runtime instance and can be updated only when there are no runtime instances. For example: `default`. Apigee also supports shared VPC (that is, the host network project is not the same as the one that is peering with Apigee). See [Shared VPC overview](https://cloud.google.com/vpc/docs/shared-vpc). To use a shared VPC network, use the following format: `projects/{host-project-id}/{region}/networks/{network-name}`. For example: `projects/my-sharedvpc-host/global/networks/mynetwork` **Note:** Not supported for Apigee hybrid.
        """
        return pulumi.get(self, "authorized_network")

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> str:
        """
        Billing type of the Apigee organization. See [Apigee pricing](https://cloud.google.com/apigee/pricing).
        """
        return pulumi.get(self, "billing_type")

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> str:
        """
        Base64-encoded public certificate for the root CA of the Apigee organization. Valid only when [RuntimeType](#RuntimeType) is `CLOUD`.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Time that the Apigee organization was created in milliseconds since epoch.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customerName")
    def customer_name(self) -> str:
        """
        Not used by Apigee.
        """
        return pulumi.get(self, "customer_name")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the Apigee organization.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display name for the Apigee organization. Unused, but reserved for future use.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def environments(self) -> Sequence[str]:
        """
        List of environments in the Apigee organization.
        """
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> str:
        """
        Time that the Apigee organization is scheduled for deletion.
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> str:
        """
        Time that the Apigee organization was last modified in milliseconds since epoch.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Apigee organization.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="portalDisabled")
    def portal_disabled(self) -> bool:
        """
        Configuration for the Portals settings.
        """
        return pulumi.get(self, "portal_disabled")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        Project ID associated with the Apigee organization.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.GoogleCloudApigeeV1PropertiesResponse':
        """
        Properties defined in the Apigee organization profile.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="runtimeDatabaseEncryptionKeyName")
    def runtime_database_encryption_key_name(self) -> str:
        """
        Cloud KMS key name used for encrypting the data that is stored and replicated across runtime instances. Update is not allowed after the organization is created. Required when [RuntimeType](#RuntimeType) is `CLOUD`. If not specified when [RuntimeType](#RuntimeType) is `TRIAL`, a Google-Managed encryption key will be used. For example: "projects/foo/locations/us/keyRings/bar/cryptoKeys/baz". **Note:** Not supported for Apigee hybrid.
        """
        return pulumi.get(self, "runtime_database_encryption_key_name")

    @property
    @pulumi.getter(name="runtimeType")
    def runtime_type(self) -> str:
        """
        Runtime type of the Apigee organization based on the Apigee subscription purchased.
        """
        return pulumi.get(self, "runtime_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the organization. Values other than ACTIVE means the resource is not ready to use.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionType")
    def subscription_type(self) -> str:
        """
        DEPRECATED: This will eventually be replaced by BillingType. Subscription type of the Apigee organization. Valid values include trial (free, limited, and for evaluation purposes only) or paid (full subscription has been purchased). See [Apigee pricing](https://cloud.google.com/apigee/pricing/).
        """
        return pulumi.get(self, "subscription_type")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Not used by Apigee.
        """
        return pulumi.get(self, "type")


class AwaitableGetOrganizationResult(GetOrganizationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationResult(
            addons_config=self.addons_config,
            analytics_region=self.analytics_region,
            apigee_project_id=self.apigee_project_id,
            attributes=self.attributes,
            authorized_network=self.authorized_network,
            billing_type=self.billing_type,
            ca_certificate=self.ca_certificate,
            created_at=self.created_at,
            customer_name=self.customer_name,
            description=self.description,
            display_name=self.display_name,
            environments=self.environments,
            expires_at=self.expires_at,
            last_modified_at=self.last_modified_at,
            name=self.name,
            portal_disabled=self.portal_disabled,
            project=self.project,
            properties=self.properties,
            runtime_database_encryption_key_name=self.runtime_database_encryption_key_name,
            runtime_type=self.runtime_type,
            state=self.state,
            subscription_type=self.subscription_type,
            type=self.type)


def get_organization(organization_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationResult:
    """
    Gets the profile for an Apigee organization. See [Understanding organizations](https://cloud.google.com/apigee/docs/api-platform/fundamentals/organization-structure).
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:apigee/v1:getOrganization', __args__, opts=opts, typ=GetOrganizationResult).value

    return AwaitableGetOrganizationResult(
        addons_config=__ret__.addons_config,
        analytics_region=__ret__.analytics_region,
        apigee_project_id=__ret__.apigee_project_id,
        attributes=__ret__.attributes,
        authorized_network=__ret__.authorized_network,
        billing_type=__ret__.billing_type,
        ca_certificate=__ret__.ca_certificate,
        created_at=__ret__.created_at,
        customer_name=__ret__.customer_name,
        description=__ret__.description,
        display_name=__ret__.display_name,
        environments=__ret__.environments,
        expires_at=__ret__.expires_at,
        last_modified_at=__ret__.last_modified_at,
        name=__ret__.name,
        portal_disabled=__ret__.portal_disabled,
        project=__ret__.project,
        properties=__ret__.properties,
        runtime_database_encryption_key_name=__ret__.runtime_database_encryption_key_name,
        runtime_type=__ret__.runtime_type,
        state=__ret__.state,
        subscription_type=__ret__.subscription_type,
        type=__ret__.type)


@_utilities.lift_output_func(get_organization)
def get_organization_output(organization_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOrganizationResult]:
    """
    Gets the profile for an Apigee organization. See [Understanding organizations](https://cloud.google.com/apigee/docs/api-platform/fundamentals/organization-structure).
    """
    ...
