from __future__ import annotations

from tcsoa.gen.BusinessObjects import BusinessObject, Cfg0AbsConfiguratorWSO, Cfg0ConfiguratorPerspective, Cfg0AbsFamily, Cfg0AbsFamilyGroup
from tcsoa.gen.Internal.Configurator._2015_10.ConfiguratorManagement import Violation, BusinessObjectConfigExpression
from tcsoa.gen.Internal.Configurator._2017_11.ConfiguratorManagement import ConfigurationProfile
from typing import List
from tcsoa.gen.Server import ServiceData
from tcsoa.utils import TcBaseObj
from dataclasses import dataclass


@dataclass
class Variability(TcBaseObj):
    """
    The structure represents output variability information such as all configured model families, models, family
    groups, families and values.
    
    :var models: List of model families and their models. The list will not be in any specific order.
    :var groupedVariability: List of groups and their member families with values. The list will not be in any specific
    order.
    :var ungroupedVariability: List of ungrouped families and their vaues. The list will not be in any specific order.
    """
    models: List[FamilyInfo] = ()
    groupedVariability: List[GroupInfo] = ()
    ungroupedVariability: List[FamilyInfo] = ()


@dataclass
class ViolationList(TcBaseObj):
    """
    Structure contains violated rules along with the message and severity associated with rule violation. It is
    structure which represent Independent set of constraint rules which are responsible for conflict.
    
    :var statusCode: Status code.
    :var statusMessage: Status message
    :var violations: Set of violated rules which together are responsible for conflict.
    """
    statusCode: int = 0
    statusMessage: str = ''
    violations: List[Violation] = ()


@dataclass
class CellReference(TcBaseObj):
    """
    Represents address of a cell within an Expression Matrix.
    
    :var expressionToValidateClientID: Client ID of an Expression to validate. Client IDs are generated by callers of
    the this Operation. Callers of the Operation use it to correlate between Operation input and Operation output.
    :var scopeExpressionClientID: Client ID of a Scope Expression. Client IDs are generated by callers of the this
    Operation. Callers of the Operation use it to correlate between Operation input and Operation output.
    """
    expressionToValidateClientID: str = ''
    scopeExpressionClientID: str = ''


@dataclass
class CellValidationResult(TcBaseObj):
    """
    Structure containing list of structure instances which in turn contains pair of identifiers for expression to
    validate and scope expression along with validation operation output. It contains a one entry for each pair of
    expressions from input structure expressionMatrix and identified with list of pair of integers matrixSubset.
    
    :var cellClientIDs: Pair of identifiers where first identifier is of Expression to validate and second identifier
    is of scope Expression.
    :var verdictStruct: Validation operation output and Expression identifier information per processed Expression
    Matrix cell.
    """
    cellClientIDs: CellReference = None
    verdictStruct: ValidateProductConditionOutptStruct = None


@dataclass
class ConfigurationSessionInfoOutput(TcBaseObj):
    """
    The structure for retrieving a Product Configurator configuration session information. A Product Configurator
    session can be constructed using the session information.
    
    :var sessionConfigObject: The session configurable object of type VariantRule or Cfg0AbsConfiguratorCriteria for
    which the product information and Configuration Profile is retrieved.
    :var perspective: The Cfg0ConfiguratorPerspective instance which provides the product information used to select
    the features and constraints. The product information consists of a Cfg0ConfContext, RevisionRule, Effectivity,
    Rule Date.
    :var configProfile: The Configuration Profile information which contains the parameters governing the constraint
    evaluation behavior in a Product Configurator configuration session.
    """
    sessionConfigObject: BusinessObject = None
    perspective: Cfg0ConfiguratorPerspective = None
    configProfile: ConfigurationProfile = None


@dataclass
class ExpressionMatrix(TcBaseObj):
    """
    It is structure which pairs list of BusinessObjectConfigExpressions.
    
    :var expressionsToValidate: List of Expression(s) to validate.
    :var scopeExpressions: List of scope Expression(s) against which expressions from list expressionsToValidate to
    validate.
    """
    expressionsToValidate: List[BusinessObjectConfigExpression] = ()
    scopeExpressions: List[BusinessObjectConfigExpression] = ()


@dataclass
class FamilyInfo(TcBaseObj):
    """
    The FamilyInfo is a structure which represents family and the values belongs to it. Here family can be model family
    or option family or dynamic family and value can be model or option value or standalone feature.
    
    :var family: The Cfg0AbsFamily object.
    :var values: List of Cfg0AbsConfiguratorWSO objects, the objects can be objects of type, Cfg0AbsValue or
    Cfg0AbsFeature. The list of values will not be in any specific order.
    """
    family: Cfg0AbsFamily = None
    values: List[Cfg0AbsConfiguratorWSO] = ()


@dataclass
class GetConfigurationSessionInfoResponse(TcBaseObj):
    """
    The response structure for retrieving a number of Product Configurator configuration session information
    structures. A session information retrieved from a session configurable object is returned with the same object.
    The session information is retrieved as a combination of Cfg0ConfiguratorPerspective representing the product
    information and Configuration Profile which represents the parameters for constraint evaluation. The session
    information can be used to recreate a Product Configurator session. The service data returns partial error
    encountered in retrieving the session information from an input object against the index of the object in input
    list.
    
    :var configSessionInfos: A list of  session information retrieved from a session configurable object is returned
    with the same object. The session information is retrieved as a combination of Cfg0ConfiguratorPerspective
    representing the product information and Configuration Profile which represents the parameters for constraint
    evaluation. The session information can be used to recreate a Product Configurator session.
    :var serviceData: The service data returns partial error encountered in retrieving the session information from an
    input object against the index of the object in input list.
    """
    configSessionInfos: List[ConfigurationSessionInfoOutput] = ()
    serviceData: ServiceData = None


@dataclass
class GetVariabilityResponse(TcBaseObj):
    """
    The response structure is returned by the operation getVariablility. The list of variability in the output response
    will be populated in the sequence of input list of configurator perspectives in the request. If there is any
    failure, the service data will be populated with partial error at the same index of input configurator perspective.
    The variability can be all configured model families, models, groups, families and values.
    
    :var serviceData: The service data for errors and returned objects.
    :var variabilityList: List of model families and their models, list of groups and their families with values and
    ungrouped families with their values.
    """
    serviceData: ServiceData = None
    variabilityList: List[Variability] = ()


@dataclass
class GroupInfo(TcBaseObj):
    """
    The GroupInfo is a structure which represents configured group and the families belong to it.
    
    :var familyGroup: The Cfg0AbsFamilyGroup object.
    :var families: List of  familyGroup&rsquo;s member families with their values. The list of families will not be in
    any specific order.
    """
    familyGroup: Cfg0AbsFamilyGroup = None
    families: List[FamilyInfo] = ()


@dataclass
class MatrixCell(TcBaseObj):
    """
    It is structure which represents a pair of integer.
    
    :var rowIndex: Integer type object.
    :var columnIndex: Integer type object.
    """
    rowIndex: int = 0
    columnIndex: int = 0


@dataclass
class ValidateProductConditionOutptStruct(TcBaseObj):
    """
    Validation operation output information.
    
    :var criteriaStatus: The status of the configuration. 
    Valid values are: validAndComplete, validAndInComplete or inValid. 
    validAndComplete: All mandatory families in configuration have value selections. 
    validAndInComplete: Not all mandatory families in configuration have value selections. 
    inValid: There are some violations .
    :var conflicts: List of conflicts that was identified for a given cell in the validation matrix. A conflict is
    represented by a list of constraint rule violations
    """
    criteriaStatus: str = ''
    conflicts: List[ViolationList] = ()


@dataclass
class ValidateProductConditionResponse(TcBaseObj):
    """
    The response structure for the operation validateProductConditions.
    
    :var serviceData: The service data for errors and returned objects.
    :var validationResults: Validation operation output information along with identifiers of input Expressions for
    input and output correlation.
    """
    serviceData: ServiceData = None
    validationResults: List[CellValidationResult] = ()
