from __future__ import annotations

from tcsoa.gen.BusinessObjects import ItemRevision, BusinessObject, Folder, WorkspaceObject, Dataset, Item
from tcsoa.gen.Cad._2007_01.DataManagement import RelationAndTypesFilter2, ExpandFoldersForCADItemOutput, ExpandFoldersForCADItemRevOutput, ExtraObjectOutput
from typing import List
from tcsoa.gen.Server import ServiceData
from tcsoa.utils import TcBaseObj
from dataclasses import dataclass
from datetime import datetime


@dataclass
class ExpandFolderForCADPref2(TcBaseObj):
    """
    Contains a list of 'RelationAndTypesFilter', number of latest revisions for further filtering and a flag to check
    whether item revision needs to be expanded and list of other object types to return from the folder contents.
    
    :var expItemRev: Flag to specify if the datasets attached to the item revisions are to be returned. If set to TRUE
    then all datasets owned by each item revision will be returned with the item revision.
    :var latestNRevs: The number of revisions under an item that should be considered for further filtering. If there
    are 5 versions of an item and this option is set to 2 then versions 4 and 5 will be processed. 0 = do not return
    any item revisions. minus 1 = return all item revisions.
    :var info: A list of 'RelationAndTypesFilter2' structures to select the datasets under an item revision to return.
    If empty then all dataset will be returned.
    :var contentTypesFilter: A list of object types. Any objects in any input folder that are of the type in this list
    will also be returned.
    """
    expItemRev: bool = False
    latestNRevs: int = 0
    info: List[RelationAndTypesFilter2] = ()
    contentTypesFilter: List[str] = ()


@dataclass
class ExpandFoldersForCADOutput2(TcBaseObj):
    """
    Contains the folder expanded and the results of expanding the folder based on the input preference.
    
    :var inputFolder: The folder that was expanded.
    :var fstlvlFolders: A list of folders contained by the input folder.
    :var itemsOutput: A list of 'ExpandFolderForCADItemOutput' which has information about the items in the folder.
    :var itemRevsOutput: A list of 'ExpandFolderForCADItemRevOutput' which has information about the item revisions in
    the folder.
    :var contents: A list of objects in the folder that are a type listed in the 'contentTypesFilter' input.
    """
    inputFolder: Folder = None
    fstlvlFolders: List[Folder] = ()
    itemsOutput: List[ExpandFoldersForCADItemOutput] = ()
    itemRevsOutput: List[ExpandFoldersForCADItemRevOutput] = ()
    contents: List[WorkspaceObject] = ()


@dataclass
class ExpandFoldersForCADResponse2(TcBaseObj):
    """
    Contains the response for 'ExpandFoldersForCAD' operation.
    
    :var output: A list of 'ExpandFoldersForCADOutput2' which has information about the input folder and folders, items
    and item revisions output found under this folder
    :var serviceData: Contains the folders, items, items revisions, datasets, and other object types in the list of
    plain objects. 
    Error information returned is identified by the folder tag sent to the service and will include system errors plus
    errors generated by this service :
       7007 : Input folder is invalid.
    215121 : Object passed in is not a folder.
    """
    output: List[ExpandFoldersForCADOutput2] = ()
    serviceData: ServiceData = None


@dataclass
class ExtraObjectInfo(TcBaseObj):
    """
    Form objects that can be created or updated and related to an item, item revision or dataset.
    
    :var object: Object reference for existing object
    :var clientId: Identifier defined by user to track the related object.
    :var relationTypeName: Name of the relation type to the parent object
    :var typeName: Object Type name
    :var attrNameValuePairs: List of AttributeInfos.
    """
    object: BusinessObject = None
    clientId: str = ''
    relationTypeName: str = ''
    typeName: str = ''
    attrNameValuePairs: List[AttributeInfo] = ()


@dataclass
class ItemInfo(TcBaseObj):
    """
    the ItemInfo structure represents all of the data necessary to construct the item object.
    The basic attributes that are required are passed as named elements in the structure.
    All other attributes are passed as name/value pairs in the AttributeInfo structure.
    The extraObject field allows for the creation of an object(s) that will be related to this newly created Item.
    
    :var item: Item object reference for update, can be null for creation
    :var itemId: ID for create, generated if null
    :var itemType: Type, default is Item if null
    :var name: Name, defaulted to id if null
    :var description: Description, can be null
    :var attrList: List of AttributeInfos
    :var extraObject: List of ExtraObjectInfos
    :var folder: Folder to attach Item to, if null then default used
    """
    item: Item = None
    itemId: str = ''
    itemType: str = ''
    name: str = ''
    description: str = ''
    attrList: List[AttributeInfo] = ()
    extraObject: List[ExtraObjectInfo] = ()
    folder: Folder = None


@dataclass
class ItemRevInfo(TcBaseObj):
    """
    the ItemRevInfo structure represents all of the data necessary to construct the item revision object.
    The basic attributes that are required are passed as named elements in the struct.
    All other attributes are passed as name/value pairs in the AttributeInfo structure.
    The extraObject field allows for the creation of an object(s) that will be related to this newly created Item
    Revision.
    
    :var itemRevision: ItemRevision object reference, null for creation, otherwise update
    :var revId: ID, if null then generated
    :var attrList: List of AttributeInfos
    :var extraObject: List ofr ExtraObjectInfos
    """
    itemRevision: ItemRevision = None
    revId: str = ''
    attrList: List[AttributeInfo] = ()
    extraObject: List[ExtraObjectInfo] = ()


@dataclass
class NamedReferenceObjectInfo(TcBaseObj):
    """
    Contains information regarding named reference type value, object reference, object type name and list of attribute
    information to set on the object.
    
    :var clientId: Identifier defined by client to track the related object.
    :var object: Object reference of the object for update, null for create.
    :var namedReferenceName: The Named Reference from the dataset to this object, required. NamedReference values  are
    defined for each Dataset type. The customer can add more values as needed. To get a current list of valid Named
    Reference values the programmer can either use BMIDE or can call the SOA Core service getDatasetTypeIno.
    :var namedReferenceType: The reference type name from the dataset to this object, must be either AE_ASSOCIATION or
    AE_PART_OF.
    :var typeName: Type of the object to be created. Required for object creation only.
    :var attrNameValuePairs: List of attribute information.
    """
    clientId: str = ''
    object: BusinessObject = None
    namedReferenceName: str = ''
    namedReferenceType: str = ''
    typeName: str = ''
    attrNameValuePairs: List[AttributeInfo] = ()


@dataclass
class AttributeInfo(TcBaseObj):
    """
    This structure allows the caller define or update named attributes.
    The name member represents the property name for the related object and the value is the value to set.
    
    :var name: Text for attribute name
    :var values: Text for attribute value
    """
    name: str = ''
    values: List[str] = ()


@dataclass
class PartInfo(TcBaseObj):
    """
    The PartInfo struct is the main input to the createOrUpdateParts service for boundingbox. This structure refers to
    the Item, ItemRevision, and one or more Dataset structures used to create those objects.
    
    :var clientId: Identifier defined by user to track the related object.
    :var itemInput: Member of type ItemInfo
    :var itemRevInput: Member of type ItemRevInfo
    :var datasetInput: List of DatasetInfos
    """
    clientId: str = ''
    itemInput: ItemInfo = None
    itemRevInput: ItemRevInfo = None
    datasetInput: List[DatasetInfo] = ()


@dataclass
class BoundingBox(TcBaseObj):
    """
    Holds the boundingbox co-ordinates  information.
    
    :var xmin: BoundingBox x-coordinate min value in double
    :var ymin: BoundingBox y-coordinate min value in double
    :var zmin: BoundingBox z-coordinate min value in double
    :var xmax: BoundingBox x-coordinate max value in double
    :var ymax: BoundingBox y-coordinate max value in double
    :var zmax: BoundingBox z-coordinate max value in double
    """
    xmin: float = 0.0
    ymin: float = 0.0
    zmin: float = 0.0
    xmax: float = 0.0
    ymax: float = 0.0
    zmax: float = 0.0


@dataclass
class CommitDatasetFileInfo(TcBaseObj):
    """
    Holds the basic info for a file to be uploaded to a dataset.
    
    :var dataset: 'Dataset' object reference.
    :var createNewVersion: Flag to create new version ( TRUE ) or not ( FALSE ).
    :var datasetFileTicketInfos: A list of 'DatasetFileTicketInfos' which contains file ticket information for the
    dataset file.
    """
    dataset: Dataset = None
    createNewVersion: bool = False
    datasetFileTicketInfos: List[DatasetFileTicketInfo] = ()


@dataclass
class CreateOrUpdatePartsOutput(TcBaseObj):
    """
    Contains the output response structure for createOrUpdateParts operation.
    
    :var clientId: Identifier defined by user to track the related object.
    :var item: Item object reference of the created/updated item
    :var itemRev: ItemRevision object reference of the created/updated item revision
    :var datasetOutput: List of DatasetOutputs
    :var extraItemObjs: List of ExtraObjectOutputs for the item extra objects
    :var extraItemRevObjs: List of ExtraObjectOutputs for the item revision extra objects
    """
    clientId: str = ''
    item: Item = None
    itemRev: ItemRevision = None
    datasetOutput: List[DatasetOutput] = ()
    extraItemObjs: List[ExtraObjectOutput] = ()
    extraItemRevObjs: List[ExtraObjectOutput] = ()


@dataclass
class CreateOrUpdatePartsResponse(TcBaseObj):
    """
    Holds the response for createOrUpdateParts
    
    :var output: List of CreateOrUpdatePartsOutputs.
    :var serviceData: The SOA framework object containing objects that were created, deleted, or updated by the
    Service, plain objects, and error information.
    """
    output: List[CreateOrUpdatePartsOutput] = ()
    serviceData: ServiceData = None


@dataclass
class DatasetFileInfo(TcBaseObj):
    """
    Holds the basic info for a file to be uploaded to a dataset.
    
    :var clientId: Identifier defined by user to track the related object.
    :var fileName: Name of file to be uploaded.  Filename only, should not contain path to filename.
    :var namedReferencedName: Named Reference relation to file.
    :var isText: Flag to indicate if file is text ( TRUE ) or binary (FALSE ).
    :var allowReplace: Flag to indicate if file can be overwritten ( TRUE ) or not ( FALSE ).
    :var boundingBoxesAvailable: Flag to indicate BoundingBoxes are available.
    :var boundingBoxes: List of BoundingBoxes.
    """
    clientId: str = ''
    fileName: str = ''
    namedReferencedName: str = ''
    isText: bool = False
    allowReplace: bool = False
    boundingBoxesAvailable: bool = False
    boundingBoxes: List[BoundingBox] = ()


@dataclass
class DatasetFileTicketInfo(TcBaseObj):
    """
    Holds the basic info for a file to be uploaded to a dataset.
    
    :var datasetFileInfo: Member of type DatasetFileInfo.
    :var ticket: ID of ticket.
    """
    datasetFileInfo: DatasetFileInfo = None
    ticket: str = ''


@dataclass
class DatasetInfo(TcBaseObj):
    """
    The DatasetInfo struct represents all of the data necessary to construct the dataset object.
    The basic attributes that are required are passed as named elements in the structure.
    All other attributes are passed as name/value pairs in the AttributeInfo structure.
    The extraObject field allows for the creation of an object(s) that will be related to this newly created Dataset.
    
    :var clientId: Identifier defined by user to track the related object.
    :var dataset: Dataset object reference for update, null for creation
    :var createNewVersion: Flag to create new version ( TRUE ) or not (FALSE )
    :var mapAttributesWithoutDataset: Flag to indicate whether DatasetInfo should be used for mapping attributes or for
    create.
    :var namedReferencePreference: Preference name which holds the list of named references to delete from one Dataset
    version to the next
    :var attrList: List of AttributeInfos for attributes
    :var mappingAttributes: List of AttributeInfos for mapped attributes. Mapped atributes are attributes that are
    applied to other objects. Refere to the ITK manual for a definition of attribute mapping.
    :var extraObject: List of ExtraObjectInfos
    :var datasetFileInfos: List of DatasetFileInfos
    :var namedReferenceObjectInfos: List of NamedReferenceObjectInfos
    :var name: Name attribute value
    :var basisName: basisName
    :var description: Description attribute value
    :var type: Type attribute value
    :var lastModifiedOfDataset: lastModifiedOfDataset
    :var id: ID attribute value
    :var datasetRev: Revision attribute value
    :var itemRevRelationName: Can be null, defaulted
    """
    clientId: str = ''
    dataset: Dataset = None
    createNewVersion: bool = False
    mapAttributesWithoutDataset: bool = False
    namedReferencePreference: str = ''
    attrList: List[AttributeInfo] = ()
    mappingAttributes: List[AttributeInfo] = ()
    extraObject: List[ExtraObjectInfo] = ()
    datasetFileInfos: List[DatasetFileInfo] = ()
    namedReferenceObjectInfos: List[NamedReferenceObjectInfo] = ()
    name: str = ''
    basisName: str = ''
    description: str = ''
    type: str = ''
    lastModifiedOfDataset: datetime = None
    id: str = ''
    datasetRev: str = ''
    itemRevRelationName: str = ''


@dataclass
class DatasetOutput(TcBaseObj):
    """
    Contains created/updated dataset.
    
    :var clientId: Identifier defined by user to track the related object.
    :var dataset: Dataset object reference of the created/updated dataset
    :var commitInfo: List of 'CommitDatasetFileInfos'
    :var extraObjs: List of 'ExtraObjectOutputs' for the extra objects
    :var namedRefObjs: List of 'ExtraObjectOutputs' for the named references
    """
    clientId: str = ''
    dataset: Dataset = None
    commitInfo: List[CommitDatasetFileInfo] = ()
    extraObjs: List[ExtraObjectOutput] = ()
    namedRefObjs: List[ExtraObjectOutput] = ()
