"""Record vital stats for each 2015 BJCP beer style as dictionary of dictionaries."""

# Floating point numbers are multiplied by 1000 to avoid issues with ranges of floats and
# 1 is added in some cases to create inclusive ranges.
dict_of_styles={
'american_light_lager':{'OG': range (1028, 1042), 'FG': range (998, 1009), 'ABV': range (2800, 4201), 'IBU': range (8000, 12001), 'SRM': range (2000, 3001)},
'american_lager':{'OG': range (1040, 1052), 'FG': range (1004, 1012), 'ABV': range (4200, 5301), 'IBU': range (8000, 18001), 'SRM': range (2000, 4001)},
'cream_ale':{'OG': range (1042, 1056), 'FG': range (1006, 1013), 'ABV': range (4200, 5601), 'IBU': range (8000, 20001), 'SRM': range (2500, 5001)},
'american_wheat_beer':{'OG': range (1040, 1056), 'FG': range (1008, 1014), 'ABV': range (4000, 5501), 'IBU': range (15000, 30001), 'SRM': range (3000, 6001)},
'international_pale_lager':{'OG': range (1042, 1052), 'FG': range (1008, 1013), 'ABV': range (4600, 6001), 'IBU': range (18000, 25001), 'SRM': range (2000, 6001)},
'international_amber_lager':{'OG': range (1042, 1056), 'FG': range (1008, 1015), 'ABV': range (4600, 6001), 'IBU': range (8000, 25001), 'SRM': range (7000, 14001)},
'international_dark_lager':{'OG': range (1044, 1057), 'FG': range (1008, 1013), 'ABV': range (4200, 6001), 'IBU': range (8000, 25001), 'SRM': range (14000, 22001)},
'czech_pale_lager':{'OG': range (1028, 1045), 'FG': range (1008, 1015), 'ABV': range (3000, 4101), 'IBU': range (20000, 35001), 'SRM': range (3000, 6001)},
'czech_premium_pale_lager':{'OG': range (1044, 1062), 'FG': range (1013, 1018), 'ABV': range (4200, 5801), 'IBU': range (30000, 45001), 'SRM': range (3500, 6001)},
'czech_amber_lager':{'OG': range (1044, 1062), 'FG': range (1013, 1018), 'ABV': range (4400, 5801), 'IBU': range (20000, 35001), 'SRM': range (10000, 16001)},
'czech_dark_lager':{'OG': range (1044, 1062), 'FG': range (1013, 1018), 'ABV': range (4400, 5801), 'IBU': range (18000, 34001), 'SRM': range (14000, 35001)},
'munich_helles':{'OG': range (1044, 1049), 'FG': range (1006, 1013), 'ABV': range (4700, 5401), 'IBU': range (16000, 22001), 'SRM': range (3000, 5001)},
'festbier':{'OG': range (1054, 1058), 'FG': range (1010, 1013), 'ABV': range (5800, 6301), 'IBU': range (18000, 25001), 'SRM': range (4000, 7001)},
'helles_bock':{'OG': range (1064, 1073), 'FG': range (1011, 1019), 'ABV': range (6300, 7401), 'IBU': range (23000, 35001), 'SRM': range (6000, 11001)},
'german_leichtbier':{'OG': range (1026, 1035), 'FG': range (1006, 1012), 'ABV': range (2400, 3601), 'IBU': range (15000, 28001), 'SRM': range (2000, 5001)},
'kolsch':{'OG': range (1044, 1052), 'FG': range (1007, 1012), 'ABV': range (4400, 5201), 'IBU': range (18000, 30001), 'SRM': range (10000, 16001)},
'german_helles_exportbier':{'OG': range (1048, 1057), 'FG': range (1010, 1016), 'ABV': range (4800, 6001), 'IBU': range (20000, 30001), 'SRM': range (4000, 7001)},
'german_pils':{'OG': range (1044, 1052), 'FG': range (1008, 1014), 'ABV': range (4400, 5201), 'IBU': range (22000, 40001), 'SRM': range (2000, 5001)},
'marzen':{'OG': range (1054, 1062), 'FG': range (1010, 1015), 'ABV': range (5800, 6301), 'IBU': range (18000, 24001), 'SRM': range (8000, 17001)},
'rauchbier':{'OG': range (1050, 1058), 'FG': range (1012, 1017), 'ABV': range (4800, 6001), 'IBU': range (20000, 30001), 'SRM': range (12000, 22001)},
'dunkles_bock':{'OG': range (1064, 1073), 'FG': range (1013, 1020), 'ABV': range (6300, 7201), 'IBU': range (20000, 27001), 'SRM': range (14000, 22001)},
'vienna_lager':{'OG': range (1048, 1056), 'FG': range (1010, 1015), 'ABV': range (4700, 5501), 'IBU': range (18000, 30001), 'SRM': range (9000, 15001)},
'altbier':{'OG': range (1044, 1053), 'FG': range (1008, 1015), 'ABV': range (4300, 5501), 'IBU': range (25000, 50001), 'SRM': range (11000, 17001)},
'pale_kellerbier':{'OG': range (1045, 1052), 'FG': range (1008, 1013), 'ABV': range (4700, 5401), 'IBU': range (20000, 35001), 'SRM': range (3000, 7001)},
'amber_kellerbier':{'OG': range (1048, 1055), 'FG': range (1012, 1017), 'ABV': range (4800, 5401), 'IBU': range (25000, 40001), 'SRM': range (7000, 17001)},
'munich_dunkel':{'OG': range (1048, 1057), 'FG': range (1010, 1017), 'ABV': range (4500, 5601), 'IBU': range (18000, 28001), 'SRM': range (14000, 28001)},
'schwarzbier':{'OG': range (1046, 1053), 'FG': range (1010, 1017), 'ABV': range (4400, 5401), 'IBU': range (20000, 30001), 'SRM': range (17000, 30001)},
'doppelbock':{'OG': range (1072, 1113), 'FG': range (1016, 1025), 'ABV': range (7000, 10001), 'IBU': range (16000, 26001), 'SRM': range (6000, 25001)},
'eisbock':{'OG': range (1078, 1121), 'FG': range (1020, 1035), 'ABV': range (9000, 14001), 'IBU': range (25000, 35001), 'SRM': range (18000, 30001)},
'baltic_porter':{'OG': range (1060, 1091), 'FG': range (1016, 1025), 'ABV': range (6500, 9501), 'IBU': range (20000, 40001), 'SRM': range (17000, 30001)},
'weissbier':{'OG': range (1044, 1053), 'FG': range (1010, 1015), 'ABV': range (4300, 5601), 'IBU': range (8000, 15001), 'SRM': range (2000, 6001)},
'dunkles_weissbier':{'OG': range (1044, 1057), 'FG': range (1010, 1015), 'ABV': range (4300, 5601), 'IBU': range (10000, 18001), 'SRM': range (14000, 23001)},
'weizenbock':{'OG': range (1064, 1091), 'FG': range (1015, 1023), 'ABV': range (6500, 9001), 'IBU': range (15000, 30001), 'SRM': range (6000, 25001)},
'ordinary_bitter':{'OG': range (1030, 1040), 'FG': range (1007, 1012), 'ABV': range (3200, 3801), 'IBU': range (25000, 35001), 'SRM': range (8000, 14001)},
'best_bitter':{'OG': range (1040, 1049), 'FG': range (1008, 1013), 'ABV': range (3800, 4601), 'IBU': range (25000, 40001), 'SRM': range (8000, 16001)},
'strong_bitter':{'OG': range (1048, 1060), 'FG': range (1010, 1017), 'ABV': range (4600, 6201), 'IBU': range (30000, 50001), 'SRM': range (8000, 18001)},
'british_golden_ale':{'OG': range (1038, 1054), 'FG': range (1006, 1013), 'ABV': range (3800, 5001), 'IBU': range (20000, 45001), 'SRM': range (2000, 6001)},
'australian_sparkling_ale':{'OG': range (1038, 1051), 'FG': range (1004, 1007), 'ABV': range (4500, 6001), 'IBU': range (20000, 35001), 'SRM': range (4000, 7001)},
'english_ipa':{'OG': range (1050, 1075), 'FG': range (1010, 1019), 'ABV': range (5000, 7501), 'IBU': range (40000, 60001), 'SRM': range (6000, 14001)},
'dark_mild':{'OG': range (1030, 1039), 'FG': range (1008, 1014), 'ABV': range (3000, 3801), 'IBU': range (10000, 25001), 'SRM': range (12000, 25001)},
'british_brown_ale':{'OG': range (1040, 1053), 'FG': range (1008, 1014), 'ABV': range (4200, 5401), 'IBU': range (20000, 30001), 'SRM': range (12000, 22001)},
'english_porter':{'OG': range (1040, 1053), 'FG': range (1008, 1015), 'ABV': range (4000, 5401), 'IBU': range (18000, 35001), 'SRM': range (20000, 30001)},
'scottish_light':{'OG': range (1030, 1036), 'FG': range (1010, 1014), 'ABV': range (2500, 3201), 'IBU': range (10000, 20001), 'SRM': range (17000, 22001)},
'scottish_heavy':{'OG': range (1035, 1041), 'FG': range (1010, 1016), 'ABV': range (3200, 3901), 'IBU': range (10000, 20001), 'SRM': range (13000, 22001)},
'scottish_export':{'OG': range (1040, 1061), 'FG': range (1010, 1017), 'ABV': range (3900, 6001), 'IBU': range (15000, 30001), 'SRM': range (13000, 22001)},
'irish_red_ale':{'OG': range (1036, 1047), 'FG': range (1010, 1015), 'ABV': range (3800, 5001), 'IBU': range (18000, 28001), 'SRM': range (9000, 14001)},
'irish_stout':{'OG': range (1036, 1045), 'FG': range (1007, 1012), 'ABV': range (4000, 4501), 'IBU': range (25000, 45001), 'SRM': range (25000, 40001)},
'irish_extra_stout':{'OG': range (1052, 1063), 'FG': range (1010, 1015), 'ABV': range (5500, 6501), 'IBU': range (35000, 50001), 'SRM': range (25000, 40001)},
'sweet_stout':{'OG': range (1044, 1061), 'FG': range (1012, 1025), 'ABV': range (4000, 6001), 'IBU': range (20000, 40001), 'SRM': range (30000, 40001)},
'oatmeal_stout':{'OG': range (1045, 1066), 'FG': range (1010, 1019), 'ABV': range (4200, 5901), 'IBU': range (25000, 40001), 'SRM': range (22000, 40001)},
'tropical_stout':{'OG': range (1056, 1076), 'FG': range (1010, 1019), 'ABV': range (5500, 8001), 'IBU': range (30000, 50001), 'SRM': range (30000, 40001)},
'foreign_extra_stout':{'OG': range (1056, 1076), 'FG': range (1010, 1019), 'ABV': range (6300, 8001), 'IBU': range (50000, 70001), 'SRM': range (30000, 40001)},
'british_strong_ale':{'OG': range (1055, 1081), 'FG': range (1015, 1023), 'ABV': range (5500, 8001), 'IBU': range (30000, 60001), 'SRM': range (8000, 22001)},
'old_ale':{'OG': range (1055, 1089), 'FG': range (1015, 1023), 'ABV': range (5500, 9001), 'IBU': range (30000, 60001), 'SRM': range (10000, 22001)},
'wee_heavy':{'OG': range (1070, 1131), 'FG': range (1018, 1041), 'ABV': range (6500, 10001), 'IBU': range (17000, 35001), 'SRM': range (14000, 35001)},
'english_barleywine':{'OG': range (1080, 1121), 'FG': range (1018, 1031), 'ABV': range (8000, 12001), 'IBU': range (35000, 70001), 'SRM': range (8000, 22001)},
'blonde_ale':{'OG': range (1038, 1055), 'FG': range (1008, 1014), 'ABV': range (3800, 5501), 'IBU': range (15000, 28001), 'SRM': range (3000, 6001)},
'american_pale_ale':{'OG': range (1045, 1061), 'FG': range (1010, 1016), 'ABV': range (4500, 6201), 'IBU': range (30000, 50001), 'SRM': range (5000, 10001)},
'american_amber_ale':{'OG': range (1045, 1061), 'FG': range (1010, 1016), 'ABV': range (4500, 6201), 'IBU': range (25000, 40001), 'SRM': range (10000, 17001)},
'california_common':{'OG': range (1048, 1055), 'FG': range (1011, 1015), 'ABV': range (4500, 5501), 'IBU': range (30000, 45001), 'SRM': range (10000, 14001)},
'american_brown_ale':{'OG': range (1045, 1061), 'FG': range (1010, 1017), 'ABV': range (4300, 6201), 'IBU': range (20000, 30001), 'SRM': range (18000, 35001)},
'american_porter':{'OG': range (1050, 1071), 'FG': range (1012, 1018), 'ABV': range (4800, 6501), 'IBU': range (25000, 50001), 'SRM': range (22000, 40001)},
'american_stout':{'OG': range (1050, 1076), 'FG': range (1010, 1023), 'ABV': range (5000, 7501), 'IBU': range (35000, 75001), 'SRM': range (30000, 40001)},
'imperial_stout':{'OG': range (1075, 1116), 'FG': range (1018, 1031), 'ABV': range (8000, 12001), 'IBU': range (50000, 90001), 'SRM': range (30000, 40001)},
'american_ipa':{'OG': range (1056, 1071), 'FG': range (1008, 1015), 'ABV': range (5500, 7501), 'IBU': range (40000, 70001), 'SRM': range (6000, 14001)},
'belgian_ipa':{'OG': range (1058, 1081), 'FG': range (1008, 1017), 'ABV': range (6200, 9501), 'IBU': range (50000, 100001), 'SRM': range (5000, 15001)},
'black_ipa':{'OG': range (1050, 1086), 'FG': range (1010, 1019), 'ABV': range (5500, 9001), 'IBU': range (50000, 90001), 'SRM': range (25000, 40001)},
'brown_ipa':{'OG': range (1056, 1071), 'FG': range (1008, 1017), 'ABV': range (5500, 7501), 'IBU': range (40000, 70001), 'SRM': range (11000, 19001)},
'red_ipa':{'OG': range (1056, 1071), 'FG': range (1008, 1017), 'ABV': range (5500, 7501), 'IBU': range (40000, 70001), 'SRM': range (11000, 19001)},
'rye_ipa':{'OG': range (1056, 1076), 'FG': range (1008, 1015), 'ABV': range (5500, 8001), 'IBU': range (50000, 75001), 'SRM': range (6000, 14001)},
'white_ipa':{'OG': range (1056, 1066), 'FG': range (1008, 1017), 'ABV': range (5500, 7001), 'IBU': range (40000, 70001), 'SRM': range (5000, 8001)},
'double_ipa':{'OG': range (1065, 1085), 'FG': range (1008, 1019), 'ABV': range (7500, 10001), 'IBU': range (60000, 120001), 'SRM': range (6000, 14001)},
'american_strong_ale':{'OG': range (1062, 1091), 'FG': range (1014, 1025), 'ABV': range (6300, 10001), 'IBU': range (50000, 100001), 'SRM': range (7000, 19001)},
'american_barleywine':{'OG': range (1080, 1121), 'FG': range (1016, 1031), 'ABV': range (8000, 12001), 'IBU': range (50000, 100001), 'SRM': range (10000, 19001)},
'wheatwine':{'OG': range (1080, 1121), 'FG': range (1016, 1031), 'ABV': range (8000, 12001), 'IBU': range (30000, 60001), 'SRM': range (8000, 15001)},
'berliner_weisse':{'OG': range (1028, 1033), 'FG': range (1003, 1007), 'ABV': range (2800, 3801), 'IBU': range (3000, 8001), 'SRM': range (2000, 3001)},
'flanders_red_ale':{'OG': range (1048, 1058), 'FG': range (1002, 1013), 'ABV': range (4600, 6501), 'IBU': range (10000, 25001), 'SRM': range (10000, 16001)},
'oud_bruin':{'OG': range (1040, 1075), 'FG': range (1008, 1013), 'ABV': range (4000, 8001), 'IBU': range (20000, 25001), 'SRM': range (15000, 22001)},
'lambic':{'OG': range (1040, 1055), 'FG': range (1001, 1011), 'ABV': range (5000, 6501), 'IBU': range (0000, 10001), 'SRM': range (3000, 7001)},
'gueuze':{'OG': range (1040, 1061), 'FG': range (1000, 1006), 'ABV': range (5000, 8001), 'IBU': range (0000, 10001), 'SRM': range (3000, 7001)},
'fruit_lambic':{'OG': range (1040, 1061), 'FG': range (1000, 1011), 'ABV': range (5000, 7001), 'IBU': range (0000, 10001), 'SRM': range (3000, 7001)},
'witbier':{'OG': range (1044, 1053), 'FG': range (1008, 1012), 'ABV': range (4500, 5501), 'IBU': range (8000, 20001), 'SRM': range (2000, 4001)},
'belgian_pale_ale':{'OG': range (1048, 1055), 'FG': range (1010, 1015), 'ABV': range (4800, 5501), 'IBU': range (20000, 30001), 'SRM': range (8000, 14001)},
'biere_de_garde':{'OG': range (1060, 1081), 'FG': range (1008, 1017), 'ABV': range (6000, 8501), 'IBU': range (18000, 28001), 'SRM': range (6000, 19001)},
'belgian_blond_ale':{'OG': range (1062, 1076), 'FG': range (1008, 1019), 'ABV': range (6000, 7501), 'IBU': range (15000, 30001), 'SRM': range (4000, 7001)},
'saison':{'OG': range (1048, 1066), 'FG': range (1002, 1010), 'ABV': range (3500, 9501), 'IBU': range (20000, 35001), 'SRM': range (5000, 22001)},
'belgian_golden_strong_ale':{'OG': range (1070, 1096), 'FG': range (1005, 1017), 'ABV': range (7500, 10501), 'IBU': range (22000, 35001), 'SRM': range (3000, 6001)},
'trappist_single':{'OG': range (1044, 1055), 'FG': range (1004, 1011), 'ABV': range (4800, 6001), 'IBU': range (25000, 45001), 'SRM': range (3000, 5001)},
'belgian_dubbel':{'OG': range (1062, 1076), 'FG': range (1008, 1019), 'ABV': range (6000, 7601), 'IBU': range (15000, 25001), 'SRM': range (10000, 17001)},
'belgian_tripel':{'OG': range (1075, 1086), 'FG': range (1008, 1015), 'ABV': range (7500, 9501), 'IBU': range (20000, 40001), 'SRM': range (4500, 7001)},
'belgian_dark_strong_ale':{'OG': range (1075, 1111), 'FG': range (1010, 1025), 'ABV': range (8000, 12001), 'IBU': range (20000, 35001), 'SRM': range (12000, 22001)},
'gose':{'OG': range (1036, 1057), 'FG': range (1006, 1011), 'ABV': range (4200, 4801), 'IBU': range (5000, 12001), 'SRM': range (3000, 4001)},
'kentucky_common':{'OG': range (1044, 1056), 'FG': range (1010, 1019), 'ABV': range (4000, 5501), 'IBU': range (15000, 30001), 'SRM': range (11000, 20001)},
'lichtenhainer':{'OG': range (1032, 1041), 'FG': range (1004, 1009), 'ABV': range (3500, 4701), 'IBU': range (5000, 12001), 'SRM': range (3000, 6001)},
'london_brown_ale':{'OG': range (1033, 1039), 'FG': range (1012, 1016), 'ABV': range (2800, 3601), 'IBU': range (15000, 20001), 'SRM': range (22000, 35001)},
'piwo_grodziskie':{'OG': range (1028, 1032), 'FG': range (1006, 1013), 'ABV': range (2500, 3301), 'IBU': range (20000, 35001), 'SRM': range (3000, 6001)},
'pre_prohibition_lager':{'OG': range (1044, 1061), 'FG': range (1010, 1016), 'ABV': range (4500, 6001), 'IBU': range (25000, 40001), 'SRM': range (3000, 6001)},
'pre_prohibition_porter':{'OG': range (1046, 1061), 'FG': range (1010, 1017), 'ABV': range (4500, 6001), 'IBU': range (20000, 30001), 'SRM': range (18000, 30001)},
'roggenbier':{'OG': range (1046, 1057), 'FG': range (1010, 1015), 'ABV': range (4500, 6001), 'IBU': range (10000, 20001), 'SRM': range (14000, 19001)},
'sahti':{'OG': range (1076, 1121), 'FG': range (1016, 1021), 'ABV': range (7000, 11001), 'IBU': range (7000, 15001), 'SRM': range (4000, 22001)}
}
