import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * A Service Catalog product stack, which is similar in form to a Cloudformation nested stack.
 * You can add the resources to this stack that you want to define for your service catalog product.
 *
 * This stack will not be treated as an independent deployment
 * artifact (won't be listed in "cdk list" or deployable through "cdk deploy"),
 * but rather only synthesized as a template and uploaded as an asset to S3.
 *
 */
export declare class ProductStack extends cdk.Stack {
    readonly templateFile: string;
    private _templateUrl?;
    private _parentStack;
    constructor(scope: Construct, id: string);
    /**
     * Fetch the template URL.
     *
     * @internal
     */
    _getTemplateUrl(): string;
    /**
     * Synthesize the product stack template, overrides the `super` class method.
     *
     * Defines an asset at the parent stack which represents the template of this
     * product stack.
     *
     * @internal
     */
    _synthesizeTemplate(session: cdk.ISynthesisSession): void;
}
