# coding: utf-8

"""
    CLOUD API

    An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.  # noqa: E501

    The version of the OpenAPI document: 5.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class KubernetesMaintenanceWindow(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'day_of_the_week': 'str',

        'time': 'str',
    }

    attribute_map = {

        'day_of_the_week': 'dayOfTheWeek',

        'time': 'time',
    }

    def __init__(self, day_of_the_week=None, time=None, local_vars_configuration=None):  # noqa: E501
        """KubernetesMaintenanceWindow - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._day_of_the_week = None
        self._time = None
        self.discriminator = None

        if day_of_the_week is not None:
            self.day_of_the_week = day_of_the_week
        if time is not None:
            self.time = time


    @property
    def day_of_the_week(self):
        """Gets the day_of_the_week of this KubernetesMaintenanceWindow.  # noqa: E501

        The day of the week for a maintenance window.  # noqa: E501

        :return: The day_of_the_week of this KubernetesMaintenanceWindow.  # noqa: E501
        :rtype: str
        """
        return self._day_of_the_week

    @day_of_the_week.setter
    def day_of_the_week(self, day_of_the_week):
        """Sets the day_of_the_week of this KubernetesMaintenanceWindow.

        The day of the week for a maintenance window.  # noqa: E501

        :param day_of_the_week: The day_of_the_week of this KubernetesMaintenanceWindow.  # noqa: E501
        :type day_of_the_week: str
        """
        allowed_values = ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and day_of_the_week not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `day_of_the_week` ({0}), must be one of {1}"  # noqa: E501
                .format(day_of_the_week, allowed_values)
            )

        self._day_of_the_week = day_of_the_week

    @property
    def time(self):
        """Gets the time of this KubernetesMaintenanceWindow.  # noqa: E501

        The time to use for a maintenance window. Accepted formats are: HH:mm:ss; HH:mm:ss\"Z\"; HH:mm:ssZ. This time may varies by 15 minutes.  # noqa: E501

        :return: The time of this KubernetesMaintenanceWindow.  # noqa: E501
        :rtype: str
        """
        return self._time

    @time.setter
    def time(self, time):
        """Sets the time of this KubernetesMaintenanceWindow.

        The time to use for a maintenance window. Accepted formats are: HH:mm:ss; HH:mm:ss\"Z\"; HH:mm:ssZ. This time may varies by 15 minutes.  # noqa: E501

        :param time: The time of this KubernetesMaintenanceWindow.  # noqa: E501
        :type time: str
        """

        self._time = time
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, KubernetesMaintenanceWindow):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, KubernetesMaintenanceWindow):
            return True

        return self.to_dict() != other.to_dict()
