# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/metadata/openMetadataConnection.json
#   timestamp: 2022-04-13T13:01:43+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from .....security.client import (
    auth0SSOClientConfig,
    azureSSOClientConfig,
    customOidcSSOClientConfig,
    googleSSOClientConfig,
    oktaSSOClientConfig,
)


class AuthProvider(Enum):
    no_auth = 'no-auth'
    azure = 'azure'
    google = 'google'
    okta = 'okta'
    auth0 = 'auth0'
    custom_oidc = 'custom-oidc'


class OpenMetadataConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    hostPort: str = Field(
        ...,
        description='OpenMetadata Server Config. Must include API end point ex: http://localhost:8585/api',
    )
    authProvider: Optional[AuthProvider] = Field(
        AuthProvider.no_auth,
        description='OpenMetadata Server Authentication Provider. Make sure configure same auth providers as the one configured on OpenMetadaata server.',
    )
    securityConfig: Optional[
        Union[
            googleSSOClientConfig.GoogleSSOClientConfig,
            oktaSSOClientConfig.OktaSSOClientConfig,
            auth0SSOClientConfig.Auth0SSOClientConfig,
            azureSSOClientConfig.AzureSSOClientConfig,
            customOidcSSOClientConfig.CustomOIDCSSOClientConfig,
        ]
    ] = Field(None, description='OpenMetadata Client security configuration.')
    apiVersion: Optional[str] = Field(
        'v1', description='OpenMetadata server API version to use.'
    )
