# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/redshiftConnection.json
#   timestamp: 2022-04-13T13:01:43+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class RedshiftType(Enum):
    Redshift = 'Redshift'


class RedshiftScheme(Enum):
    redshift_psycopg2 = 'redshift+psycopg2'


class RedshiftConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[RedshiftType] = Field(
        RedshiftType.Redshift, description='Service Type'
    )
    scheme: Optional[RedshiftScheme] = Field(
        RedshiftScheme.redshift_psycopg2,
        description='SQLAlchemy driver scheme options.',
    )
    username: Optional[str] = Field(
        None,
        description='username to connect  to the Redshift. This user should have privileges to read all the metadata in Redshift.',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect  to the Redshift.'
    )
    hostPort: Optional[str] = Field(None, description='Host and port of the Redshift.')
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in Redshift.',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
