# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/glueConnection.json
#   timestamp: 2022-04-13T13:01:43+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class GlueType(Enum):
    Glue = 'Glue'


class GlueConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[GlueType] = Field(GlueType.Glue, description='Service Type')
    hostPort: Optional[str] = Field(None, description='Host and port of the Glue')
    endPointURL: Optional[str] = Field(None, description='EndPoint URL for the Glue')
    awsAccessKeyId: Optional[str] = Field(None, description='AWS Access key ID.')
    awsSecretAccessKey: Optional[SecretStr] = Field(
        None, description='AWS Secret Access Key.'
    )
    awsSessionToken: Optional[str] = Field(None, description='AWS Session Token.')
    storageServiceName: Optional[str] = Field(
        None, description='AWS storageServiceName Name.'
    )
    pipelineServiceName: Optional[str] = Field(
        None, description='AWS pipelineServiceName Name.'
    )
    awsRegion: Optional[str] = Field(None, description='AWS Region Name.')
    database: Optional[str] = Field(
        'Glue',
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in Glue.',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
