# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/druidConnection.json
#   timestamp: 2022-04-13T13:01:43+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class DruidType(Enum):
    Druid = 'Druid'


class DruidScheme(Enum):
    druid = 'druid'


class DruidConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DruidType] = Field(DruidType.Druid, description='Service Type')
    scheme: Optional[DruidScheme] = Field(
        DruidScheme.druid, description='SQLAlchemy driver scheme options.'
    )
    username: Optional[str] = Field(
        None,
        description='username to connect  to the Druid. This user should have privileges to read all the metadata in Druid.',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect to the Druid.'
    )
    hostPort: Optional[str] = Field(None, description='Host and port of the Druid')
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in Druid.',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
