# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/db2Connection.json
#   timestamp: 2022-04-13T13:01:43+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class Db2Type(Enum):
    Db2 = 'Db2'


class Db2Scheme(Enum):
    db2_ibm_db = 'db2+ibm_db'


class DB2Connection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[Db2Type] = Field(Db2Type.Db2, description='Service Type')
    scheme: Optional[Db2Scheme] = Field(
        Db2Scheme.db2_ibm_db, description='SQLAlchemy driver scheme options.'
    )
    username: Optional[str] = Field(
        None,
        description='username to connect  to the DB2. This user should have privileges to read all the metadata in DB2.',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect to the DB2.'
    )
    hostPort: Optional[str] = Field(None, description='Host and port of the DB2')
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in DB2.',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
