# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/dashboard/supersetConnection.json
#   timestamp: 2022-04-13T13:01:43+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional

from pydantic import AnyUrl, BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class SupersetType(Enum):
    Superset = 'Superset'


class SupersetConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[SupersetType] = Field(
        SupersetType.Superset, description='Service Type'
    )
    supersetURL: Optional[AnyUrl] = Field(
        'http://localhost:8088', description='URL for the superset instance'
    )
    username: Optional[str] = Field(None, description='username for the Superset')
    password: Optional[SecretStr] = Field(None, description='password for the Superset')
    provider: Optional[str] = Field(
        'db', description='authenticaiton provider for the Superset'
    )
    dbServiceConnection: Optional[str] = Field(
        None, description='Database Service to create lineage'
    )
    connectionOptions: Optional[Dict[str, Any]] = Field(
        None,
        description='Additional connection options that can be sent to service during the connection.',
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
