# generated by datamodel-codegen:
#   filename:  schema/api/services/createMessagingService.json
#   timestamp: 2022-04-13T13:31:00+00:00

from __future__ import annotations

from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field, constr

from ...entity.services import messagingService
from ...type import entityReference, schedule


class CreateMessagingServiceRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: constr(regex=r'^[^.]*$', min_length=1, max_length=128) = Field(
        ..., description='Name that identifies the this entity instance uniquely'
    )
    description: Optional[str] = Field(
        None, description='Description of messaging service entity.'
    )
    serviceType: messagingService.MessagingServiceType
    brokers: messagingService.Brokers = Field(
        ...,
        description='Multiple bootstrap addresses for Kafka. Single proxy address for Pulsar.',
    )
    schemaRegistry: Optional[AnyUrl] = Field(None, description='Schema registry URL')
    ingestionSchedule: Optional[schedule.Schedule] = Field(
        None, description='Schedule for running metadata ingestion jobs'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this messaging service.'
    )
