# generated by datamodel-codegen:
#   filename:  schema/api/events/createWebhook.json
#   timestamp: 2022-04-13T13:31:00+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import AnyUrl, BaseModel, Extra, Field, constr

from ...type import changeEvent


class CreateWebhookRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: constr(min_length=1, max_length=128) = Field(
        ..., description='Unique name of the application receiving webhook events.'
    )
    description: Optional[str] = Field(
        None, description='Description of the application'
    )
    endpoint: AnyUrl = Field(
        ..., description='Endpoint to receive the webhook events over POST requests.'
    )
    eventFilters: List[changeEvent.EventFilter] = Field(
        ..., description='Event filters to filter for desired events.'
    )
    batchSize: Optional[int] = Field(
        10, description='Maximum number of events sent in a batch (Default 10).'
    )
    timeout: Optional[int] = Field(
        10, description='Connection timeout in seconds. (Default = 10s)'
    )
    enabled: Optional[bool] = Field(
        True,
        description='When set to `true`, the webhook event notification is enabled. Set it to `false` to disable the subscription. (Default `true`)',
    )
    secretKey: Optional[str] = Field(
        None,
        description='Secret set by the webhook client used for computing HMAC SHA256 signature of webhook payload and sent in `X-OM-Signature` header in POST requests to publish the events.',
    )
