# Generated by Django 2.2 on 2020-03-31 08:06
from django.db import connection, migrations, models


def make_geolocation_unique_constraint():
    """
    Create the unique constraint on GeographicLocations, taking into account the quirks of SQLite
    and PostgreSQL
    """
    standard_constraint = migrations.AddConstraint(
        model_name='geographiclocation',
        constraint=models.UniqueConstraint(fields=('geometry',), name='unique_geographic_location'))

    if connection.vendor == 'sqlite':
        return migrations.RunSQL(
            sql='CREATE UNIQUE INDEX unique_catalog_geographiclocation ON catalog_geographiclocation(geometry);',
            reverse_sql='DROP INDEX unique_catalog_geographiclocation',
            state_operations=[standard_constraint]
        )
    elif connection.vendor == 'postgresql':
        return migrations.RunSQL(
            sql='CREATE UNIQUE INDEX unique_catalog_geographiclocation ON catalog_geographiclocation(md5(ST_AsBinary(geometry)));',
            reverse_sql='DROP INDEX unique_catalog_geographiclocation',
            state_operations=[standard_constraint]
        )
    else:
        return standard_constraint


class Migration(migrations.Migration):

    dependencies = [
        ('catalog', '0007_auto_20190626_1313'),
    ]

    operations = [
        migrations.AlterUniqueTogether(
            name='dataseturi',
            unique_together=set(),
        ),
        migrations.AlterUniqueTogether(
            name='source',
            unique_together=set(),
        ),
        migrations.AddConstraint(
            model_name='dataseturi',
            constraint=models.UniqueConstraint(fields=('uri', 'dataset'), name='unique_dataset_uri'),
        ),
        make_geolocation_unique_constraint(),
        migrations.AddConstraint(
            model_name='source',
            constraint=models.UniqueConstraint(fields=('platform', 'instrument'), name='unique_source'),
        ),
    ]
