# -*- coding: utf-8 -*-
# Generated by Django 1.11.7 on 2018-06-20 12:51
from __future__ import unicode_literals

from django.db import migrations
import uuid

def gen_uuid(apps, schema_editor):
    model = apps.get_model('catalog', 'dataset')
    for row in model.objects.all():
        row.entry_id = uuid.uuid4()
        row.save(update_fields=['entry_id'])

class Migration(migrations.Migration):

    dependencies = [
        ('catalog', '0003_dataset_entry_id'),
    ]

    operations = [
        migrations.RunPython(gen_uuid, reverse_code=migrations.RunPython.noop),
    ]
