# -*- coding: utf-8 -*-
# Generated by Django 1.9.2 on 2016-03-22 12:10
from __future__ import unicode_literals

import django.contrib.gis.db.models.fields
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('vocabularies', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Dataset',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('entry_title', models.CharField(max_length=220)),
                ('summary', models.TextField()),
                ('time_coverage_start', models.DateTimeField(blank=True, null=True)),
                ('time_coverage_end', models.DateTimeField(blank=True, null=True)),
                ('access_constraints', models.CharField(blank=True, choices=[(b'accessLevel0', 'Limited'), (b'accessLevel1', 'In-house'), (b'accessLevel2', 'Public')], max_length=50, null=True)),
                ('ISO_topic_category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='vocabularies.ISOTopicCategory')),
                ('data_center', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='vocabularies.DataCenter')),
                ('gcmd_location', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='vocabularies.Location')),
            ],
        ),
        migrations.CreateModel(
            name='DatasetParameter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('dataset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='catalog.Dataset')),
                ('parameter', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='vocabularies.Parameter')),
            ],
        ),
        migrations.CreateModel(
            name='DatasetRelationship',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('child', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='parents', to='catalog.Dataset')),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='children', to='catalog.Dataset')),
            ],
        ),
        migrations.CreateModel(
            name='DatasetURI',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uri', models.URLField(unique=True, validators=[django.core.validators.URLValidator(schemes=['http', 'https', 'ftp', 'ftps', b'file'])])),
                ('dataset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='catalog.Dataset')),
            ],
        ),
        migrations.CreateModel(
            name='GeographicLocation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('geometry', django.contrib.gis.db.models.fields.GeometryField(srid=4326)),
            ],
        ),
        migrations.CreateModel(
            name='Personnel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('phone', models.CharField(max_length=80)),
                ('fax', models.CharField(max_length=80)),
                ('address', models.CharField(max_length=80)),
                ('city', models.CharField(max_length=80)),
                ('province_or_state', models.CharField(max_length=80)),
                ('postal_code', models.CharField(max_length=80)),
                ('country', models.CharField(max_length=80)),
            ],
            options={
                'permissions': (('accessLevel0', 'Can access all data'), ('accessLevel1', 'Can access data at own data center'), ('accessLevel2', 'Can access public data only')),
            },
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('role', models.CharField(choices=[(b'Investigator', b'Investigator'), (b'Technical Contact', b'Technical Contact'), (b'DIF Author', b'DIF Author')], max_length=20)),
                ('personnel', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='catalog.Personnel')),
            ],
        ),
        migrations.CreateModel(
            name='Source',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('specs', models.CharField(default=b'', help_text='Further specifications of the source.', max_length=50)),
                ('instrument', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='vocabularies.Instrument')),
                ('platform', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='vocabularies.Platform')),
            ],
        ),
        migrations.AddField(
            model_name='dataset',
            name='geographic_location',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='catalog.GeographicLocation'),
        ),
        migrations.AddField(
            model_name='dataset',
            name='parameters',
            field=models.ManyToManyField(through='catalog.DatasetParameter', to='vocabularies.Parameter'),
        ),
        migrations.AddField(
            model_name='dataset',
            name='source',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='catalog.Source'),
        ),
        migrations.AlterUniqueTogether(
            name='source',
            unique_together=set([('platform', 'instrument')]),
        ),
    ]
