# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

modules = \
['kodi_cli']
install_requires = \
['requests>=2.28.0,<3.0.0']

entry_points = \
{'console_scripts': ['kodi-cli = kodi_cli:main']}

setup_kwargs = {
    'name': 'kodi-cli',
    'version': '0.1.0',
    'description': 'Control your Kodi instance(s) via the command-line',
    'long_description': '# kodi-cli\n\n## Command Line Interface for Kodi\n\nThis tool can be used from the command line to execute commands against a target Kodi host via the RPC interface defined at  https://kodi.wiki/view/JSON-RPC_API/v12.  \n\nThe available commands are defined via a json file ([**kodi_namespaces.json**](https://github.com/JavaWiz1/kodi-cli/blob/develop/kodi_namespaces.json)) which describes all the namespaces, methods and parameters available for managing the kodi device remotely.  \n\n**Note** \n- Not all the commands are fully defined, further iterations of the code will include updates to this file to make more commands available.\n- Namespace and Methods are case-sensitive.  Use help parameter or refer to the [Kodi RPC page](https://kodi.wiki/view/JSON-RPC_API/v12) for proper capitalization.\n</br></br>\n\n---\n## Some terms:\n\n| Term | Description |\n| ------------- | ---------------------------- |\n| namespace | The data model is split into namespace components which can be called via the API |\n| methods | Each namespace has a number of methods which perform some function within that namespace |\n| command | A command is a namespace method combiniation used to control Kodi function (fmt: Namespace.Method) |\n\n```\nusage: \n  kodi_cli.py [-h] [-H HOST] [-P PORT] [-u USER] [-p PASSWORD] [-c CONFIG] [-C] [-f] [-v] [command [param ...]]\n```\n</br>\n\n---\n## Overall Description\n\n*Commands* are based on Kodi **namespaces and methods**.  Each namespace (i.e. Application, System,...) has a set of pre-defned methods.  When executing a command you supply the **Namespace.Method parameter(s)** (case-sensitive).\n\nFor example, to display the mute and volume level settings on host kodi001, the command is constructed as follows:\n- namespace is *Application*\n- method is *GetProperties*\n- parameters are *properties=[muted,volume]*\n\nas follows:\n\n  `python kodi_cli.py -H kodi001 Application.GetProperties properties=[muted,volume]`\n\nThe output of the tool is the json response from the Kodi endpoint the command was targeted to.\n</br></br>\n\n**TIPS - When calling the script:**\n| action | description |\n| ------ | ----------- |\n| add -h option | to display script syntax and list of option parameters |\n| enter help | as a parameter for help on namespace or namespace.method |\n| add -C | to create a config file for paraneter defaults |\n| add -f | to format the json output into a friendly format |\n\n**To create a configfile:**\n  - Compose the command line with all the values desired as defaults\n  - Append a -C to command line, the file will be created (if it does not already exist)\n  - Any future runs will use the defaults, which can be overridden if needed.\n</br>\n\n**Help commands:**\n| action | example |\n| ------ | ------- |\n| list of namespaces |    `python kodi_cli.py help` |\n| Methods for Namespace | `python kodi_cli.py Application help` |\n| Parameters for Method | `python kodi_cli.py Application.GetProperties help` |\n\nDetails for namespaces, methods and parameters may be found at https://kodi.wiki/view/JSON-RPC_API/v12\n \n</br>\n\n---\n## Prerequsites:\n\n**Python packages**\n<li>requests package</li>\n<li>do a pip install, or use pipenv</li>\n<br>\n\n**Kodi configuration**\n<li>Remote control via HTTP must be enabled.</li>\n<li>Enable in Kodi UI - Settings -> Services -> Control</li>\n</br></br>\n\n---\n\n## Usage\n\n```\nusage: kodi_cli.py [-h] -H HOST [-P PORT] [-u USER] [-p PASSWORD] [-v] [command [parameters ...]]\n\npositional arguments:\n  command               RPC command in format: Namespace.Method [[Param][Param]]  (help namespace to list)\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -H HOST, --host HOST  Kodi hostname\n  -P PORT, --port PORT  Kodi RPC listen port\n  -u USER, --user USER  Kodi authenticaetion username\n  -p PASSWORD, --password PASSWORD\n                        Kodi autentication password\n  -c CONFIG, --config CONFIG\n                        Optional config file\n  -C, --create_config   Create empty config\n  -f, --format_output   Format json output\n  -v, --verbose         Turn out verbose output, more parms increase verbosity\n  ```\n\n---\n<br>\nYou can get help from the command line to view namespaces, namespace methods and calling requirements. \nSimply\ntype ***python kodi_cli.py help*** as the command to get a list of all the namespaces.\n\nHelp Examples\n| To  | Command |\n| --- | --- |\n| List Namespaces | ***python kodi_cli.py help*** |\n| List Namespace methods | ***python kodi_cli.py help <Namespace>*** |\n| List Namespace method calling requirements | ***python kodi_cli.py help <Namespace.Method>*** \n</br></br>\n\n---\n## Examples\n---\n### Create a config file to store defaults\nTo minimize command-line entry, you can store defaults in a config file which will be used when running.  The\nvalues can be over-ridded at run-time by provideing the optional argument.\n\nTo create a default config file, type your standard defaults as if you were going to execute the CLI and add -C at the end.\nThe config file will be written with the values.\n```\nSYNTAX:\n  python kodi_cli.py -u myId -p myPassword -P 8080 -C\n\nOUTPUT:\n  a file (kodi_cli.cfg will be written as:\n    {\n      "host": "localhost",\n      "port": 8080,\n      "user": "myId",\n      "password": "myPassword",\n      "format_output": false\n    }\n```\n</br></br>\n\n---\n### List all **namespaces**\n\nNamespaces are modules in Kodi, each namespace manages differ aspects of the Kodi interface\n\n```\nSYNTAX:\n  python kodi_cli.py help\n\nOUTPUT:\n\n  Kodi namespaces -\n    Namespace       Methods\n    --------------- ----------------------------------------------------------------------------\n    AddOns          ExecuteAddon, GetAddonDetails, GetAddons, SetAddonEnabled\n\n    Application     GetProperties, Quit, SetMute, SetVolume\n\n    AudioLibrary    Clean, GetAlbumDetails, GetAlbums, GetArtistDetails,\n                    GetArtists, Scan\n\n    Favorites       AddFavorite, GetFavorites\n\n    GUI             ActivateWindow, ShowNotification\n\n    Input           Back, ButtonEvent, ContextMenu, Down, ExecuteAction,\n                    Home, Info, Left, Right, Select, SendText,\n                    ShowCodec, ShowOSD, ShowPlayProcessInfo, Up\n    ...\n```\n</br></br>\n\n---\n### List all namespace ***methods***\n\nEach namespace has a number of methods that can be called.  \n\nTo get a list of supported of supported methods for the ***Application*** namespace\n\n```\nSYNTAX:\n  python kodi_cli.py Application help\n  or\n  python kodi_cli.py Application\n\nOUTPUT:\n\n  Application Namespace Methods:\n\n  Method                    Description\n  ------------------------- --------------------------------------------\n  Application.GetProperties Retrieves the values of the given properties\n  Application.Quit          Quit application\n  Application.SetMute       Toggle mute/unmute\n  Application.SetVolume     Set the current volume\n```\n</br></br>\n\n---\n### List the ***method calling signature*** for a particular namespace method\n\nList the sytax for the Application.SetMute command\n\n```\nSYNTAX:\n  python kodi_cli.py Application.SetMute help\n\nOUTPUT:\n\n  Syntax: Application.SetMute\n  ------------------------------------------------------\n  {\n    "description": "Toggle mute/unmute",\n    "params": [\n      {\n        "$ref": "Global.Toggle",\n        "name": "mute",\n        "required": true\n      }\n    ],\n    "permission": "ControlPlayback",\n    "returns": {\n      "description": "Mute state",\n      "type": "boolean"\n    },\n    "type": "method"\n  }\n\n```\n</br></br>\n\n---\n### Example executing a command\n\nTo toggle the mute on, then off\n\nFirst call will toggle mute on, 2nd call will toggle mute off.\n\n```\nSYNTAX:\n  python kodi_cli.py -H ServerName Application.SetMute mute=toggle\n\nOUTPUT:\n  python kodi_cli.py -H MyKodiServer Application.SetMute mute=toggle\n  {"id":1,"jsonrpc":"2.0","result":true}\n\n  python kodi_cli.py -H MyKodiServer Application.SetMute mute=toggle\n  {"id":1,"jsonrpc":"2.0","result":false}\n```\n</br></br>\n\n---\n### Retrieve Application Properties\n\nTo retrieve the muted status and volume level for server kodi001\n```\nSYNTAX:\n  python kodi_cli.py -H kodi001 Application.GetProperties properties=[muted,volume] -f\n\nOUTPUT:\n{\n  "id": 1,\n  "jsonrpc": "2.0",\n  "result": {\n    "muted": false,\n    "volume": 100\n  }\n}\n\n```\n</br></br>\n\n---\n  Still TODO:\n  <ul>\n  <li>Build out kodi_namespaces.json with additional definitions.</li>\n  <li>Edit parameters prior to call to avoid runtime error,</li>\n  <li>Provide additional help/runtime detail on parameters (i.e. enum values)</li>\n  </ul>',
    'author': 'Al DAmico',
    'author_email': 'JavaWiz1@hotmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/JavaWiz1/kodi-cli',
    'package_dir': package_dir,
    'py_modules': modules,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
