"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationRule = exports.DetailType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const codestarnotifications_generated_1 = require("./codestarnotifications.generated");
/**
 * The level of detail to include in the notifications for this resource.
 *
 * @stability stable
 */
var DetailType;
(function (DetailType) {
    DetailType["BASIC"] = "BASIC";
    DetailType["FULL"] = "FULL";
})(DetailType = exports.DetailType || (exports.DetailType = {}));
/**
 * A new notification rule.
 *
 * @stability stable
 * @resource AWS::CodeStarNotifications::NotificationRule
 */
class NotificationRule extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.targets = [];
        this.events = [];
        const source = props.source.bindAsNotificationRuleSource(this);
        this.addEvents(props.events);
        const resource = new codestarnotifications_generated_1.CfnNotificationRule(this, 'Resource', {
            // It has a 64 characters limit for the name
            name: props.notificationRuleName || core_1.Names.uniqueId(this).slice(-64),
            detailType: props.detailType || DetailType.FULL,
            targets: this.targets,
            eventTypeIds: this.events,
            resource: source.sourceArn,
            status: props.enabled !== undefined
                ? (props.enabled ? 'ENABLED' : 'DISABLED')
                : undefined,
        });
        this.notificationRuleArn = resource.ref;
        (_b = props.targets) === null || _b === void 0 ? void 0 : _b.forEach((target) => {
            this.addTarget(target);
        });
    }
    /**
     * Import an existing notification rule provided an ARN.
     *
     * @param scope The parent creating construct.
     * @param id The construct's name.
     * @param notificationRuleArn Notification rule ARN (i.e. arn:aws:codestar-notifications:::notificationrule/01234abcde).
     * @stability stable
     */
    static fromNotificationRuleArn(scope, id, notificationRuleArn) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.notificationRuleArn = notificationRuleArn;
            }
            addTarget(_target) {
                return false;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: notificationRuleArn,
        });
    }
    /**
     * Adds target to notification rule.
     *
     * @param target The SNS topic or AWS Chatbot Slack target.
     * @stability stable
     */
    addTarget(target) {
        this.targets.push(target.bindAsNotificationRuleTarget(this));
        return true;
    }
    /**
     * Adds events to notification rule
     *
     * @see https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline
     * @see https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-buildproject
     * @param events The list of event types for AWS Codebuild and AWS CodePipeline
     */
    addEvents(events) {
        events.forEach((event) => {
            if (this.events.includes(event)) {
                return;
            }
            this.events.push(event);
        });
    }
}
exports.NotificationRule = NotificationRule;
_a = JSII_RTTI_SYMBOL_1;
NotificationRule[_a] = { fqn: "@aws-cdk/aws-codestarnotifications.NotificationRule", version: "1.112.0" };
//# sourceMappingURL=data:application/json;base64,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