"""
Python Character Mapping Codec for 'petscii_vic20en_lc' generated by gen-codec.
"""

#    Name:		PETSCII VIC-20 English Lowercase to Unicode Table
#    Unicode version:	3.0
#    Table version:	1.00
#    Table format:	Format A
#    Date:		12/03/00
#    Authors:		Linus Walleij <triad@df.lth.se>
#    General notes:	Licensed under the GNU GPL, version 2

import codecs

# Codec APIs


class Codec(codecs.Codec):  # pylint: disable=missing-class-docstring
    def encode(self, _input, errors='strict'):
        return codecs.charmap_encode(_input, errors, encoding_table)

    def decode(self, _input, errors='strict'):
        return codecs.charmap_decode(_input, errors, decoding_table)


class IncrementalEncoder(codecs.IncrementalEncoder):  # pylint: disable=missing-class-docstring
    def encode(self, _input, final=False):
        return codecs.charmap_encode(_input, self.errors, encoding_table)[0]


class IncrementalDecoder(codecs.IncrementalDecoder):  # pylint: disable=missing-class-docstring
    def decode(self, _input, final=False):
        return codecs.charmap_decode(_input, self.errors, decoding_table)[0]


class StreamWriter(Codec, codecs.StreamWriter):  # pylint: disable=missing-class-docstring
    pass


class StreamReader(Codec, codecs.StreamReader):  # pylint: disable=missing-class-docstring
    pass


# encodings module API

def getregentry():  # pylint: disable=missing-function-docstring
    return codecs.CodecInfo(
        name='petscii_vic20en_lc',
        encode=Codec().encode,
        decode=Codec().decode,
        incrementalencoder=IncrementalEncoder,
        incrementaldecoder=IncrementalDecoder,
        streamreader=StreamReader,
        streamwriter=StreamWriter,
    )


decoding_table = {
    0x05:	'\uf100',	  # WHITE COLOR SWITCH (CUS)
    0x08:	'\uf118',	  # DISABLE CHARACTER SET SWITCHING (CUS)
    0x09:	'\uf119',	  # ENABLE CHARACTER SET SWITCHING (CUS)
    0x0d:	'\r',    	  # CARRIAGE RETURN
    0x0e:	'\x0e',  	  # SHIFT OUT
    0x11:	'\uf11c',	  # CURSOR DOWN (CUS)
    0x12:	'\uf11a',	  # REVERSE VIDEO ON (CUS)
    0x13:	'\uf120',	  # HOME (CUS)
    0x14:	'\x7f',  	  # DELETE
    0x1c:	'\uf101',	  # RED COLOR SWITCH (CUS)
    0x1d:	'\uf11d',	  # CURSOR RIGHT (CUS)
    0x1e:	'\uf102',	  # GREEN COLOR SWITCH (CUS)
    0x1f:	'\uf103',	  # BLUE COLOR SWITCH (CUS)
    0x20:	' ',     	  # SPACE
    0x21:	'!',     	  # EXCLAMATION MARK
    0x22:	'"',     	  # QUOTATION MARK
    0x23:	'#',     	  # NUMBER SIGN
    0x24:	'$',     	  # DOLLAR SIGN
    0x25:	'%',     	  # PERCENT SIGN
    0x26:	'&',     	  # AMPERSAND
    0x27:	"'",     	  # APOSTROPHE
    0x28:	'(',     	  # LEFT PARENTHESIS
    0x29:	')',     	  # RIGHT PARENTHESIS
    0x2a:	'*',     	  # ASTERISK
    0x2b:	'+',     	  # PLUS SIGN
    0x2c:	',',     	  # COMMA
    0x2d:	'-',     	  # HYPHEN-MINUS
    0x2e:	'.',     	  # FULL STOP
    0x2f:	'/',     	  # SOLIDUS
    0x30:	'0',     	  # DIGIT ZERO
    0x31:	'1',     	  # DIGIT ONE
    0x32:	'2',     	  # DIGIT TWO
    0x33:	'3',     	  # DIGIT THREE
    0x34:	'4',     	  # DIGIT FOUR
    0x35:	'5',     	  # DIGIT FIVE
    0x36:	'6',     	  # DIGIT SIX
    0x37:	'7',     	  # DIGIT SEVEN
    0x38:	'8',     	  # DIGIT EIGHT
    0x39:	'9',     	  # DIGIT NINE
    0x3a:	':',     	  # COLON
    0x3b:	';',     	  # SEMICOLON
    0x3c:	'<',     	  # LESS-THAN SIGN
    0x3d:	'=',     	  # EQUALS SIGN
    0x3e:	'>',     	  # GREATER-THAN SIGN
    0x3f:	'?',     	  # QUESTION MARK
    0x40:	'@',     	  # COMMERCIAL AT
    0x41:	'a',     	  # LATIN SMALL LETTER A
    0x42:	'b',     	  # LATIN SMALL LETTER B
    0x43:	'c',     	  # LATIN SMALL LETTER C
    0x44:	'd',     	  # LATIN SMALL LETTER D
    0x45:	'e',     	  # LATIN SMALL LETTER E
    0x46:	'f',     	  # LATIN SMALL LETTER F
    0x47:	'g',     	  # LATIN SMALL LETTER G
    0x48:	'h',     	  # LATIN SMALL LETTER H
    0x49:	'i',     	  # LATIN SMALL LETTER I
    0x4a:	'j',     	  # LATIN SMALL LETTER J
    0x4b:	'k',     	  # LATIN SMALL LETTER K
    0x4c:	'l',     	  # LATIN SMALL LETTER L
    0x4d:	'm',     	  # LATIN SMALL LETTER M
    0x4e:	'n',     	  # LATIN SMALL LETTER N
    0x4f:	'o',     	  # LATIN SMALL LETTER O
    0x50:	'p',     	  # LATIN SMALL LETTER P
    0x51:	'q',     	  # LATIN SMALL LETTER Q
    0x52:	'r',     	  # LATIN SMALL LETTER R
    0x53:	's',     	  # LATIN SMALL LETTER S
    0x54:	't',     	  # LATIN SMALL LETTER T
    0x55:	'u',     	  # LATIN SMALL LETTER U
    0x56:	'v',     	  # LATIN SMALL LETTER V
    0x57:	'w',     	  # LATIN SMALL LETTER W
    0x58:	'x',     	  # LATIN SMALL LETTER X
    0x59:	'y',     	  # LATIN SMALL LETTER Y
    0x5a:	'z',     	  # LATIN SMALL LETTER Z
    0x5b:	'[',     	  # LEFT SQUARE BRACKET
    0x5c:	'\xa3',  	  # POUND SIGN
    0x5d:	']',     	  # RIGHT SQUARE BRACKET
    0x5e:	'\u2191',	  # UPWARDS ARROW
    0x5f:	'\u2190',	  # LEFTWARDS ARROW
    0x60:	'\u2500',	  # BOX DRAWINGS LIGHT HORIZONTAL
    0x61:	'A',     	  # LATIN CAPITAL LETTER A
    0x62:	'B',     	  # LATIN CAPITAL LETTER B
    0x63:	'C',     	  # LATIN CAPITAL LETTER C
    0x64:	'D',     	  # LATIN CAPITAL LETTER D
    0x65:	'E',     	  # LATIN CAPITAL LETTER E
    0x66:	'F',     	  # LATIN CAPITAL LETTER F
    0x67:	'G',     	  # LATIN CAPITAL LETTER G
    0x68:	'H',     	  # LATIN CAPITAL LETTER H
    0x69:	'I',     	  # LATIN CAPITAL LETTER I
    0x6a:	'J',     	  # LATIN CAPITAL LETTER J
    0x6b:	'K',     	  # LATIN CAPITAL LETTER K
    0x6c:	'L',     	  # LATIN CAPITAL LETTER L
    0x6d:	'M',     	  # LATIN CAPITAL LETTER M
    0x6e:	'N',     	  # LATIN CAPITAL LETTER N
    0x6f:	'O',     	  # LATIN CAPITAL LETTER O
    0x70:	'P',     	  # LATIN CAPITAL LETTER P
    0x71:	'Q',     	  # LATIN CAPITAL LETTER Q
    0x72:	'R',     	  # LATIN CAPITAL LETTER R
    0x73:	'S',     	  # LATIN CAPITAL LETTER S
    0x74:	'T',     	  # LATIN CAPITAL LETTER T
    0x75:	'U',     	  # LATIN CAPITAL LETTER U
    0x76:	'V',     	  # LATIN CAPITAL LETTER V
    0x77:	'W',     	  # LATIN CAPITAL LETTER W
    0x78:	'X',     	  # LATIN CAPITAL LETTER X
    0x79:	'Y',     	  # LATIN CAPITAL LETTER Y
    0x7a:	'Z',     	  # LATIN CAPITAL LETTER Z
    0x7b:	'\u253c',	  # BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
    0x7c:	'\uf12e',	  # LEFT HALF BLOCK MEDIUM SHADE (CUS)
    0x7d:	'\u2502',	  # BOX DRAWINGS LIGHT VERTICAL
    0x7e:	'\u2592',	  # MEDIUM SHADE
    0x7f:	'\uf139',	  # MEDIUM SHADE SLASHED LEFT (CUS)
    0x85:	'\uf110',	  # FUNCTION KEY 1 (CUS)
    0x86:	'\uf112',	  # FUNCTION KEY 3 (CUS)
    0x87:	'\uf114',	  # FUNCTION KEY 5 (CUS)
    0x88:	'\uf116',	  # FUNCTION KEY 7 (CUS)
    0x89:	'\uf111',	  # FUNCTION KEY 2 (CUS)
    0x8a:	'\uf113',	  # FUNCTION KEY 4 (CUS)
    0x8b:	'\uf115',	  # FUNCTION KEY 6 (CUS)
    0x8c:	'\uf117',	  # FUNCTION KEY 8 (CUS)
    0x8d:	'\n',    	  # LINE FEED
    0x8e:	'\x0f',  	  # SHIFT IN
    0x90:	'\uf105',	  # BLACK COLOR SWITCH (CUS)
    0x91:	'\uf11e',	  # CURSOR UP (CUS)
    0x92:	'\uf11b',	  # REVERSE VIDEO OFF (CUS)
    0x93:	'\x0c',  	  # FORM FEED
    0x94:	'\uf121',	  # INSERT (CUS)
    0x9c:	'\uf10d',	  # PURPLE COLOR SWITCH (CUS)
    0x9d:	'\uf11f',	  # CURSOR LEFT (CUS)
    0x9e:	'\uf10e',	  # YELLOW COLOR SWITCH (CUS)
    0x9f:	'\uf10f',	  # CYAN COLOR SWITCH (CUS)
    0xa0:	'\xa0',  	  # NO-BREAK SPACE
    0xa1:	'\u258c',	  # LEFT HALF BLOCK
    0xa2:	'\u2584',	  # LOWER HALF BLOCK
    0xa3:	'\u2594',	  # UPPER ONE EIGHTH BLOCK
    0xa4:	'\u2581',	  # LOWER ONE EIGHTH BLOCK
    0xa5:	'\u258f',	  # LEFT ONE EIGHTH BLOCK
    0xa6:	'\u2592',	  # MEDIUM SHADE
    0xa7:	'\u2595',	  # RIGHT ONE EIGHTH BLOCK
    0xa8:	'\uf12f',	  # LOWER HALF BLOCK MEDIUM SHADE (CUS)
    0xa9:	'\uf13a',	  # MEDIUM SHADE SLASHED RIGHT (CUS)
    0xaa:	'\uf130',	  # RIGHT ONE QUARTER BLOCK (CUS)
    0xab:	'\u251c',	  # BOX DRAWINGS LIGHT VERTICAL AND RIGHT
    0xac:	'\u2597',	  # QUADRANT LOWER RIGHT
    0xad:	'\u2514',	  # BOX DRAWINGS LIGHT UP AND RIGHT
    0xae:	'\u2510',	  # BOX DRAWINGS LIGHT DOWN AND LEFT
    0xaf:	'\u2582',	  # LOWER ONE QUARTER BLOCK
    0xb0:	'\u250c',	  # BOX DRAWINGS LIGHT DOWN AND RIGHT
    0xb1:	'\u2534',	  # BOX DRAWINGS LIGHT UP AND HORIZONTAL
    0xb2:	'\u252c',	  # BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
    0xb3:	'\u2524',	  # BOX DRAWINGS LIGHT VERTICAL AND LEFT
    0xb4:	'\u258e',	  # LEFT ONE QUARTER BLOCK
    0xb5:	'\u258d',	  # LEFT THREE EIGTHS BLOCK
    0xb6:	'\uf131',	  # RIGHT THREE EIGHTHS BLOCK (CUS)
    0xb7:	'\uf132',	  # UPPER ONE QUARTER BLOCK (CUS)
    0xb8:	'\uf133',	  # UPPER THREE EIGHTS BLOCK (CUS)
    0xb9:	'\u2583',	  # LOWER THREE EIGHTHS BLOCK
    0xba:	'\u2713',	  # CHECK MARK
    0xbb:	'\u2596',	  # QUADRANT LOWER LEFT
    0xbc:	'\u259d',	  # QUADRANT UPPER RIGHT
    0xbd:	'\u2518',	  # BOX DRAWINGS LIGHT UP AND LEFT
    0xbe:	'\u2598',	  # QUADRANT UPPER LEFT
    0xbf:	'\u259a',	  # QUADRANT UPPER LEFT AND LOWER RIGHT
    0xc0:	'\u2500',	  # BOX DRAWINGS LIGHT HORIZONTAL
    0xc1:	'A',     	  # LATIN CAPITAL LETTER A
    0xc2:	'B',     	  # LATIN CAPITAL LETTER B
    0xc3:	'C',     	  # LATIN CAPITAL LETTER C
    0xc4:	'D',     	  # LATIN CAPITAL LETTER D
    0xc5:	'E',     	  # LATIN CAPITAL LETTER E
    0xc6:	'F',     	  # LATIN CAPITAL LETTER F
    0xc7:	'G',     	  # LATIN CAPITAL LETTER G
    0xc8:	'H',     	  # LATIN CAPITAL LETTER H
    0xc9:	'I',     	  # LATIN CAPITAL LETTER I
    0xca:	'J',     	  # LATIN CAPITAL LETTER J
    0xcb:	'K',     	  # LATIN CAPITAL LETTER K
    0xcc:	'L',     	  # LATIN CAPITAL LETTER L
    0xcd:	'M',     	  # LATIN CAPITAL LETTER M
    0xce:	'N',     	  # LATIN CAPITAL LETTER N
    0xcf:	'O',     	  # LATIN CAPITAL LETTER O
    0xd0:	'P',     	  # LATIN CAPITAL LETTER P
    0xd1:	'Q',     	  # LATIN CAPITAL LETTER Q
    0xd2:	'R',     	  # LATIN CAPITAL LETTER R
    0xd3:	'S',     	  # LATIN CAPITAL LETTER S
    0xd4:	'T',     	  # LATIN CAPITAL LETTER T
    0xd5:	'U',     	  # LATIN CAPITAL LETTER U
    0xd6:	'V',     	  # LATIN CAPITAL LETTER V
    0xd7:	'W',     	  # LATIN CAPITAL LETTER W
    0xd8:	'X',     	  # LATIN CAPITAL LETTER X
    0xd9:	'Y',     	  # LATIN CAPITAL LETTER Y
    0xda:	'Z',     	  # LATIN CAPITAL LETTER Z
    0xdb:	'\u253c',	  # BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
    0xdc:	'\uf12e',	  # LEFT HALF BLOCK MEDIUM SHADE (CUS)
    0xdd:	'\u2502',	  # BOX DRAWINGS LIGHT VERTICAL
    0xde:	'\u2592',	  # MEDIUM SHADE
    0xdf:	'\uf139',	  # MEDIUM SHADE SLASHED LEFT (CUS)
    0xe0:	'\xa0',  	  # NO-BREAK SPACE
    0xe1:	'\u258c',	  # LEFT HALF BLOCK
    0xe2:	'\u2584',	  # LOWER HALF BLOCK
    0xe3:	'\u2594',	  # UPPER ONE EIGHTH BLOCK
    0xe4:	'\u2581',	  # LOWER ONE EIGHTH BLOCK
    0xe5:	'\u258f',	  # LEFT ONE EIGHTH BLOCK
    0xe6:	'\u2592',	  # MEDIUM SHADE
    0xe7:	'\u2595',	  # RIGHT ONE EIGHTH BLOCK
    0xe8:	'\uf12f',	  # LOWER HALF BLOCK MEDIUM SHADE (CUS)
    0xe9:	'\uf13a',	  # MEDIUM SHADE SLASHED RIGHT (CUS)
    0xea:	'\uf130',	  # RIGHT ONE QUARTER BLOCK (CUS)
    0xeb:	'\u251c',	  # BOX DRAWINGS LIGHT VERTICAL AND RIGHT
    0xec:	'\u2597',	  # QUADRANT LOWER RIGHT
    0xed:	'\u2514',	  # BOX DRAWINGS LIGHT UP AND RIGHT
    0xee:	'\u2510',	  # BOX DRAWINGS LIGHT DOWN AND LEFT
    0xef:	'\u2582',	  # LOWER ONE QUARTER BLOCK
    0xf0:	'\u250c',	  # BOX DRAWINGS LIGHT DOWN AND RIGHT
    0xf1:	'\u2534',	  # BOX DRAWINGS LIGHT UP AND HORIZONTAL
    0xf2:	'\u252c',	  # BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
    0xf3:	'\u2524',	  # BOX DRAWINGS LIGHT VERTICAL AND LEFT
    0xf4:	'\u258e',	  # LEFT ONE QUARTER BLOCK
    0xf5:	'\u258d',	  # LEFT THREE EIGTHS BLOCK
    0xf6:	'\uf131',	  # RIGHT THREE EIGHTHS BLOCK (CUS)
    0xf7:	'\uf132',	  # UPPER ONE QUARTER BLOCK (CUS)
    0xf8:	'\uf133',	  # UPPER THREE EIGHTS BLOCK (CUS)
    0xf9:	'\u2583',	  # LOWER THREE EIGHTHS BLOCK
    0xfa:	'\u2713',	  # CHECK MARK
    0xfb:	'\u2596',	  # QUADRANT LOWER LEFT
    0xfc:	'\u259d',	  # QUADRANT UPPER RIGHT
    0xfd:	'\u2518',	  # BOX DRAWINGS LIGHT UP AND LEFT
    0xfe:	'\u2598',	  # QUADRANT UPPER LEFT
    0xff:	'\u2592',	  # MEDIUM SHADE
}

encoding_table = {
    0x0a:	b'\x8d',  	  # LINE FEED
    0x0c:	b'\x93',  	  # FORM FEED
    0x0d:	b'\r',    	  # CARRIAGE RETURN
    0x0e:	b'\x0e',  	  # SHIFT OUT
    0x0f:	b'\x8e',  	  # SHIFT IN
    0x20:	b' ',     	  # SPACE
    0x21:	b'!',     	  # EXCLAMATION MARK
    0x22:	b'"',     	  # QUOTATION MARK
    0x23:	b'#',     	  # NUMBER SIGN
    0x24:	b'$',     	  # DOLLAR SIGN
    0x25:	b'%',     	  # PERCENT SIGN
    0x26:	b'&',     	  # AMPERSAND
    0x27:	b"'",     	  # APOSTROPHE
    0x28:	b'(',     	  # LEFT PARENTHESIS
    0x29:	b')',     	  # RIGHT PARENTHESIS
    0x2a:	b'*',     	  # ASTERISK
    0x2b:	b'+',     	  # PLUS SIGN
    0x2c:	b',',     	  # COMMA
    0x2d:	b'-',     	  # HYPHEN-MINUS
    0x2e:	b'.',     	  # FULL STOP
    0x2f:	b'/',     	  # SOLIDUS
    0x30:	b'0',     	  # DIGIT ZERO
    0x31:	b'1',     	  # DIGIT ONE
    0x32:	b'2',     	  # DIGIT TWO
    0x33:	b'3',     	  # DIGIT THREE
    0x34:	b'4',     	  # DIGIT FOUR
    0x35:	b'5',     	  # DIGIT FIVE
    0x36:	b'6',     	  # DIGIT SIX
    0x37:	b'7',     	  # DIGIT SEVEN
    0x38:	b'8',     	  # DIGIT EIGHT
    0x39:	b'9',     	  # DIGIT NINE
    0x3a:	b':',     	  # COLON
    0x3b:	b';',     	  # SEMICOLON
    0x3c:	b'<',     	  # LESS-THAN SIGN
    0x3d:	b'=',     	  # EQUALS SIGN
    0x3e:	b'>',     	  # GREATER-THAN SIGN
    0x3f:	b'?',     	  # QUESTION MARK
    0x40:	b'@',     	  # COMMERCIAL AT
    0x41:	b'\xc1',  	  # LATIN CAPITAL LETTER A
    0x42:	b'\xc2',  	  # LATIN CAPITAL LETTER B
    0x43:	b'\xc3',  	  # LATIN CAPITAL LETTER C
    0x44:	b'\xc4',  	  # LATIN CAPITAL LETTER D
    0x45:	b'\xc5',  	  # LATIN CAPITAL LETTER E
    0x46:	b'\xc6',  	  # LATIN CAPITAL LETTER F
    0x47:	b'\xc7',  	  # LATIN CAPITAL LETTER G
    0x48:	b'\xc8',  	  # LATIN CAPITAL LETTER H
    0x49:	b'\xc9',  	  # LATIN CAPITAL LETTER I
    0x4a:	b'\xca',  	  # LATIN CAPITAL LETTER J
    0x4b:	b'\xcb',  	  # LATIN CAPITAL LETTER K
    0x4c:	b'\xcc',  	  # LATIN CAPITAL LETTER L
    0x4d:	b'\xcd',  	  # LATIN CAPITAL LETTER M
    0x4e:	b'\xce',  	  # LATIN CAPITAL LETTER N
    0x4f:	b'\xcf',  	  # LATIN CAPITAL LETTER O
    0x50:	b'\xd0',  	  # LATIN CAPITAL LETTER P
    0x51:	b'\xd1',  	  # LATIN CAPITAL LETTER Q
    0x52:	b'\xd2',  	  # LATIN CAPITAL LETTER R
    0x53:	b'\xd3',  	  # LATIN CAPITAL LETTER S
    0x54:	b'\xd4',  	  # LATIN CAPITAL LETTER T
    0x55:	b'\xd5',  	  # LATIN CAPITAL LETTER U
    0x56:	b'\xd6',  	  # LATIN CAPITAL LETTER V
    0x57:	b'\xd7',  	  # LATIN CAPITAL LETTER W
    0x58:	b'\xd8',  	  # LATIN CAPITAL LETTER X
    0x59:	b'\xd9',  	  # LATIN CAPITAL LETTER Y
    0x5a:	b'\xda',  	  # LATIN CAPITAL LETTER Z
    0x5b:	b'[',     	  # LEFT SQUARE BRACKET
    0x5d:	b']',     	  # RIGHT SQUARE BRACKET
    0x61:	b'A',     	  # LATIN SMALL LETTER A
    0x62:	b'B',     	  # LATIN SMALL LETTER B
    0x63:	b'C',     	  # LATIN SMALL LETTER C
    0x64:	b'D',     	  # LATIN SMALL LETTER D
    0x65:	b'E',     	  # LATIN SMALL LETTER E
    0x66:	b'F',     	  # LATIN SMALL LETTER F
    0x67:	b'G',     	  # LATIN SMALL LETTER G
    0x68:	b'H',     	  # LATIN SMALL LETTER H
    0x69:	b'I',     	  # LATIN SMALL LETTER I
    0x6a:	b'J',     	  # LATIN SMALL LETTER J
    0x6b:	b'K',     	  # LATIN SMALL LETTER K
    0x6c:	b'L',     	  # LATIN SMALL LETTER L
    0x6d:	b'M',     	  # LATIN SMALL LETTER M
    0x6e:	b'N',     	  # LATIN SMALL LETTER N
    0x6f:	b'O',     	  # LATIN SMALL LETTER O
    0x70:	b'P',     	  # LATIN SMALL LETTER P
    0x71:	b'Q',     	  # LATIN SMALL LETTER Q
    0x72:	b'R',     	  # LATIN SMALL LETTER R
    0x73:	b'S',     	  # LATIN SMALL LETTER S
    0x74:	b'T',     	  # LATIN SMALL LETTER T
    0x75:	b'U',     	  # LATIN SMALL LETTER U
    0x76:	b'V',     	  # LATIN SMALL LETTER V
    0x77:	b'W',     	  # LATIN SMALL LETTER W
    0x78:	b'X',     	  # LATIN SMALL LETTER X
    0x79:	b'Y',     	  # LATIN SMALL LETTER Y
    0x7a:	b'Z',     	  # LATIN SMALL LETTER Z
    0x7f:	b'\x14',  	  # DELETE
    0xa0:	b'\xa0',  	  # NO-BREAK SPACE
    0xa3:	b'\\',    	  # POUND SIGN
    0x2190:	b'_',     	  # LEFTWARDS ARROW
    0x2191:	b'^',     	  # UPWARDS ARROW
    0x2500:	b'\xc0',  	  # BOX DRAWINGS LIGHT HORIZONTAL
    0x2502:	b'\xdd',  	  # BOX DRAWINGS LIGHT VERTICAL
    0x250c:	b'\xb0',  	  # BOX DRAWINGS LIGHT DOWN AND RIGHT
    0x2510:	b'\xae',  	  # BOX DRAWINGS LIGHT DOWN AND LEFT
    0x2514:	b'\xad',  	  # BOX DRAWINGS LIGHT UP AND RIGHT
    0x2518:	b'\xbd',  	  # BOX DRAWINGS LIGHT UP AND LEFT
    0x251c:	b'\xab',  	  # BOX DRAWINGS LIGHT VERTICAL AND RIGHT
    0x2524:	b'\xb3',  	  # BOX DRAWINGS LIGHT VERTICAL AND LEFT
    0x252c:	b'\xb2',  	  # BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
    0x2534:	b'\xb1',  	  # BOX DRAWINGS LIGHT UP AND HORIZONTAL
    0x253c:	b'\xdb',  	  # BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
    0x2581:	b'\xa4',  	  # LOWER ONE EIGHTH BLOCK
    0x2582:	b'\xaf',  	  # LOWER ONE QUARTER BLOCK
    0x2583:	b'\xb9',  	  # LOWER THREE EIGHTHS BLOCK
    0x2584:	b'\xa2',  	  # LOWER HALF BLOCK
    0x258c:	b'\xa1',  	  # LEFT HALF BLOCK
    0x258d:	b'\xb5',  	  # LEFT THREE EIGTHS BLOCK
    0x258e:	b'\xb4',  	  # LEFT ONE QUARTER BLOCK
    0x258f:	b'\xa5',  	  # LEFT ONE EIGHTH BLOCK
    0x2592:	b'\xff',  	  # MEDIUM SHADE
    0x2594:	b'\xa3',  	  # UPPER ONE EIGHTH BLOCK
    0x2595:	b'\xa7',  	  # RIGHT ONE EIGHTH BLOCK
    0x2596:	b'\xbb',  	  # QUADRANT LOWER LEFT
    0x2597:	b'\xac',  	  # QUADRANT LOWER RIGHT
    0x2598:	b'\xbe',  	  # QUADRANT UPPER LEFT
    0x259a:	b'\xbf',  	  # QUADRANT UPPER LEFT AND LOWER RIGHT
    0x259d:	b'\xbc',  	  # QUADRANT UPPER RIGHT
    0x2713:	b'\xba',  	  # CHECK MARK
    0xf100:	b'\x05',  	  # WHITE COLOR SWITCH (CUS)
    0xf101:	b'\x1c',  	  # RED COLOR SWITCH (CUS)
    0xf102:	b'\x1e',  	  # GREEN COLOR SWITCH (CUS)
    0xf103:	b'\x1f',  	  # BLUE COLOR SWITCH (CUS)
    0xf105:	b'\x90',  	  # BLACK COLOR SWITCH (CUS)
    0xf10d:	b'\x9c',  	  # PURPLE COLOR SWITCH (CUS)
    0xf10e:	b'\x9e',  	  # YELLOW COLOR SWITCH (CUS)
    0xf10f:	b'\x9f',  	  # CYAN COLOR SWITCH (CUS)
    0xf110:	b'\x85',  	  # FUNCTION KEY 1 (CUS)
    0xf111:	b'\x89',  	  # FUNCTION KEY 2 (CUS)
    0xf112:	b'\x86',  	  # FUNCTION KEY 3 (CUS)
    0xf113:	b'\x8a',  	  # FUNCTION KEY 4 (CUS)
    0xf114:	b'\x87',  	  # FUNCTION KEY 5 (CUS)
    0xf115:	b'\x8b',  	  # FUNCTION KEY 6 (CUS)
    0xf116:	b'\x88',  	  # FUNCTION KEY 7 (CUS)
    0xf117:	b'\x8c',  	  # FUNCTION KEY 8 (CUS)
    0xf118:	b'\x08',  	  # DISABLE CHARACTER SET SWITCHING (CUS)
    0xf119:	b'\t',    	  # ENABLE CHARACTER SET SWITCHING (CUS)
    0xf11a:	b'\x12',  	  # REVERSE VIDEO ON (CUS)
    0xf11b:	b'\x92',  	  # REVERSE VIDEO OFF (CUS)
    0xf11c:	b'\x11',  	  # CURSOR DOWN (CUS)
    0xf11d:	b'\x1d',  	  # CURSOR RIGHT (CUS)
    0xf11e:	b'\x91',  	  # CURSOR UP (CUS)
    0xf11f:	b'\x9d',  	  # CURSOR LEFT (CUS)
    0xf120:	b'\x13',  	  # HOME (CUS)
    0xf121:	b'\x94',  	  # INSERT (CUS)
    0xf12e:	b'\xdc',  	  # LEFT HALF BLOCK MEDIUM SHADE (CUS)
    0xf12f:	b'\xa8',  	  # LOWER HALF BLOCK MEDIUM SHADE (CUS)
    0xf130:	b'\xaa',  	  # RIGHT ONE QUARTER BLOCK (CUS)
    0xf131:	b'\xb6',  	  # RIGHT THREE EIGHTHS BLOCK (CUS)
    0xf132:	b'\xb7',  	  # UPPER ONE QUARTER BLOCK (CUS)
    0xf133:	b'\xb8',  	  # UPPER THREE EIGHTS BLOCK (CUS)
    0xf139:	b'\xdf',  	  # MEDIUM SHADE SLASHED LEFT (CUS)
    0xf13a:	b'\xa9',  	  # MEDIUM SHADE SLASHED RIGHT (CUS)
}

codecs.register(lambda e: getregentry() if e.replace('-', '_') == 'petscii_vic20en_lc' else None)
