"""
Python Character Mapping Codec for 'petscii_peten_lc' generated by gen-codec.
"""

#    Name:		PETSCII PET English Lowercase to Unicode Table
#    Unicode version:	3.0
#    Table version:	1.00
#    Table format:	Format A
#    Date:		11/11/21
#    Authors:		Simon Rowe <srowe@mose.org.uk>
#    General notes:	Licensed under the GNU GPL, version 2

import codecs

# Codec APIs


class Codec(codecs.Codec):  # pylint: disable=missing-class-docstring
    def encode(self, _input, errors='strict'):
        return codecs.charmap_encode(_input, errors, encoding_table)

    def decode(self, _input, errors='strict'):
        return codecs.charmap_decode(_input, errors, decoding_table)


class IncrementalEncoder(codecs.IncrementalEncoder):  # pylint: disable=missing-class-docstring
    def encode(self, _input, final=False):
        return codecs.charmap_encode(_input, self.errors, encoding_table)[0]


class IncrementalDecoder(codecs.IncrementalDecoder):  # pylint: disable=missing-class-docstring
    def decode(self, _input, final=False):
        return codecs.charmap_decode(_input, self.errors, decoding_table)[0]


class StreamWriter(Codec, codecs.StreamWriter):  # pylint: disable=missing-class-docstring
    pass


class StreamReader(Codec, codecs.StreamReader):  # pylint: disable=missing-class-docstring
    pass


# encodings module API

def getregentry():  # pylint: disable=missing-function-docstring
    return codecs.CodecInfo(
        name='petscii_peten_lc',
        encode=Codec().encode,
        decode=Codec().decode,
        incrementalencoder=IncrementalEncoder,
        incrementaldecoder=IncrementalDecoder,
        streamreader=StreamReader,
        streamwriter=StreamWriter,
    )


decoding_table = {
    0x07:	'\x07',  	  # BELL
    0x09:	'\t',    	  # HORIZONTAL TABULATION
    0x0d:	'\r',    	  # CARRIAGE RETURN
    0x0e:	'\x0e',  	  # SHIFT OUT
    0x0f:	'\uf13d',	  # SET WINDOW TOP (CUS)
    0x11:	'\uf11c',	  # CURSOR DOWN (CUS)
    0x12:	'\uf11a',	  # REVERSE VIDEO ON (CUS)
    0x13:	'\uf120',	  # HOME (CUS)
    0x14:	'\x7f',  	  # DELETE
    0x15:	'\uf13e',	  # KILL LINE (CUS)
    0x16:	'\uf13f',	  # ERASE TO RIGHT (CUS)
    0x19:	'\uf140',	  # SCROLL UP (CUS)
    0x1b:	'\x1b',  	  # ESCAPE
    0x1d:	'\uf11d',	  # CURSOR RIGHT (CUS)
    0x20:	' ',     	  # SPACE
    0x21:	'!',     	  # EXCLAMATION MARK
    0x22:	'"',     	  # QUOTATION MARK
    0x23:	'#',     	  # NUMBER SIGN
    0x24:	'$',     	  # DOLLAR SIGN
    0x25:	'%',     	  # PERCENT SIGN
    0x26:	'&',     	  # AMPERSAND
    0x27:	"'",     	  # APOSTROPHE
    0x28:	'(',     	  # LEFT PARENTHESIS
    0x29:	')',     	  # RIGHT PARENTHESIS
    0x2a:	'*',     	  # ASTERISK
    0x2b:	'+',     	  # PLUS SIGN
    0x2c:	',',     	  # COMMA
    0x2d:	'-',     	  # HYPHEN-MINUS
    0x2e:	'.',     	  # FULL STOP
    0x2f:	'/',     	  # SOLIDUS
    0x30:	'0',     	  # DIGIT ZERO
    0x31:	'1',     	  # DIGIT ONE
    0x32:	'2',     	  # DIGIT TWO
    0x33:	'3',     	  # DIGIT THREE
    0x34:	'4',     	  # DIGIT FOUR
    0x35:	'5',     	  # DIGIT FIVE
    0x36:	'6',     	  # DIGIT SIX
    0x37:	'7',     	  # DIGIT SEVEN
    0x38:	'8',     	  # DIGIT EIGHT
    0x39:	'9',     	  # DIGIT NINE
    0x3a:	':',     	  # COLON
    0x3b:	';',     	  # SEMICOLON
    0x3c:	'<',     	  # LESS-THAN SIGN
    0x3d:	'=',     	  # EQUALS SIGN
    0x3e:	'>',     	  # GREATER-THAN SIGN
    0x3f:	'?',     	  # QUESTION MARK
    0x40:	'@',     	  # COMMERCIAL AT
    0x41:	'a',     	  # LATIN SMALL LETTER A
    0x42:	'b',     	  # LATIN SMALL LETTER B
    0x43:	'c',     	  # LATIN SMALL LETTER C
    0x44:	'd',     	  # LATIN SMALL LETTER D
    0x45:	'e',     	  # LATIN SMALL LETTER E
    0x46:	'f',     	  # LATIN SMALL LETTER F
    0x47:	'g',     	  # LATIN SMALL LETTER G
    0x48:	'h',     	  # LATIN SMALL LETTER H
    0x49:	'i',     	  # LATIN SMALL LETTER I
    0x4a:	'j',     	  # LATIN SMALL LETTER J
    0x4b:	'k',     	  # LATIN SMALL LETTER K
    0x4c:	'l',     	  # LATIN SMALL LETTER L
    0x4d:	'm',     	  # LATIN SMALL LETTER M
    0x4e:	'n',     	  # LATIN SMALL LETTER N
    0x4f:	'o',     	  # LATIN SMALL LETTER O
    0x50:	'p',     	  # LATIN SMALL LETTER P
    0x51:	'q',     	  # LATIN SMALL LETTER Q
    0x52:	'r',     	  # LATIN SMALL LETTER R
    0x53:	's',     	  # LATIN SMALL LETTER S
    0x54:	't',     	  # LATIN SMALL LETTER T
    0x55:	'u',     	  # LATIN SMALL LETTER U
    0x56:	'v',     	  # LATIN SMALL LETTER V
    0x57:	'w',     	  # LATIN SMALL LETTER W
    0x58:	'x',     	  # LATIN SMALL LETTER X
    0x59:	'y',     	  # LATIN SMALL LETTER Y
    0x5a:	'z',     	  # LATIN SMALL LETTER Z
    0x5b:	'[',     	  # LEFT SQUARE BRACKET
    0x5c:	'\\',    	  # BACKSLASH
    0x5d:	']',     	  # RIGHT SQUARE BRACKET
    0x5e:	'\u2191',	  # UPWARDS ARROW
    0x5f:	'\u2190',	  # LEFTWARDS ARROW
    0x60:	' ',     	  # SPACE
    0x61:	'!',     	  # EXCLAMATION MARK
    0x62:	'"',     	  # QUOTATION MARK
    0x63:	'#',     	  # NUMBER SIGN
    0x64:	'$',     	  # DOLLAR SIGN
    0x65:	'%',     	  # PERCENT SIGN
    0x66:	'&',     	  # AMPERSAND
    0x67:	"'",     	  # APOSTROPHE
    0x68:	'(',     	  # LEFT PARENTHESIS
    0x69:	')',     	  # RIGHT PARENTHESIS
    0x6a:	'*',     	  # ASTERISK
    0x6b:	'+',     	  # PLUS SIGN
    0x6c:	',',     	  # COMMA
    0x6d:	'-',     	  # HYPHEN-MINUS
    0x6e:	'.',     	  # FULL STOP
    0x6f:	'/',     	  # SOLIDUS
    0x70:	'0',     	  # DIGIT ZERO
    0x71:	'1',     	  # DIGIT ONE
    0x72:	'2',     	  # DIGIT TWO
    0x73:	'3',     	  # DIGIT THREE
    0x74:	'4',     	  # DIGIT FOUR
    0x75:	'5',     	  # DIGIT FIVE
    0x76:	'6',     	  # DIGIT SIX
    0x77:	'7',     	  # DIGIT SEVEN
    0x78:	'8',     	  # DIGIT EIGHT
    0x79:	'9',     	  # DIGIT NINE
    0x7a:	':',     	  # COLON
    0x7b:	';',     	  # SEMICOLON
    0x7c:	'<',     	  # LESS-THAN SIGN
    0x7d:	'=',     	  # EQUALS SIGN
    0x7e:	'>',     	  # GREATER-THAN SIGN
    0x7f:	'?',     	  # QUESTION MARK
    0x87:	'\uf141',	  # DOUBLE BELL (CUS)
    0x89:	'\x88',  	  # HORIZONTAL TABULATION SET
    0x8d:	'\n',    	  # LINE FEED
    0x8e:	'\x0f',  	  # SHIFT IN
    0x8f:	'\uf142',	  # SET WINDOW END (CUS)
    0x91:	'\uf11e',	  # CURSOR UP (CUS)
    0x92:	'\uf11b',	  # REVERSE VIDEO OFF (CUS)
    0x93:	'\x0c',  	  # FORM FEED
    0x94:	'\uf121',	  # INSERT (CUS)
    0x95:	'\uf143',	  # INSERT LINE ABOVE (CUS)
    0x96:	'\uf144',	  # ERASE TO LEFT (CUS)
    0x99:	'\uf145',	  # SCROLL DOWN (CUS)
    0x9d:	'\uf11f',	  # CURSOR LEFT (CUS)
    0xa0:	'\xa0',  	  # NO-BREAK SPACE
    0xa1:	'\u258c',	  # LEFT HALF BLOCK
    0xa2:	'\u2584',	  # LOWER HALF BLOCK
    0xa3:	'\u2594',	  # UPPER ONE EIGHTH BLOCK
    0xa4:	'\u2581',	  # LOWER ONE EIGHTH BLOCK
    0xa5:	'\u258f',	  # LEFT ONE EIGHTH BLOCK
    0xa6:	'\u2592',	  # MEDIUM SHADE
    0xa7:	'\u2595',	  # RIGHT ONE EIGHTH BLOCK
    0xa8:	'\uf12f',	  # LOWER HALF BLOCK MEDIUM SHADE (CUS)
    0xa9:	'\uf13a',	  # MEDIUM SHADE SLASHED RIGHT (CUS)
    0xaa:	'\uf130',	  # RIGHT ONE QUARTER BLOCK (CUS)
    0xab:	'\u251c',	  # BOX DRAWINGS LIGHT VERTICAL AND RIGHT
    0xac:	'\u2597',	  # QUADRANT LOWER RIGHT
    0xad:	'\u2514',	  # BOX DRAWINGS LIGHT UP AND RIGHT
    0xae:	'\u2510',	  # BOX DRAWINGS LIGHT DOWN AND LEFT
    0xaf:	'\u2582',	  # LOWER ONE QUARTER BLOCK
    0xb0:	'\u250c',	  # BOX DRAWINGS LIGHT DOWN AND RIGHT
    0xb1:	'\u2534',	  # BOX DRAWINGS LIGHT UP AND HORIZONTAL
    0xb2:	'\u252c',	  # BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
    0xb3:	'\u2524',	  # BOX DRAWINGS LIGHT VERTICAL AND LEFT
    0xb4:	'\u258e',	  # LEFT ONE QUARTER BLOCK
    0xb5:	'\u258d',	  # LEFT THREE EIGTHS BLOCK
    0xb6:	'\uf131',	  # RIGHT THREE EIGHTHS BLOCK (CUS)
    0xb7:	'\uf132',	  # UPPER ONE QUARTER BLOCK (CUS)
    0xb8:	'\uf133',	  # UPPER THREE EIGHTS BLOCK (CUS)
    0xb9:	'\u2583',	  # LOWER THREE EIGHTHS BLOCK
    0xba:	'\u2713',	  # CHECK MARK
    0xbb:	'\u2596',	  # QUADRANT LOWER LEFT
    0xbc:	'\u259d',	  # QUADRANT UPPER RIGHT
    0xbd:	'\u2518',	  # BOX DRAWINGS LIGHT UP AND LEFT
    0xbe:	'\u2598',	  # QUADRANT UPPER LEFT
    0xbf:	'\u259a',	  # QUADRANT UPPER LEFT AND LOWER RIGHT
    0xc0:	'\u2500',	  # BOX DRAWINGS LIGHT HORIZONTAL
    0xc1:	'A',     	  # LATIN CAPITAL LETTER A
    0xc2:	'B',     	  # LATIN CAPITAL LETTER B
    0xc3:	'C',     	  # LATIN CAPITAL LETTER C
    0xc4:	'D',     	  # LATIN CAPITAL LETTER D
    0xc5:	'E',     	  # LATIN CAPITAL LETTER E
    0xc6:	'F',     	  # LATIN CAPITAL LETTER F
    0xc7:	'G',     	  # LATIN CAPITAL LETTER G
    0xc8:	'H',     	  # LATIN CAPITAL LETTER H
    0xc9:	'I',     	  # LATIN CAPITAL LETTER I
    0xca:	'J',     	  # LATIN CAPITAL LETTER J
    0xcb:	'K',     	  # LATIN CAPITAL LETTER K
    0xcc:	'L',     	  # LATIN CAPITAL LETTER L
    0xcd:	'M',     	  # LATIN CAPITAL LETTER M
    0xce:	'N',     	  # LATIN CAPITAL LETTER N
    0xcf:	'O',     	  # LATIN CAPITAL LETTER O
    0xd0:	'P',     	  # LATIN CAPITAL LETTER P
    0xd1:	'Q',     	  # LATIN CAPITAL LETTER Q
    0xd2:	'R',     	  # LATIN CAPITAL LETTER R
    0xd3:	'S',     	  # LATIN CAPITAL LETTER S
    0xd4:	'T',     	  # LATIN CAPITAL LETTER T
    0xd5:	'U',     	  # LATIN CAPITAL LETTER U
    0xd6:	'V',     	  # LATIN CAPITAL LETTER V
    0xd7:	'W',     	  # LATIN CAPITAL LETTER W
    0xd8:	'X',     	  # LATIN CAPITAL LETTER X
    0xd9:	'Y',     	  # LATIN CAPITAL LETTER Y
    0xda:	'Z',     	  # LATIN CAPITAL LETTER Z
    0xdb:	'\u253c',	  # BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
    0xdc:	'\uf12e',	  # LEFT HALF BLOCK MEDIUM SHADE (CUS)
    0xdd:	'\u2502',	  # BOX DRAWINGS LIGHT VERTICAL
    0xde:	'\u2592',	  # MEDIUM SHADE
    0xdf:	'\uf139',	  # MEDIUM SHADE SLASHED LEFT (CUS)
    0xe0:	'\xa0',  	  # NO-BREAK SPACE
    0xe1:	'\u258c',	  # LEFT HALF BLOCK
    0xe2:	'\u2584',	  # LOWER HALF BLOCK
    0xe3:	'\u2594',	  # UPPER ONE EIGHTH BLOCK
    0xe4:	'\u2581',	  # LOWER ONE EIGHTH BLOCK
    0xe5:	'\u258f',	  # LEFT ONE EIGHTH BLOCK
    0xe6:	'\u2592',	  # MEDIUM SHADE
    0xe7:	'\u2595',	  # RIGHT ONE EIGHTH BLOCK
    0xe8:	'\uf12f',	  # LOWER HALF BLOCK MEDIUM SHADE (CUS)
    0xe9:	'\uf13a',	  # MEDIUM SHADE SLASHED RIGHT (CUS)
    0xea:	'\uf130',	  # RIGHT ONE QUARTER BLOCK (CUS)
    0xeb:	'\u251c',	  # BOX DRAWINGS LIGHT VERTICAL AND RIGHT
    0xec:	'\u2597',	  # QUADRANT LOWER RIGHT
    0xed:	'\u2514',	  # BOX DRAWINGS LIGHT UP AND RIGHT
    0xee:	'\u2510',	  # BOX DRAWINGS LIGHT DOWN AND LEFT
    0xef:	'\u2582',	  # LOWER ONE QUARTER BLOCK
    0xf0:	'\u250c',	  # BOX DRAWINGS LIGHT DOWN AND RIGHT
    0xf1:	'\u2534',	  # BOX DRAWINGS LIGHT UP AND HORIZONTAL
    0xf2:	'\u252c',	  # BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
    0xf3:	'\u2524',	  # BOX DRAWINGS LIGHT VERTICAL AND LEFT
    0xf4:	'\u258e',	  # LEFT ONE QUARTER BLOCK
    0xf5:	'\u258d',	  # LEFT THREE EIGTHS BLOCK
    0xf6:	'\uf131',	  # RIGHT THREE EIGHTHS BLOCK (CUS)
    0xf7:	'\uf132',	  # UPPER ONE QUARTER BLOCK (CUS)
    0xf8:	'\uf133',	  # UPPER THREE EIGHTS BLOCK (CUS)
    0xf9:	'\u2583',	  # LOWER THREE EIGHTHS BLOCK
    0xfa:	'\u2713',	  # CHECK MARK
    0xfb:	'\u2596',	  # QUADRANT LOWER LEFT
    0xfc:	'\u259d',	  # QUADRANT UPPER RIGHT
    0xfd:	'\u2518',	  # BOX DRAWINGS LIGHT UP AND LEFT
    0xfe:	'\u2598',	  # QUADRANT UPPER LEFT
    0xff:	'\u2592',	  # MEDIUM SHADE
}

encoding_table = {
    0x07:	b'\x07',  	  # BELL
    0x09:	b'\t',    	  # HORIZONTAL TABULATION
    0x0a:	b'\x8d',  	  # LINE FEED
    0x0c:	b'\x93',  	  # FORM FEED
    0x0d:	b'\r',    	  # CARRIAGE RETURN
    0x0e:	b'\x0e',  	  # SHIFT OUT
    0x0f:	b'\x8e',  	  # SHIFT IN
    0x1b:	b'\x1b',  	  # ESCAPE
    0x20:	b'`',     	  # SPACE
    0x21:	b'a',     	  # EXCLAMATION MARK
    0x22:	b'b',     	  # QUOTATION MARK
    0x23:	b'c',     	  # NUMBER SIGN
    0x24:	b'd',     	  # DOLLAR SIGN
    0x25:	b'e',     	  # PERCENT SIGN
    0x26:	b'f',     	  # AMPERSAND
    0x27:	b'g',     	  # APOSTROPHE
    0x28:	b'h',     	  # LEFT PARENTHESIS
    0x29:	b'i',     	  # RIGHT PARENTHESIS
    0x2a:	b'j',     	  # ASTERISK
    0x2b:	b'k',     	  # PLUS SIGN
    0x2c:	b'l',     	  # COMMA
    0x2d:	b'm',     	  # HYPHEN-MINUS
    0x2e:	b'n',     	  # FULL STOP
    0x2f:	b'o',     	  # SOLIDUS
    0x30:	b'p',     	  # DIGIT ZERO
    0x31:	b'q',     	  # DIGIT ONE
    0x32:	b'r',     	  # DIGIT TWO
    0x33:	b's',     	  # DIGIT THREE
    0x34:	b't',     	  # DIGIT FOUR
    0x35:	b'u',     	  # DIGIT FIVE
    0x36:	b'v',     	  # DIGIT SIX
    0x37:	b'w',     	  # DIGIT SEVEN
    0x38:	b'x',     	  # DIGIT EIGHT
    0x39:	b'y',     	  # DIGIT NINE
    0x3a:	b'z',     	  # COLON
    0x3b:	b'{',     	  # SEMICOLON
    0x3c:	b'|',     	  # LESS-THAN SIGN
    0x3d:	b'}',     	  # EQUALS SIGN
    0x3e:	b'~',     	  # GREATER-THAN SIGN
    0x3f:	b'\x7f',  	  # QUESTION MARK
    0x40:	b'@',     	  # COMMERCIAL AT
    0x41:	b'\xc1',  	  # LATIN CAPITAL LETTER A
    0x42:	b'\xc2',  	  # LATIN CAPITAL LETTER B
    0x43:	b'\xc3',  	  # LATIN CAPITAL LETTER C
    0x44:	b'\xc4',  	  # LATIN CAPITAL LETTER D
    0x45:	b'\xc5',  	  # LATIN CAPITAL LETTER E
    0x46:	b'\xc6',  	  # LATIN CAPITAL LETTER F
    0x47:	b'\xc7',  	  # LATIN CAPITAL LETTER G
    0x48:	b'\xc8',  	  # LATIN CAPITAL LETTER H
    0x49:	b'\xc9',  	  # LATIN CAPITAL LETTER I
    0x4a:	b'\xca',  	  # LATIN CAPITAL LETTER J
    0x4b:	b'\xcb',  	  # LATIN CAPITAL LETTER K
    0x4c:	b'\xcc',  	  # LATIN CAPITAL LETTER L
    0x4d:	b'\xcd',  	  # LATIN CAPITAL LETTER M
    0x4e:	b'\xce',  	  # LATIN CAPITAL LETTER N
    0x4f:	b'\xcf',  	  # LATIN CAPITAL LETTER O
    0x50:	b'\xd0',  	  # LATIN CAPITAL LETTER P
    0x51:	b'\xd1',  	  # LATIN CAPITAL LETTER Q
    0x52:	b'\xd2',  	  # LATIN CAPITAL LETTER R
    0x53:	b'\xd3',  	  # LATIN CAPITAL LETTER S
    0x54:	b'\xd4',  	  # LATIN CAPITAL LETTER T
    0x55:	b'\xd5',  	  # LATIN CAPITAL LETTER U
    0x56:	b'\xd6',  	  # LATIN CAPITAL LETTER V
    0x57:	b'\xd7',  	  # LATIN CAPITAL LETTER W
    0x58:	b'\xd8',  	  # LATIN CAPITAL LETTER X
    0x59:	b'\xd9',  	  # LATIN CAPITAL LETTER Y
    0x5a:	b'\xda',  	  # LATIN CAPITAL LETTER Z
    0x5b:	b'[',     	  # LEFT SQUARE BRACKET
    0x5c:	b'\\',    	  # BACKSLASH
    0x5d:	b']',     	  # RIGHT SQUARE BRACKET
    0x61:	b'A',     	  # LATIN SMALL LETTER A
    0x62:	b'B',     	  # LATIN SMALL LETTER B
    0x63:	b'C',     	  # LATIN SMALL LETTER C
    0x64:	b'D',     	  # LATIN SMALL LETTER D
    0x65:	b'E',     	  # LATIN SMALL LETTER E
    0x66:	b'F',     	  # LATIN SMALL LETTER F
    0x67:	b'G',     	  # LATIN SMALL LETTER G
    0x68:	b'H',     	  # LATIN SMALL LETTER H
    0x69:	b'I',     	  # LATIN SMALL LETTER I
    0x6a:	b'J',     	  # LATIN SMALL LETTER J
    0x6b:	b'K',     	  # LATIN SMALL LETTER K
    0x6c:	b'L',     	  # LATIN SMALL LETTER L
    0x6d:	b'M',     	  # LATIN SMALL LETTER M
    0x6e:	b'N',     	  # LATIN SMALL LETTER N
    0x6f:	b'O',     	  # LATIN SMALL LETTER O
    0x70:	b'P',     	  # LATIN SMALL LETTER P
    0x71:	b'Q',     	  # LATIN SMALL LETTER Q
    0x72:	b'R',     	  # LATIN SMALL LETTER R
    0x73:	b'S',     	  # LATIN SMALL LETTER S
    0x74:	b'T',     	  # LATIN SMALL LETTER T
    0x75:	b'U',     	  # LATIN SMALL LETTER U
    0x76:	b'V',     	  # LATIN SMALL LETTER V
    0x77:	b'W',     	  # LATIN SMALL LETTER W
    0x78:	b'X',     	  # LATIN SMALL LETTER X
    0x79:	b'Y',     	  # LATIN SMALL LETTER Y
    0x7a:	b'Z',     	  # LATIN SMALL LETTER Z
    0x7f:	b'\x14',  	  # DELETE
    0x88:	b'\x89',  	  # HORIZONTAL TABULATION SET
    0xa0:	b'\xa0',  	  # NO-BREAK SPACE
    0x2190:	b'_',     	  # LEFTWARDS ARROW
    0x2191:	b'^',     	  # UPWARDS ARROW
    0x2500:	b'\xc0',  	  # BOX DRAWINGS LIGHT HORIZONTAL
    0x2502:	b'\xdd',  	  # BOX DRAWINGS LIGHT VERTICAL
    0x250c:	b'\xb0',  	  # BOX DRAWINGS LIGHT DOWN AND RIGHT
    0x2510:	b'\xae',  	  # BOX DRAWINGS LIGHT DOWN AND LEFT
    0x2514:	b'\xad',  	  # BOX DRAWINGS LIGHT UP AND RIGHT
    0x2518:	b'\xbd',  	  # BOX DRAWINGS LIGHT UP AND LEFT
    0x251c:	b'\xab',  	  # BOX DRAWINGS LIGHT VERTICAL AND RIGHT
    0x2524:	b'\xb3',  	  # BOX DRAWINGS LIGHT VERTICAL AND LEFT
    0x252c:	b'\xb2',  	  # BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
    0x2534:	b'\xb1',  	  # BOX DRAWINGS LIGHT UP AND HORIZONTAL
    0x253c:	b'\xdb',  	  # BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
    0x2581:	b'\xa4',  	  # LOWER ONE EIGHTH BLOCK
    0x2582:	b'\xaf',  	  # LOWER ONE QUARTER BLOCK
    0x2583:	b'\xb9',  	  # LOWER THREE EIGHTHS BLOCK
    0x2584:	b'\xa2',  	  # LOWER HALF BLOCK
    0x258c:	b'\xa1',  	  # LEFT HALF BLOCK
    0x258d:	b'\xb5',  	  # LEFT THREE EIGTHS BLOCK
    0x258e:	b'\xb4',  	  # LEFT ONE QUARTER BLOCK
    0x258f:	b'\xa5',  	  # LEFT ONE EIGHTH BLOCK
    0x2592:	b'\xff',  	  # MEDIUM SHADE
    0x2594:	b'\xa3',  	  # UPPER ONE EIGHTH BLOCK
    0x2595:	b'\xa7',  	  # RIGHT ONE EIGHTH BLOCK
    0x2596:	b'\xbb',  	  # QUADRANT LOWER LEFT
    0x2597:	b'\xac',  	  # QUADRANT LOWER RIGHT
    0x2598:	b'\xbe',  	  # QUADRANT UPPER LEFT
    0x259a:	b'\xbf',  	  # QUADRANT UPPER LEFT AND LOWER RIGHT
    0x259d:	b'\xbc',  	  # QUADRANT UPPER RIGHT
    0x2713:	b'\xba',  	  # CHECK MARK
    0xf11a:	b'\x12',  	  # REVERSE VIDEO ON (CUS)
    0xf11b:	b'\x92',  	  # REVERSE VIDEO OFF (CUS)
    0xf11c:	b'\x11',  	  # CURSOR DOWN (CUS)
    0xf11d:	b'\x1d',  	  # CURSOR RIGHT (CUS)
    0xf11e:	b'\x91',  	  # CURSOR UP (CUS)
    0xf11f:	b'\x9d',  	  # CURSOR LEFT (CUS)
    0xf120:	b'\x13',  	  # HOME (CUS)
    0xf121:	b'\x94',  	  # INSERT (CUS)
    0xf12e:	b'\xdc',  	  # LEFT HALF BLOCK MEDIUM SHADE (CUS)
    0xf12f:	b'\xa8',  	  # LOWER HALF BLOCK MEDIUM SHADE (CUS)
    0xf130:	b'\xaa',  	  # RIGHT ONE QUARTER BLOCK (CUS)
    0xf131:	b'\xb6',  	  # RIGHT THREE EIGHTHS BLOCK (CUS)
    0xf132:	b'\xb7',  	  # UPPER ONE QUARTER BLOCK (CUS)
    0xf133:	b'\xb8',  	  # UPPER THREE EIGHTS BLOCK (CUS)
    0xf139:	b'\xdf',  	  # MEDIUM SHADE SLASHED LEFT (CUS)
    0xf13a:	b'\xa9',  	  # MEDIUM SHADE SLASHED RIGHT (CUS)
    0xf13d:	b'\x0f',  	  # SET WINDOW TOP (CUS)
    0xf13e:	b'\x15',  	  # KILL LINE (CUS)
    0xf13f:	b'\x16',  	  # ERASE TO RIGHT (CUS)
    0xf140:	b'\x19',  	  # SCROLL UP (CUS)
    0xf141:	b'\x87',  	  # DOUBLE BELL (CUS)
    0xf142:	b'\x8f',  	  # SET WINDOW END (CUS)
    0xf143:	b'\x95',  	  # INSERT LINE ABOVE (CUS)
    0xf144:	b'\x96',  	  # ERASE TO LEFT (CUS)
    0xf145:	b'\x99',  	  # SCROLL DOWN (CUS)
}

codecs.register(lambda e: getregentry() if e.replace('-', '_') == 'petscii_peten_lc' else None)
