"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApprovalRuleTemplate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const directories_1 = require("./directories");
class ApprovalRuleTemplate extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const { approvalRuleTemplateName, approvalRuleTemplateDescription, template } = props;
        const serviceToken = aws_cdk_lib_1.CustomResourceProvider.getOrCreate(this, 'Custom::ApprovalRuleTemplate', {
            codeDirectory: directories_1.approvalRuleTemplateDir,
            runtime: aws_cdk_lib_1.CustomResourceProviderRuntime.NODEJS_14_X,
            policyStatements: [
                {
                    Effect: 'Allow',
                    Action: [
                        'codecommit:CreateApprovalRuleTemplate',
                        'codecommit:DeleteApprovalRuleTemplate',
                        'codecommit:GetApprovalRuleTemplate',
                        'codecommit:UpdateApprovalRuleTemplateContent',
                        'codecommit:UpdateApprovalRuleTemplateDescription',
                        'codecommit:UpdateApprovalRuleTemplateName',
                    ],
                    Resource: '*',
                },
            ],
        });
        const resource = new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken,
            resourceType: 'Custom::ApprovalRuleTemplate',
            properties: {
                ApprovalRuleTemplateName: approvalRuleTemplateName,
                ApprovalRuleTemplateDescription: approvalRuleTemplateDescription,
                Template: {
                    DestinationReferences: (_b = template.branches) === null || _b === void 0 ? void 0 : _b.map((branch) => `refs/heads/${branch}`),
                    Approvers: {
                        NumberOfApprovalsNeeded: template.approvers.numberOfApprovalsNeeded,
                        ApprovalPoolMembers: template.approvers.approvalPoolMembers,
                    },
                },
            },
        });
        this.approvalRuleTemplateName = resource.getAttString('ApprovalRuleTemplateName');
    }
}
exports.ApprovalRuleTemplate = ApprovalRuleTemplate;
_a = JSII_RTTI_SYMBOL_1;
ApprovalRuleTemplate[_a] = { fqn: "@cloudcomponents/cdk-pull-request-approval-rule.ApprovalRuleTemplate", version: "2.0.0" };
//# sourceMappingURL=data:application/json;base64,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