"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApprovalRuleTemplateRepositoryAssociation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const directories_1 = require("./directories");
class ApprovalRuleTemplateRepositoryAssociation extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.repository = props.repository;
        const resourceType = 'Custom::ApprovalRuleTemplateRepositoryAssociation';
        const serviceToken = aws_cdk_lib_1.CustomResourceProvider.getOrCreate(this, resourceType, {
            codeDirectory: directories_1.approvalRuleTemplateRepositoryAssociationDir,
            runtime: aws_cdk_lib_1.CustomResourceProviderRuntime.NODEJS_14_X,
            policyStatements: [
                {
                    Effect: 'Allow',
                    Action: ['codecommit:AssociateApprovalRuleTemplateWithRepository', 'codecommit:DisassociateApprovalRuleTemplateFromRepository'],
                    Resource: '*',
                },
            ],
        });
        new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken,
            resourceType,
            properties: {
                ApprovalRuleTemplateName: props.approvalRuleTemplateName,
                RepositoryName: this.repository.repositoryName,
            },
        });
    }
    onOverridden(id, options) {
        const rule = this.repository.onPullRequestStateChange(id, options);
        rule.addEventPattern({
            detail: {
                event: ['pullRequestApprovalRuleOverridden'],
            },
        });
        return rule;
    }
}
exports.ApprovalRuleTemplateRepositoryAssociation = ApprovalRuleTemplateRepositoryAssociation;
_a = JSII_RTTI_SYMBOL_1;
ApprovalRuleTemplateRepositoryAssociation[_a] = { fqn: "@cloudcomponents/cdk-pull-request-approval-rule.ApprovalRuleTemplateRepositoryAssociation", version: "2.0.0" };
//# sourceMappingURL=data:application/json;base64,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