lowercase_letters = """abcdefghijklmnopqrstuvwxyz"""
uppercase_letters = """ABCDEFGHIJKLMNOPQRSTUVWXYZ"""
numbers = """0123456789"""
symbols = """!#\$%&'()*+,-./:;"@[]^_`{|}~>?= """
symbols_set = set(symbols)
all_chars = set(lowercase_letters + uppercase_letters + numbers + symbols + " " + "\<")
other_symbols = {"<space>": " ",
                 "less": "<"}


def get_font():
    return ("Calibri", 11, "normal")

def get_heading_font():
    return ("Calibri", 10, "normal")

def is_iterable(o):
    try:
        for e in o:
            return True
    except:
        return False

theme_light_blue = {
'popup_menu_fg': "gray2",
'popup_menu_bg': "#f2f2f2",
'popup_menu_highlight_bg': "#91c9f7",
'popup_menu_highlight_fg': "black",
'index_hidden_rows_expander_bg': "gray30",
'header_hidden_columns_expander_bg': "gray30",
'header_bg': "#f8f9fa",
'header_border_fg': "#ababab",
'header_grid_fg': "#ababab",
'header_fg': "#373737",
'header_selected_cells_bg': "#e8eaed",
'header_selected_cells_fg': "black",
'index_bg': "#f8f9fa",
'index_border_fg': "#ababab",
'index_grid_fg': "#ababab",
'index_fg': "black",
'index_selected_cells_bg': "#e8eaed",
'index_selected_cells_fg': "black",
'top_left_bg': "#fcfcfc",
'top_left_fg': "#c2c9cf",
'top_left_fg_highlight': "#5f6368",
'table_bg': "#fcfcfc",
'table_grid_fg': "#d4d4d4",
'table_fg': "black",
'table_selected_cells_border_fg': "#1a73e8",
'table_selected_cells_bg': "#e7f0fd",
'table_selected_cells_fg': "black",
'resizing_line_fg': "black",
'drag_and_drop_bg': "gray30",
'outline_color': "gray2",
'header_selected_columns_bg': "#5f6368",
'header_selected_columns_fg': "#fcfcfc",
'index_selected_rows_bg': "#5f6368",
'index_selected_rows_fg': "#fcfcfc",
'table_selected_rows_border_fg': "#1a73e8",
'table_selected_rows_bg': "#e7f0fd",
'table_selected_rows_fg': "black",
'table_selected_columns_border_fg': "#1a73e8",
'table_selected_columns_bg': "#e7f0fd",
'table_selected_columns_fg': "black"
}


theme_light_green = {
'popup_menu_fg': "gray2",
'popup_menu_bg': "#f2f2f2",
'popup_menu_highlight_bg': "#91c9f7",
'popup_menu_highlight_fg': "black",
'index_hidden_rows_expander_bg': "gray30",
'header_hidden_columns_expander_bg': "gray30",
'header_bg': "#ECECEC",
'header_border_fg': "#ababab",
'header_grid_fg': "#ababab",
'header_fg': "#373737",
'header_selected_cells_bg': "#d6d4d2",
'header_selected_cells_fg': "#217346",
'index_bg': "#ECECEC",
'index_border_fg': "#ababab",
'index_grid_fg': "#ababab",
'index_fg': "black",
'index_selected_cells_bg': "#d6d4d2",
'index_selected_cells_fg': "#217346",
'top_left_bg': "#ECECEC",
'top_left_fg': "#b7b7b7",
'top_left_fg_highlight': "#5f6368",
'table_bg': "#fcfcfc",
'table_grid_fg': "#bfbfbf",
'table_fg': "#373737",
'table_selected_cells_border_fg': "#217346",
'table_selected_cells_bg': "#edeeed",
'table_selected_cells_fg': "#0a0a0a",
'resizing_line_fg': "black",
'drag_and_drop_bg': "gray30",
'outline_color': "gray2",
'header_selected_columns_bg': "#d3f0e0",
'header_selected_columns_fg': "#217346",
'index_selected_rows_bg': "#d3f0e0",
'index_selected_rows_fg': "#217346",
'table_selected_rows_border_fg': "#217346",
'table_selected_rows_bg': "#edeeed",
'table_selected_rows_fg': "#333333",
'table_selected_columns_border_fg': "#217346",
'table_selected_columns_bg': "#edeeed",
'table_selected_columns_fg': "#333333"
}

theme_dark = {
'popup_menu_fg': "white",
'popup_menu_bg': "gray15",
'popup_menu_highlight_bg': "gray35",
'popup_menu_highlight_fg': "white",
'index_hidden_rows_expander_bg': "gray30",
'header_hidden_columns_expander_bg': "gray30",
'header_bg': "#19191e",
'header_border_fg': "#505054",
'header_grid_fg': "#505054",
'header_fg': "#c2c9cf",
'header_selected_cells_bg': "#3e3e45",
'header_selected_cells_fg': "white",
'index_bg': "#19191e",
'index_border_fg': "#505054",
'index_grid_fg': "#505054",
'index_fg': "#c2c9cf",
'index_selected_cells_bg': "#3e3e45",
'index_selected_cells_fg': "white",
'top_left_bg': "#3d3d3d",
'top_left_fg': "#505054",
'top_left_fg_highlight': "#c2c9cf",
'table_bg': "#000000",
'table_grid_fg': "#505054",
'table_fg': "#bcbcbc",
'table_selected_cells_border_fg': "#bdbdbd",
'table_selected_cells_bg': "#313034",
'table_selected_cells_fg': "#dbdbdb",
'resizing_line_fg': "white",
'drag_and_drop_bg': "white",
'outline_color': "gray95",
'header_selected_columns_bg': "#3e3e45",
'header_selected_columns_fg': "white",
'index_selected_rows_bg': "#3e3e45",
'index_selected_rows_fg': "white",
'table_selected_rows_border_fg': "#bdbdbd",
'table_selected_rows_bg': "#313034",
'table_selected_rows_fg': "#dbdbdb",
'table_selected_columns_border_fg': "#bdbdbd",
'table_selected_columns_bg': "#313034",
'table_selected_columns_fg': "#dbdbdb"
}

theme_black = {
'popup_menu_fg': "white",
'popup_menu_bg': "gray15",
'popup_menu_highlight_bg': "gray35",
'popup_menu_highlight_fg': "white",
'index_hidden_rows_expander_bg': "gray30",
'header_hidden_columns_expander_bg': "gray30",
'header_bg': "#000000",
'header_border_fg': "#505054",
'header_grid_fg': "#505054",
'header_fg': "#ffb867",
'header_selected_cells_bg': "#3e3e45",
'header_selected_cells_fg': "#ffb867",
'index_bg': "#000000",
'index_border_fg': "#505054",
'index_grid_fg': "#505054",
'index_fg': "#ffb867",
'index_selected_cells_bg': "#3e3e45",
'index_selected_cells_fg': "#ffb867",
'top_left_bg': "#000000",
'top_left_fg': "#505054",
'top_left_fg_highlight': "#ffb867",
'table_bg': "#000000",
'table_grid_fg': "#505054",
'table_fg': "#F2F2F2",
'table_selected_cells_border_fg': "#bdbdbd",
'table_selected_cells_bg': "#313034",
'table_selected_cells_fg': "#FFFFFF",
'resizing_line_fg': "#ffb867",
'drag_and_drop_bg': "#ecf0f2",
'outline_color': "gray95",
'header_selected_columns_bg': "#3e3e45",
'header_selected_columns_fg': "#ffb867",
'index_selected_rows_bg': "#3e3e45",
'index_selected_rows_fg': "#ffb867",
'table_selected_rows_border_fg': "#bdbdbd",
'table_selected_rows_bg': "#313034",
'table_selected_rows_fg': "#FFFFFF",
'table_selected_columns_border_fg': "#bdbdbd",
'table_selected_columns_bg': "#313034",
'table_selected_columns_fg': "#FFFFFF"
}

theme_dark_blue = {
'popup_menu_fg': "white",
'popup_menu_bg': "gray15",
'popup_menu_highlight_bg': "gray35",
'popup_menu_highlight_fg': "white",
'index_hidden_rows_expander_bg': "gray30",
'header_hidden_columns_expander_bg': "gray30",
'header_bg': "#2d2d2d",
'header_border_fg': "#4a4e51",
'header_grid_fg': "#4a4e51",
'header_fg': "#c2c9cf",
'header_selected_cells_bg': "#35619c",
'header_selected_cells_fg': "#fcfcfc",
'index_bg': "#2d2d2d",
'index_border_fg': "#4a4e51",
'index_grid_fg': "#4a4e51",
'index_fg': "#c2c9cf",
'index_selected_cells_bg': "#35619c",
'index_selected_cells_fg': "#fcfcfc",
'top_left_bg': "#3d3d3d",
'top_left_fg': "#4a4e51",
'top_left_fg_highlight': "#c2c9cf",
'table_bg': "#3d3d3d",
'table_grid_fg': "#4a4e51",
'table_fg': "#ecf0f2",
'table_selected_cells_border_fg': "#1a73e8",
'table_selected_cells_bg': "#004567",
'table_selected_cells_fg': "#fcfcfc",
'resizing_line_fg': "#fcfcfc",
'drag_and_drop_bg': "#ecf0f2",
'outline_color': "gray95",
'header_selected_columns_bg': "#c2c9cf",
'header_selected_columns_fg': "#2d2d2d",
'index_selected_rows_bg': "#c2c9cf",
'index_selected_rows_fg': "#2d2d2d",
'table_selected_rows_border_fg': "#1a73e8",
'table_selected_rows_bg': "#004567",
'table_selected_rows_fg': "#fcfcfc",
'table_selected_columns_border_fg': "#1a73e8",
'table_selected_columns_bg': "#004567",
'table_selected_columns_fg': "#fcfcfc"
}


theme_dark_green = {
'popup_menu_fg': "white",
'popup_menu_bg': "gray15",
'popup_menu_highlight_bg': "gray35",
'popup_menu_highlight_fg': "white",
'index_hidden_rows_expander_bg': "gray30",
'header_hidden_columns_expander_bg': "gray30",
'header_bg': "#2d2d2d",
'header_border_fg': "#5f5a55",
'header_grid_fg': "#5f5a55",
'header_fg': "#c2c9cf",
'header_selected_cells_bg': "#267d73",
'header_selected_cells_fg': "#fcfcfc",
'index_bg': "#2d2d2d",
'index_border_fg': "#5f5a55",
'index_grid_fg': "#5f5a55",
'index_fg': "#c2c9cf",
'index_selected_cells_bg': "#267d73",
'index_selected_cells_fg': "#fcfcfc",
'top_left_bg': "#3d3d3d",
'top_left_fg': "#5f5a55",
'top_left_fg_highlight': "#c2c9cf",
'table_bg': "#3d3d3d",
'table_grid_fg': "#5f5a55",
'table_fg': "#ecf0f2",
'table_selected_cells_border_fg': "#67c9d0",
'table_selected_cells_bg': "#2e4744",
'table_selected_cells_fg': "#fcfcfc",
'resizing_line_fg': "#fcfcfc",
'drag_and_drop_bg': "#ecf0f2",
'outline_color': "gray95",
'header_selected_columns_bg': "#c2c9cf",
'header_selected_columns_fg': "#2d2d2d",
'index_selected_rows_bg': "#c2c9cf",
'index_selected_rows_fg': "#2d2d2d",
'table_selected_rows_border_fg': "#67c9d0",
'table_selected_rows_bg': "#2e4744",
'table_selected_rows_fg': "#fcfcfc",
'table_selected_columns_border_fg': "#67c9d0",
'table_selected_columns_bg': "#2e4744",
'table_selected_columns_fg': "#fcfcfc"
}


Color_Map_ = {
'alice blue': '#F0F8FF',
'ALICE BLUE': '#F0F8FF',
'AliceBlue': '#F0F8FF',
'aliceblue': '#F0F8FF',
'ALICEBLUE': '#F0F8FF',
'antique white': '#FAEBD7',
'ANTIQUE WHITE': '#FAEBD7',
'AntiqueWhite': '#FAEBD7',
'antiquewhite': '#FAEBD7',
'ANTIQUEWHITE': '#FAEBD7',
'AntiqueWhite1': '#FFEFDB',
'antiquewhite1': '#FFEFDB',
'ANTIQUEWHITE1': '#FFEFDB',
'AntiqueWhite2': '#EEDFCC',
'antiquewhite2': '#EEDFCC',
'ANTIQUEWHITE2': '#EEDFCC',
'AntiqueWhite3': '#CDC0B0',
'antiquewhite3': '#CDC0B0',
'ANTIQUEWHITE3': '#CDC0B0',
'AntiqueWhite4': '#8B8378',
'antiquewhite4': '#8B8378',
'ANTIQUEWHITE4': '#8B8378',
'aquamarine': '#7FFFD4',
'AQUAMARINE': '#7FFFD4',
'aquamarine1': '#7FFFD4',
'AQUAMARINE1': '#7FFFD4',
'aquamarine2': '#76EEC6',
'AQUAMARINE2': '#76EEC6',
'aquamarine3': '#66CDAA',
'AQUAMARINE3': '#66CDAA',
'aquamarine4': '#458B74',
'AQUAMARINE4': '#458B74',
'azure': '#F0FFFF',
'AZURE': '#F0FFFF',
'azure1': '#F0FFFF',
'AZURE1': '#F0FFFF',
'azure2': '#E0EEEE',
'AZURE2': '#E0EEEE',
'azure3': '#C1CDCD',
'AZURE3': '#C1CDCD',
'azure4': '#838B8B',
'AZURE4': '#838B8B',
'beige': '#F5F5DC',
'BEIGE': '#F5F5DC',
'bisque': '#FFE4C4',
'BISQUE': '#FFE4C4',
'bisque1': '#FFE4C4',
'BISQUE1': '#FFE4C4',
'bisque2': '#EED5B7',
'BISQUE2': '#EED5B7',
'bisque3': '#CDB79E',
'BISQUE3': '#CDB79E',
'bisque4': '#8B7D6B',
'BISQUE4': '#8B7D6B',
'black': '#000000',
'BLACK': '#000000',
'blanched almond': '#FFEBCD',
'BLANCHED ALMOND': '#FFEBCD',
'BlanchedAlmond': '#FFEBCD',
'blanchedalmond': '#FFEBCD',
'BLANCHEDALMOND': '#FFEBCD',
'blue': '#0000FF',
'BLUE': '#0000FF',
'blue violet': '#8A2BE2',
'BLUE VIOLET': '#8A2BE2',
'blue1': '#0000FF',
'BLUE1': '#0000FF',
'blue2': '#0000EE',
'BLUE2': '#0000EE',
'blue3': '#0000CD',
'BLUE3': '#0000CD',
'blue4': '#00008B',
'BLUE4': '#00008B',
'BlueViolet': '#8A2BE2',
'blueviolet': '#8A2BE2',
'BLUEVIOLET': '#8A2BE2',
'brown': '#A52A2A',
'BROWN': '#A52A2A',
'brown1': '#FF4040',
'BROWN1': '#FF4040',
'brown2': '#EE3B3B',
'BROWN2': '#EE3B3B',
'brown3': '#CD3333',
'BROWN3': '#CD3333',
'brown4': '#8B2323',
'BROWN4': '#8B2323',
'burlywood': '#DEB887',
'BURLYWOOD': '#DEB887',
'burlywood1': '#FFD39B',
'BURLYWOOD1': '#FFD39B',
'burlywood2': '#EEC591',
'BURLYWOOD2': '#EEC591',
'burlywood3': '#CDAA7D',
'BURLYWOOD3': '#CDAA7D',
'burlywood4': '#8B7355',
'BURLYWOOD4': '#8B7355',
'cadet blue': '#5F9EA0',
'CADET BLUE': '#5F9EA0',
'CadetBlue': '#5F9EA0',
'cadetblue': '#5F9EA0',
'CADETBLUE': '#5F9EA0',
'CadetBlue1': '#98F5FF',
'cadetblue1': '#98F5FF',
'CADETBLUE1': '#98F5FF',
'CadetBlue2': '#8EE5EE',
'cadetblue2': '#8EE5EE',
'CADETBLUE2': '#8EE5EE',
'CadetBlue3': '#7AC5CD',
'cadetblue3': '#7AC5CD',
'CADETBLUE3': '#7AC5CD',
'CadetBlue4': '#53868B',
'cadetblue4': '#53868B',
'CADETBLUE4': '#53868B',
'chartreuse': '#7FFF00',
'CHARTREUSE': '#7FFF00',
'chartreuse1': '#7FFF00',
'CHARTREUSE1': '#7FFF00',
'chartreuse2': '#76EE00',
'CHARTREUSE2': '#76EE00',
'chartreuse3': '#66CD00',
'CHARTREUSE3': '#66CD00',
'chartreuse4': '#458B00',
'CHARTREUSE4': '#458B00',
'chocolate': '#D2691E',
'CHOCOLATE': '#D2691E',
'chocolate1': '#FF7F24',
'CHOCOLATE1': '#FF7F24',
'chocolate2': '#EE7621',
'CHOCOLATE2': '#EE7621',
'chocolate3': '#CD661D',
'CHOCOLATE3': '#CD661D',
'chocolate4': '#8B4513',
'CHOCOLATE4': '#8B4513',
'coral': '#FF7F50',
'CORAL': '#FF7F50',
'coral1': '#FF7256',
'CORAL1': '#FF7256',
'coral2': '#EE6A50',
'CORAL2': '#EE6A50',
'coral3': '#CD5B45',
'CORAL3': '#CD5B45',
'coral4': '#8B3E2F',
'CORAL4': '#8B3E2F',
'cornflower blue': '#6495ED',
'CORNFLOWER BLUE': '#6495ED',
'CornflowerBlue': '#6495ED',
'cornflowerblue': '#6495ED',
'CORNFLOWERBLUE': '#6495ED',
'cornsilk': '#FFF8DC',
'CORNSILK': '#FFF8DC',
'cornsilk1': '#FFF8DC',
'CORNSILK1': '#FFF8DC',
'cornsilk2': '#EEE8CD',
'CORNSILK2': '#EEE8CD',
'cornsilk3': '#CDC8B1',
'CORNSILK3': '#CDC8B1',
'cornsilk4': '#8B8878',
'CORNSILK4': '#8B8878',
'cyan': '#00FFFF',
'CYAN': '#00FFFF',
'cyan1': '#00FFFF',
'CYAN1': '#00FFFF',
'cyan2': '#00EEEE',
'CYAN2': '#00EEEE',
'cyan3': '#00CDCD',
'CYAN3': '#00CDCD',
'cyan4': '#008B8B',
'CYAN4': '#008B8B',
'dark blue': '#00008B',
'DARK BLUE': '#00008B',
'dark cyan': '#008B8B',
'DARK CYAN': '#008B8B',
'dark goldenrod': '#B8860B',
'DARK GOLDENROD': '#B8860B',
'dark gray': '#A9A9A9',
'DARK GRAY': '#A9A9A9',
'dark green': '#006400',
'DARK GREEN': '#006400',
'dark grey': '#A9A9A9',
'DARK GREY': '#A9A9A9',
'dark khaki': '#BDB76B',
'DARK KHAKI': '#BDB76B',
'dark magenta': '#8B008B',
'DARK MAGENTA': '#8B008B',
'dark olive green': '#556B2F',
'DARK OLIVE GREEN': '#556B2F',
'dark orange': '#FF8C00',
'DARK ORANGE': '#FF8C00',
'dark orchid': '#9932CC',
'DARK ORCHID': '#9932CC',
'dark red': '#8B0000',
'DARK RED': '#8B0000',
'dark salmon': '#E9967A',
'DARK SALMON': '#E9967A',
'dark sea green': '#8FBC8F',
'DARK SEA GREEN': '#8FBC8F',
'dark slate blue': '#483D8B',
'DARK SLATE BLUE': '#483D8B',
'dark slate gray': '#2F4F4F',
'DARK SLATE GRAY': '#2F4F4F',
'dark slate grey': '#2F4F4F',
'DARK SLATE GREY': '#2F4F4F',
'dark turquoise': '#00CED1',
'DARK TURQUOISE': '#00CED1',
'dark violet': '#9400D3',
'DARK VIOLET': '#9400D3',
'DarkBlue': '#00008B',
'darkblue': '#00008B',
'DARKBLUE': '#00008B',
'DarkCyan': '#008B8B',
'darkcyan': '#008B8B',
'DARKCYAN': '#008B8B',
'DarkGoldenrod': '#B8860B',
'darkgoldenrod': '#B8860B',
'DARKGOLDENROD': '#B8860B',
'DarkGoldenrod1': '#FFB90F',
'darkgoldenrod1': '#FFB90F',
'DARKGOLDENROD1': '#FFB90F',
'DarkGoldenrod2': '#EEAD0E',
'darkgoldenrod2': '#EEAD0E',
'DARKGOLDENROD2': '#EEAD0E',
'DarkGoldenrod3': '#CD950C',
'darkgoldenrod3': '#CD950C',
'DARKGOLDENROD3': '#CD950C',
'DarkGoldenrod4': '#8B6508',
'darkgoldenrod4': '#8B6508',
'DARKGOLDENROD4': '#8B6508',
'DarkGray': '#A9A9A9',
'darkgray': '#A9A9A9',
'DARKGRAY': '#A9A9A9',
'DarkGreen': '#006400',
'darkgreen': '#006400',
'DARKGREEN': '#006400',
'DarkGrey': '#A9A9A9',
'darkgrey': '#A9A9A9',
'DARKGREY': '#A9A9A9',
'DarkKhaki': '#BDB76B',
'darkkhaki': '#BDB76B',
'DARKKHAKI': '#BDB76B',
'DarkMagenta': '#8B008B',
'darkmagenta': '#8B008B',
'DARKMAGENTA': '#8B008B',
'DarkOliveGreen': '#556B2F',
'darkolivegreen': '#556B2F',
'DARKOLIVEGREEN': '#556B2F',
'DarkOliveGreen1': '#CAFF70',
'darkolivegreen1': '#CAFF70',
'DARKOLIVEGREEN1': '#CAFF70',
'DarkOliveGreen2': '#BCEE68',
'darkolivegreen2': '#BCEE68',
'DARKOLIVEGREEN2': '#BCEE68',
'DarkOliveGreen3': '#A2CD5A',
'darkolivegreen3': '#A2CD5A',
'DARKOLIVEGREEN3': '#A2CD5A',
'DarkOliveGreen4': '#6E8B3D',
'darkolivegreen4': '#6E8B3D',
'DARKOLIVEGREEN4': '#6E8B3D',
'DarkOrange': '#FF8C00',
'darkorange': '#FF8C00',
'DARKORANGE': '#FF8C00',
'DarkOrange1': '#FF7F00',
'darkorange1': '#FF7F00',
'DARKORANGE1': '#FF7F00',
'DarkOrange2': '#EE7600',
'darkorange2': '#EE7600',
'DARKORANGE2': '#EE7600',
'DarkOrange3': '#CD6600',
'darkorange3': '#CD6600',
'DARKORANGE3': '#CD6600',
'DarkOrange4': '#8B4500',
'darkorange4': '#8B4500',
'DARKORANGE4': '#8B4500',
'DarkOrchid': '#9932CC',
'darkorchid': '#9932CC',
'DARKORCHID': '#9932CC',
'DarkOrchid1': '#BF3EFF',
'darkorchid1': '#BF3EFF',
'DARKORCHID1': '#BF3EFF',
'DarkOrchid2': '#B23AEE',
'darkorchid2': '#B23AEE',
'DARKORCHID2': '#B23AEE',
'DarkOrchid3': '#9A32CD',
'darkorchid3': '#9A32CD',
'DARKORCHID3': '#9A32CD',
'DarkOrchid4': '#68228B',
'darkorchid4': '#68228B',
'DARKORCHID4': '#68228B',
'DarkRed': '#8B0000',
'darkred': '#8B0000',
'DARKRED': '#8B0000',
'DarkSalmon': '#E9967A',
'darksalmon': '#E9967A',
'DARKSALMON': '#E9967A',
'DarkSeaGreen': '#8FBC8F',
'darkseagreen': '#8FBC8F',
'DARKSEAGREEN': '#8FBC8F',
'DarkSeaGreen1': '#C1FFC1',
'darkseagreen1': '#C1FFC1',
'DARKSEAGREEN1': '#C1FFC1',
'DarkSeaGreen2': '#B4EEB4',
'darkseagreen2': '#B4EEB4',
'DARKSEAGREEN2': '#B4EEB4',
'DarkSeaGreen3': '#9BCD9B',
'darkseagreen3': '#9BCD9B',
'DARKSEAGREEN3': '#9BCD9B',
'DarkSeaGreen4': '#698B69',
'darkseagreen4': '#698B69',
'DARKSEAGREEN4': '#698B69',
'DarkSlateBlue': '#483D8B',
'darkslateblue': '#483D8B',
'DARKSLATEBLUE': '#483D8B',
'DarkSlateGray': '#2F4F4F',
'darkslategray': '#2F4F4F',
'DARKSLATEGRAY': '#2F4F4F',
'DarkSlateGray1': '#97FFFF',
'darkslategray1': '#97FFFF',
'DARKSLATEGRAY1': '#97FFFF',
'DarkSlateGray2': '#8DEEEE',
'darkslategray2': '#8DEEEE',
'DARKSLATEGRAY2': '#8DEEEE',
'DarkSlateGray3': '#79CDCD',
'darkslategray3': '#79CDCD',
'DARKSLATEGRAY3': '#79CDCD',
'DarkSlateGray4': '#528B8B',
'darkslategray4': '#528B8B',
'DARKSLATEGRAY4': '#528B8B',
'DarkSlateGrey': '#2F4F4F',
'darkslategrey': '#2F4F4F',
'DARKSLATEGREY': '#2F4F4F',
'DarkTurquoise': '#00CED1',
'darkturquoise': '#00CED1',
'DARKTURQUOISE': '#00CED1',
'DarkViolet': '#9400D3',
'darkviolet': '#9400D3',
'DARKVIOLET': '#9400D3',
'deep pink': '#FF1493',
'DEEP PINK': '#FF1493',
'deep sky blue': '#00BFFF',
'DEEP SKY BLUE': '#00BFFF',
'DeepPink': '#FF1493',
'deeppink': '#FF1493',
'DEEPPINK': '#FF1493',
'DeepPink1': '#FF1493',
'deeppink1': '#FF1493',
'DEEPPINK1': '#FF1493',
'DeepPink2': '#EE1289',
'deeppink2': '#EE1289',
'DEEPPINK2': '#EE1289',
'DeepPink3': '#CD1076',
'deeppink3': '#CD1076',
'DEEPPINK3': '#CD1076',
'DeepPink4': '#8B0A50',
'deeppink4': '#8B0A50',
'DEEPPINK4': '#8B0A50',
'DeepSkyBlue': '#00BFFF',
'deepskyblue': '#00BFFF',
'DEEPSKYBLUE': '#00BFFF',
'DeepSkyBlue1': '#00BFFF',
'deepskyblue1': '#00BFFF',
'DEEPSKYBLUE1': '#00BFFF',
'DeepSkyBlue2': '#00B2EE',
'deepskyblue2': '#00B2EE',
'DEEPSKYBLUE2': '#00B2EE',
'DeepSkyBlue3': '#009ACD',
'deepskyblue3': '#009ACD',
'DEEPSKYBLUE3': '#009ACD',
'DeepSkyBlue4': '#00688B',
'deepskyblue4': '#00688B',
'DEEPSKYBLUE4': '#00688B',
'dim gray': '#696969',
'DIM GRAY': '#696969',
'dim grey': '#696969',
'DIM GREY': '#696969',
'DimGray': '#696969',
'dimgray': '#696969',
'DIMGRAY': '#696969',
'DimGrey': '#696969',
'dimgrey': '#696969',
'DIMGREY': '#696969',
'dodger blue': '#1E90FF',
'DODGER BLUE': '#1E90FF',
'DodgerBlue': '#1E90FF',
'dodgerblue': '#1E90FF',
'DODGERBLUE': '#1E90FF',
'DodgerBlue1': '#1E90FF',
'dodgerblue1': '#1E90FF',
'DODGERBLUE1': '#1E90FF',
'DodgerBlue2': '#1C86EE',
'dodgerblue2': '#1C86EE',
'DODGERBLUE2': '#1C86EE',
'DodgerBlue3': '#1874CD',
'dodgerblue3': '#1874CD',
'DODGERBLUE3': '#1874CD',
'DodgerBlue4': '#104E8B',
'dodgerblue4': '#104E8B',
'DODGERBLUE4': '#104E8B',
'firebrick': '#B22222',
'FIREBRICK': '#B22222',
'firebrick1': '#FF3030',
'FIREBRICK1': '#FF3030',
'firebrick2': '#EE2C2C',
'FIREBRICK2': '#EE2C2C',
'firebrick3': '#CD2626',
'FIREBRICK3': '#CD2626',
'firebrick4': '#8B1A1A',
'FIREBRICK4': '#8B1A1A',
'floral white': '#FFFAF0',
'FLORAL WHITE': '#FFFAF0',
'FloralWhite': '#FFFAF0',
'floralwhite': '#FFFAF0',
'FLORALWHITE': '#FFFAF0',
'forest green': '#228B22',
'FOREST GREEN': '#228B22',
'ForestGreen': '#228B22',
'forestgreen': '#228B22',
'FORESTGREEN': '#228B22',
'gainsboro': '#DCDCDC',
'GAINSBORO': '#DCDCDC',
'ghost white': '#F8F8FF',
'GHOST WHITE': '#F8F8FF',
'GhostWhite': '#F8F8FF',
'ghostwhite': '#F8F8FF',
'GHOSTWHITE': '#F8F8FF',
'gold': '#FFD700',
'GOLD': '#FFD700',
'gold1': '#FFD700',
'GOLD1': '#FFD700',
'gold2': '#EEC900',
'GOLD2': '#EEC900',
'gold3': '#CDAD00',
'GOLD3': '#CDAD00',
'gold4': '#8B7500',
'GOLD4': '#8B7500',
'goldenrod': '#DAA520',
'GOLDENROD': '#DAA520',
'goldenrod1': '#FFC125',
'GOLDENROD1': '#FFC125',
'goldenrod2': '#EEB422',
'GOLDENROD2': '#EEB422',
'goldenrod3': '#CD9B1D',
'GOLDENROD3': '#CD9B1D',
'goldenrod4': '#8B6914',
'GOLDENROD4': '#8B6914',
'gray': '#BEBEBE',
'GRAY': '#BEBEBE',
'gray0': '#000000',
'GRAY0': '#000000',
'gray1': '#030303',
'GRAY1': '#030303',
'gray2': '#050505',
'GRAY2': '#050505',
'gray3': '#080808',
'GRAY3': '#080808',
'gray4': '#0A0A0A',
'GRAY4': '#0A0A0A',
'gray5': '#0D0D0D',
'GRAY5': '#0D0D0D',
'gray6': '#0F0F0F',
'GRAY6': '#0F0F0F',
'gray7': '#121212',
'GRAY7': '#121212',
'gray8': '#141414',
'GRAY8': '#141414',
'gray9': '#171717',
'GRAY9': '#171717',
'gray10': '#1A1A1A',
'GRAY10': '#1A1A1A',
'gray11': '#1C1C1C',
'GRAY11': '#1C1C1C',
'gray12': '#1F1F1F',
'GRAY12': '#1F1F1F',
'gray13': '#212121',
'GRAY13': '#212121',
'gray14': '#242424',
'GRAY14': '#242424',
'gray15': '#262626',
'GRAY15': '#262626',
'gray16': '#292929',
'GRAY16': '#292929',
'gray17': '#2B2B2B',
'GRAY17': '#2B2B2B',
'gray18': '#2E2E2E',
'GRAY18': '#2E2E2E',
'gray19': '#303030',
'GRAY19': '#303030',
'gray20': '#333333',
'GRAY20': '#333333',
'gray21': '#363636',
'GRAY21': '#363636',
'gray22': '#383838',
'GRAY22': '#383838',
'gray23': '#3B3B3B',
'GRAY23': '#3B3B3B',
'gray24': '#3D3D3D',
'GRAY24': '#3D3D3D',
'gray25': '#404040',
'GRAY25': '#404040',
'gray26': '#424242',
'GRAY26': '#424242',
'gray27': '#454545',
'GRAY27': '#454545',
'gray28': '#474747',
'GRAY28': '#474747',
'gray29': '#4A4A4A',
'GRAY29': '#4A4A4A',
'gray30': '#4D4D4D',
'GRAY30': '#4D4D4D',
'gray31': '#4F4F4F',
'GRAY31': '#4F4F4F',
'gray32': '#525252',
'GRAY32': '#525252',
'gray33': '#545454',
'GRAY33': '#545454',
'gray34': '#575757',
'GRAY34': '#575757',
'gray35': '#595959',
'GRAY35': '#595959',
'gray36': '#5C5C5C',
'GRAY36': '#5C5C5C',
'gray37': '#5E5E5E',
'GRAY37': '#5E5E5E',
'gray38': '#616161',
'GRAY38': '#616161',
'gray39': '#636363',
'GRAY39': '#636363',
'gray40': '#666666',
'GRAY40': '#666666',
'gray41': '#696969',
'GRAY41': '#696969',
'gray42': '#6B6B6B',
'GRAY42': '#6B6B6B',
'gray43': '#707070',
'GRAY43': '#707070',
'gray44': '#707070',
'GRAY44': '#707070',
'gray45': '#707070',
'GRAY45': '#707070',
'gray46': '#757575',
'GRAY46': '#757575',
'gray47': '#787878',
'GRAY47': '#787878',
'gray48': '#7A7A7A',
'GRAY48': '#7A7A7A',
'gray49': '#707070',
'GRAY49': '#707070',
'gray50': '#7F7F7F',
'GRAY50': '#7F7F7F',
'gray51': '#828282',
'GRAY51': '#828282',
'gray52': '#858585',
'GRAY52': '#858585',
'gray53': '#878787',
'GRAY53': '#878787',
'gray54': '#8A8A8A',
'GRAY54': '#8A8A8A',
'gray55': '#8C8C8C',
'GRAY55': '#8C8C8C',
'gray56': '#8F8F8F',
'GRAY56': '#8F8F8F',
'gray57': '#919191',
'GRAY57': '#919191',
'gray58': '#949494',
'GRAY58': '#949494',
'gray59': '#969696',
'GRAY59': '#969696',
'gray60': '#999999',
'GRAY60': '#999999',
'gray61': '#9C9C9C',
'GRAY61': '#9C9C9C',
'gray62': '#9E9E9E',
'GRAY62': '#9E9E9E',
'gray63': '#A1A1A1',
'GRAY63': '#A1A1A1',
'gray64': '#A3A3A3',
'GRAY64': '#A3A3A3',
'gray65': '#A6A6A6',
'GRAY65': '#A6A6A6',
'gray66': '#A8A8A8',
'GRAY66': '#A8A8A8',
'gray67': '#ABABAB',
'GRAY67': '#ABABAB',
'gray68': '#ADADAD',
'GRAY68': '#ADADAD',
'gray69': '#B0B0B0',
'GRAY69': '#B0B0B0',
'gray70': '#B3B3B3',
'GRAY70': '#B3B3B3',
'gray71': '#B5B5B5',
'GRAY71': '#B5B5B5',
'gray72': '#B8B8B8',
'GRAY72': '#B8B8B8',
'gray73': '#BABABA',
'GRAY73': '#BABABA',
'gray74': '#BDBDBD',
'GRAY74': '#BDBDBD',
'gray75': '#BFBFBF',
'GRAY75': '#BFBFBF',
'gray76': '#C2C2C2',
'GRAY76': '#C2C2C2',
'gray77': '#C4C4C4',
'GRAY77': '#C4C4C4',
'gray78': '#C7C7C7',
'GRAY78': '#C7C7C7',
'gray79': '#C9C9C9',
'GRAY79': '#C9C9C9',
'gray80': '#CCCCCC',
'GRAY80': '#CCCCCC',
'gray81': '#CFCFCF',
'GRAY81': '#CFCFCF',
'gray82': '#D1D1D1',
'GRAY82': '#D1D1D1',
'gray83': '#D4D4D4',
'GRAY83': '#D4D4D4',
'gray84': '#D6D6D6',
'GRAY84': '#D6D6D6',
'gray85': '#D9D9D9',
'GRAY85': '#D9D9D9',
'gray86': '#DBDBDB',
'GRAY86': '#DBDBDB',
'gray87': '#DEDEDE',
'GRAY87': '#DEDEDE',
'gray88': '#E0E0E0',
'GRAY88': '#E0E0E0',
'gray89': '#E3E3E3',
'GRAY89': '#E3E3E3',
'gray90': '#E5E5E5',
'GRAY90': '#E5E5E5',
'gray91': '#E8E8E8',
'GRAY91': '#E8E8E8',
'gray92': '#EBEBEB',
'GRAY92': '#EBEBEB',
'gray93': '#EDEDED',
'GRAY93': '#EDEDED',
'gray94': '#F0F0F0',
'GRAY94': '#F0F0F0',
'gray95': '#F2F2F2',
'GRAY95': '#F2F2F2',
'gray96': '#F5F5F5',
'GRAY96': '#F5F5F5',
'gray97': '#F7F7F7',
'GRAY97': '#F7F7F7',
'gray98': '#FAFAFA',
'GRAY98': '#FAFAFA',
'gray99': '#FCFCFC',
'GRAY99': '#FCFCFC',
'gray100': '#FFFFFF',
'GRAY100': '#FFFFFF',
'green': '#00FF00',
'GREEN': '#00FF00',
'green yellow': '#ADFF2F',
'GREEN YELLOW': '#ADFF2F',
'green1': '#00FF00',
'GREEN1': '#00FF00',
'green2': '#00EE00',
'GREEN2': '#00EE00',
'green3': '#00CD00',
'GREEN3': '#00CD00',
'green4': '#008B00',
'GREEN4': '#008B00',
'GreenYellow': '#ADFF2F',
'greenyellow': '#ADFF2F',
'GREENYELLOW': '#ADFF2F',
'grey': '#BEBEBE',
'GREY': '#BEBEBE',
'grey0': '#000000',
'GREY0': '#000000',
'grey1': '#030303',
'GREY1': '#030303',
'grey2': '#050505',
'GREY2': '#050505',
'grey3': '#080808',
'GREY3': '#080808',
'grey4': '#0A0A0A',
'GREY4': '#0A0A0A',
'grey5': '#0D0D0D',
'GREY5': '#0D0D0D',
'grey6': '#0F0F0F',
'GREY6': '#0F0F0F',
'grey7': '#121212',
'GREY7': '#121212',
'grey8': '#141414',
'GREY8': '#141414',
'grey9': '#171717',
'GREY9': '#171717',
'grey10': '#1A1A1A',
'GREY10': '#1A1A1A',
'grey11': '#1C1C1C',
'GREY11': '#1C1C1C',
'grey12': '#1F1F1F',
'GREY12': '#1F1F1F',
'grey13': '#212121',
'GREY13': '#212121',
'grey14': '#242424',
'GREY14': '#242424',
'grey15': '#262626',
'GREY15': '#262626',
'grey16': '#292929',
'GREY16': '#292929',
'grey17': '#2B2B2B',
'GREY17': '#2B2B2B',
'grey18': '#2E2E2E',
'GREY18': '#2E2E2E',
'grey19': '#303030',
'GREY19': '#303030',
'grey20': '#333333',
'GREY20': '#333333',
'grey21': '#363636',
'GREY21': '#363636',
'grey22': '#383838',
'GREY22': '#383838',
'grey23': '#3B3B3B',
'GREY23': '#3B3B3B',
'grey24': '#3D3D3D',
'GREY24': '#3D3D3D',
'grey25': '#404040',
'GREY25': '#404040',
'grey26': '#424242',
'GREY26': '#424242',
'grey27': '#454545',
'GREY27': '#454545',
'grey28': '#474747',
'GREY28': '#474747',
'grey29': '#4A4A4A',
'GREY29': '#4A4A4A',
'grey30': '#4D4D4D',
'GREY30': '#4D4D4D',
'grey31': '#4F4F4F',
'GREY31': '#4F4F4F',
'grey32': '#525252',
'GREY32': '#525252',
'grey33': '#545454',
'GREY33': '#545454',
'grey34': '#575757',
'GREY34': '#575757',
'grey35': '#595959',
'GREY35': '#595959',
'grey36': '#5C5C5C',
'GREY36': '#5C5C5C',
'grey37': '#5E5E5E',
'GREY37': '#5E5E5E',
'grey38': '#616161',
'GREY38': '#616161',
'grey39': '#636363',
'GREY39': '#636363',
'grey40': '#666666',
'GREY40': '#666666',
'grey41': '#696969',
'GREY41': '#696969',
'grey42': '#6B6B6B',
'GREY42': '#6B6B6B',
'grey43': '#707070',
'GREY43': '#707070',
'grey44': '#707070',
'GREY44': '#707070',
'grey45': '#707070',
'GREY45': '#707070',
'grey46': '#757575',
'GREY46': '#757575',
'grey47': '#787878',
'GREY47': '#787878',
'grey48': '#7A7A7A',
'GREY48': '#7A7A7A',
'grey49': '#707070',
'GREY49': '#707070',
'grey50': '#7F7F7F',
'GREY50': '#7F7F7F',
'grey51': '#828282',
'GREY51': '#828282',
'grey52': '#858585',
'GREY52': '#858585',
'grey53': '#878787',
'GREY53': '#878787',
'grey54': '#8A8A8A',
'GREY54': '#8A8A8A',
'grey55': '#8C8C8C',
'GREY55': '#8C8C8C',
'grey56': '#8F8F8F',
'GREY56': '#8F8F8F',
'grey57': '#919191',
'GREY57': '#919191',
'grey58': '#949494',
'GREY58': '#949494',
'grey59': '#969696',
'GREY59': '#969696',
'grey60': '#999999',
'GREY60': '#999999',
'grey61': '#9C9C9C',
'GREY61': '#9C9C9C',
'grey62': '#9E9E9E',
'GREY62': '#9E9E9E',
'grey63': '#A1A1A1',
'GREY63': '#A1A1A1',
'grey64': '#A3A3A3',
'GREY64': '#A3A3A3',
'grey65': '#A6A6A6',
'GREY65': '#A6A6A6',
'grey66': '#A8A8A8',
'GREY66': '#A8A8A8',
'grey67': '#ABABAB',
'GREY67': '#ABABAB',
'grey68': '#ADADAD',
'GREY68': '#ADADAD',
'grey69': '#B0B0B0',
'GREY69': '#B0B0B0',
'grey70': '#B3B3B3',
'GREY70': '#B3B3B3',
'grey71': '#B5B5B5',
'GREY71': '#B5B5B5',
'grey72': '#B8B8B8',
'GREY72': '#B8B8B8',
'grey73': '#BABABA',
'GREY73': '#BABABA',
'grey74': '#BDBDBD',
'GREY74': '#BDBDBD',
'grey75': '#BFBFBF',
'GREY75': '#BFBFBF',
'grey76': '#C2C2C2',
'GREY76': '#C2C2C2',
'grey77': '#C4C4C4',
'GREY77': '#C4C4C4',
'grey78': '#C7C7C7',
'GREY78': '#C7C7C7',
'grey79': '#C9C9C9',
'GREY79': '#C9C9C9',
'grey80': '#CCCCCC',
'GREY80': '#CCCCCC',
'grey81': '#CFCFCF',
'GREY81': '#CFCFCF',
'grey82': '#D1D1D1',
'GREY82': '#D1D1D1',
'grey83': '#D4D4D4',
'GREY83': '#D4D4D4',
'grey84': '#D6D6D6',
'GREY84': '#D6D6D6',
'grey85': '#D9D9D9',
'GREY85': '#D9D9D9',
'grey86': '#DBDBDB',
'GREY86': '#DBDBDB',
'grey87': '#DEDEDE',
'GREY87': '#DEDEDE',
'grey88': '#E0E0E0',
'GREY88': '#E0E0E0',
'grey89': '#E3E3E3',
'GREY89': '#E3E3E3',
'grey90': '#E5E5E5',
'GREY90': '#E5E5E5',
'grey91': '#E8E8E8',
'GREY91': '#E8E8E8',
'grey92': '#EBEBEB',
'GREY92': '#EBEBEB',
'grey93': '#EDEDED',
'GREY93': '#EDEDED',
'grey94': '#F0F0F0',
'GREY94': '#F0F0F0',
'grey95': '#F2F2F2',
'GREY95': '#F2F2F2',
'grey96': '#F5F5F5',
'GREY96': '#F5F5F5',
'grey97': '#F7F7F7',
'GREY97': '#F7F7F7',
'grey98': '#FAFAFA',
'GREY98': '#FAFAFA',
'grey99': '#FCFCFC',
'GREY99': '#FCFCFC',
'grey100': '#FFFFFF',
'GREY100': '#FFFFFF',
'honeydew': '#F0FFF0',
'HONEYDEW': '#F0FFF0',
'honeydew1': '#F0FFF0',
'HONEYDEW1': '#F0FFF0',
'honeydew2': '#E0EEE0',
'HONEYDEW2': '#E0EEE0',
'honeydew3': '#C1CDC1',
'HONEYDEW3': '#C1CDC1',
'honeydew4': '#838B83',
'HONEYDEW4': '#838B83',
'hot pink': '#FF69B4',
'HOT PINK': '#FF69B4',
'HotPink': '#FF69B4',
'hotpink': '#FF69B4',
'HOTPINK': '#FF69B4',
'HotPink1': '#FF6EB4',
'hotpink1': '#FF6EB4',
'HOTPINK1': '#FF6EB4',
'HotPink2': '#EE6AA7',
'hotpink2': '#EE6AA7',
'HOTPINK2': '#EE6AA7',
'HotPink3': '#CD6090',
'hotpink3': '#CD6090',
'HOTPINK3': '#CD6090',
'HotPink4': '#8B3A62',
'hotpink4': '#8B3A62',
'HOTPINK4': '#8B3A62',
'indigo': '#4b0082',
'INDIGO': '#4b0082',
'indian red': '#CD5C5C',
'INDIAN RED': '#CD5C5C',
'IndianRed': '#CD5C5C',
'indianred': '#CD5C5C',
'INDIANRED': '#CD5C5C',
'IndianRed1': '#FF6A6A',
'indianred1': '#FF6A6A',
'INDIANRED1': '#FF6A6A',
'IndianRed2': '#EE6363',
'indianred2': '#EE6363',
'INDIANRED2': '#EE6363',
'IndianRed3': '#CD5555',
'indianred3': '#CD5555',
'INDIANRED3': '#CD5555',
'IndianRed4': '#8B3A3A',
'indianred4': '#8B3A3A',
'INDIANRED4': '#8B3A3A',
'ivory': '#FFFFF0',
'IVORY': '#FFFFF0',
'ivory1': '#FFFFF0',
'IVORY1': '#FFFFF0',
'ivory2': '#EEEEE0',
'IVORY2': '#EEEEE0',
'ivory3': '#CDCDC1',
'IVORY3': '#CDCDC1',
'ivory4': '#8B8B83',
'IVORY4': '#8B8B83',
'khaki': '#F0E68C',
'KHAKI': '#F0E68C',
'khaki1': '#FFF68F',
'KHAKI1': '#FFF68F',
'khaki2': '#EEE685',
'KHAKI2': '#EEE685',
'khaki3': '#CDC673',
'KHAKI3': '#CDC673',
'khaki4': '#8B864E',
'KHAKI4': '#8B864E',
'lavender': '#E6E6FA',
'LAVENDER': '#E6E6FA',
'lavender blush': '#FFF0F5',
'LAVENDER BLUSH': '#FFF0F5',
'LavenderBlush': '#FFF0F5',
'lavenderblush': '#FFF0F5',
'LAVENDERBLUSH': '#FFF0F5',
'LavenderBlush1': '#FFF0F5',
'lavenderblush1': '#FFF0F5',
'LAVENDERBLUSH1': '#FFF0F5',
'LavenderBlush2': '#EEE0E5',
'lavenderblush2': '#EEE0E5',
'LAVENDERBLUSH2': '#EEE0E5',
'LavenderBlush3': '#CDC1C5',
'lavenderblush3': '#CDC1C5',
'LAVENDERBLUSH3': '#CDC1C5',
'LavenderBlush4': '#8B8386',
'lavenderblush4': '#8B8386',
'LAVENDERBLUSH4': '#8B8386',
'lawn green': '#7CFC00',
'LAWN GREEN': '#7CFC00',
'LawnGreen': '#7CFC00',
'lawngreen': '#7CFC00',
'LAWNGREEN': '#7CFC00',
'lemon chiffon': '#FFFACD',
'LEMON CHIFFON': '#FFFACD',
'LemonChiffon': '#FFFACD',
'lemonchiffon': '#FFFACD',
'LEMONCHIFFON': '#FFFACD',
'LemonChiffon1': '#FFFACD',
'lemonchiffon1': '#FFFACD',
'LEMONCHIFFON1': '#FFFACD',
'LemonChiffon2': '#EEE9BF',
'lemonchiffon2': '#EEE9BF',
'LEMONCHIFFON2': '#EEE9BF',
'LemonChiffon3': '#CDC9A5',
'lemonchiffon3': '#CDC9A5',
'LEMONCHIFFON3': '#CDC9A5',
'LemonChiffon4': '#8B8970',
'lemonchiffon4': '#8B8970',
'LEMONCHIFFON4': '#8B8970',
'light blue': '#ADD8E6',
'LIGHT BLUE': '#ADD8E6',
'light coral': '#F08080',
'LIGHT CORAL': '#F08080',
'light cyan': '#E0FFFF',
'LIGHT CYAN': '#E0FFFF',
'light goldenrod': '#EEDD82',
'LIGHT GOLDENROD': '#EEDD82',
'light goldenrod yellow': '#FAFAD2',
'LIGHT GOLDENROD YELLOW': '#FAFAD2',
'light gray': '#D3D3D3',
'LIGHT GRAY': '#D3D3D3',
'light green': '#90EE90',
'LIGHT GREEN': '#90EE90',
'light grey': '#D3D3D3',
'LIGHT GREY': '#D3D3D3',
'light pink': '#FFB6C1',
'LIGHT PINK': '#FFB6C1',
'light salmon': '#FFA07A',
'LIGHT SALMON': '#FFA07A',
'light sea green': '#20B2AA',
'LIGHT SEA GREEN': '#20B2AA',
'light sky blue': '#87CEFA',
'LIGHT SKY BLUE': '#87CEFA',
'light slate blue': '#8470FF',
'LIGHT SLATE BLUE': '#8470FF',
'light slate gray': '#778899',
'LIGHT SLATE GRAY': '#778899',
'light slate grey': '#778899',
'LIGHT SLATE GREY': '#778899',
'light steel blue': '#B0C4DE',
'LIGHT STEEL BLUE': '#B0C4DE',
'light yellow': '#FFFFE0',
'LIGHT YELLOW': '#FFFFE0',
'LightBlue': '#ADD8E6',
'lightblue': '#ADD8E6',
'LIGHTBLUE': '#ADD8E6',
'LightBlue1': '#BFEFFF',
'lightblue1': '#BFEFFF',
'LIGHTBLUE1': '#BFEFFF',
'LightBlue2': '#B2DFEE',
'lightblue2': '#B2DFEE',
'LIGHTBLUE2': '#B2DFEE',
'LightBlue3': '#9AC0CD',
'lightblue3': '#9AC0CD',
'LIGHTBLUE3': '#9AC0CD',
'LightBlue4': '#68838B',
'lightblue4': '#68838B',
'LIGHTBLUE4': '#68838B',
'LightCoral': '#F08080',
'lightcoral': '#F08080',
'LIGHTCORAL': '#F08080',
'LightCyan': '#E0FFFF',
'lightcyan': '#E0FFFF',
'LIGHTCYAN': '#E0FFFF',
'LightCyan1': '#E0FFFF',
'lightcyan1': '#E0FFFF',
'LIGHTCYAN1': '#E0FFFF',
'LightCyan2': '#D1EEEE',
'lightcyan2': '#D1EEEE',
'LIGHTCYAN2': '#D1EEEE',
'LightCyan3': '#B4CDCD',
'lightcyan3': '#B4CDCD',
'LIGHTCYAN3': '#B4CDCD',
'LightCyan4': '#7A8B8B',
'lightcyan4': '#7A8B8B',
'LIGHTCYAN4': '#7A8B8B',
'LightGoldenrod': '#EEDD82',
'lightgoldenrod': '#EEDD82',
'LIGHTGOLDENROD': '#EEDD82',
'LightGoldenrod1': '#FFEC8B',
'lightgoldenrod1': '#FFEC8B',
'LIGHTGOLDENROD1': '#FFEC8B',
'LightGoldenrod2': '#EEDC82',
'lightgoldenrod2': '#EEDC82',
'LIGHTGOLDENROD2': '#EEDC82',
'LightGoldenrod3': '#CDBE70',
'lightgoldenrod3': '#CDBE70',
'LIGHTGOLDENROD3': '#CDBE70',
'LightGoldenrod4': '#8B814C',
'lightgoldenrod4': '#8B814C',
'LIGHTGOLDENROD4': '#8B814C',
'LightGoldenrodYellow': '#FAFAD2',
'lightgoldenrodyellow': '#FAFAD2',
'LIGHTGOLDENRODYELLOW': '#FAFAD2',
'LightGray': '#D3D3D3',
'lightgray': '#D3D3D3',
'LIGHTGRAY': '#D3D3D3',
'LightGreen': '#90EE90',
'lightgreen': '#90EE90',
'LIGHTGREEN': '#90EE90',
'LightGrey': '#D3D3D3',
'lightgrey': '#D3D3D3',
'LIGHTGREY': '#D3D3D3',
'LightPink': '#FFB6C1',
'lightpink': '#FFB6C1',
'LIGHTPINK': '#FFB6C1',
'LightPink1': '#FFAEB9',
'lightpink1': '#FFAEB9',
'LIGHTPINK1': '#FFAEB9',
'LightPink2': '#EEA2AD',
'lightpink2': '#EEA2AD',
'LIGHTPINK2': '#EEA2AD',
'LightPink3': '#CD8C95',
'lightpink3': '#CD8C95',
'LIGHTPINK3': '#CD8C95',
'LightPink4': '#8B5F65',
'lightpink4': '#8B5F65',
'LIGHTPINK4': '#8B5F65',
'LightSalmon': '#FFA07A',
'lightsalmon': '#FFA07A',
'LIGHTSALMON': '#FFA07A',
'LightSalmon1': '#FFA07A',
'lightsalmon1': '#FFA07A',
'LIGHTSALMON1': '#FFA07A',
'LightSalmon2': '#EE9572',
'lightsalmon2': '#EE9572',
'LIGHTSALMON2': '#EE9572',
'LightSalmon3': '#CD8162',
'lightsalmon3': '#CD8162',
'LIGHTSALMON3': '#CD8162',
'LightSalmon4': '#8B5742',
'lightsalmon4': '#8B5742',
'LIGHTSALMON4': '#8B5742',
'LightSeaGreen': '#20B2AA',
'lightseagreen': '#20B2AA',
'LIGHTSEAGREEN': '#20B2AA',
'LightSkyBlue': '#87CEFA',
'lightskyblue': '#87CEFA',
'LIGHTSKYBLUE': '#87CEFA',
'LightSkyBlue1': '#B0E2FF',
'lightskyblue1': '#B0E2FF',
'LIGHTSKYBLUE1': '#B0E2FF',
'LightSkyBlue2': '#A4D3EE',
'lightskyblue2': '#A4D3EE',
'LIGHTSKYBLUE2': '#A4D3EE',
'LightSkyBlue3': '#8DB6CD',
'lightskyblue3': '#8DB6CD',
'LIGHTSKYBLUE3': '#8DB6CD',
'LightSkyBlue4': '#607B8B',
'lightskyblue4': '#607B8B',
'LIGHTSKYBLUE4': '#607B8B',
'LightSlateBlue': '#8470FF',
'lightslateblue': '#8470FF',
'LIGHTSLATEBLUE': '#8470FF',
'LightSlateGray': '#778899',
'lightslategray': '#778899',
'LIGHTSLATEGRAY': '#778899',
'LightSlateGrey': '#778899',
'lightslategrey': '#778899',
'LIGHTSLATEGREY': '#778899',
'LightSteelBlue': '#B0C4DE',
'lightsteelblue': '#B0C4DE',
'LIGHTSTEELBLUE': '#B0C4DE',
'LightSteelBlue1': '#CAE1FF',
'lightsteelblue1': '#CAE1FF',
'LIGHTSTEELBLUE1': '#CAE1FF',
'LightSteelBlue2': '#BCD2EE',
'lightsteelblue2': '#BCD2EE',
'LIGHTSTEELBLUE2': '#BCD2EE',
'LightSteelBlue3': '#A2B5CD',
'lightsteelblue3': '#A2B5CD',
'LIGHTSTEELBLUE3': '#A2B5CD',
'LightSteelBlue4': '#6E7B8B',
'lightsteelblue4': '#6E7B8B',
'LIGHTSTEELBLUE4': '#6E7B8B',
'LightYellow': '#FFFFE0',
'lightyellow': '#FFFFE0',
'LIGHTYELLOW': '#FFFFE0',
'LightYellow1': '#FFFFE0',
'lightyellow1': '#FFFFE0',
'LIGHTYELLOW1': '#FFFFE0',
'LightYellow2': '#EEEED1',
'lightyellow2': '#EEEED1',
'LIGHTYELLOW2': '#EEEED1',
'LightYellow3': '#CDCDB4',
'lightyellow3': '#CDCDB4',
'LIGHTYELLOW3': '#CDCDB4',
'LightYellow4': '#8B8B7A',
'lightyellow4': '#8B8B7A',
'LIGHTYELLOW4': '#8B8B7A',
'lime green': '#32CD32',
'LIME GREEN': '#32CD32',
'LimeGreen': '#32CD32',
'limegreen': '#32CD32',
'LIMEGREEN': '#32CD32',
'linen': '#FAF0E6',
'LINEN': '#FAF0E6',
'magenta': '#FF00FF',
'MAGENTA': '#FF00FF',
'magenta1': '#FF00FF',
'MAGENTA1': '#FF00FF',
'magenta2': '#EE00EE',
'MAGENTA2': '#EE00EE',
'magenta3': '#CD00CD',
'MAGENTA3': '#CD00CD',
'magenta4': '#8B008B',
'MAGENTA4': '#8B008B',
'maroon': '#B03060',
'MAROON': '#B03060',
'maroon1': '#FF34B3',
'MAROON1': '#FF34B3',
'maroon2': '#EE30A7',
'MAROON2': '#EE30A7',
'maroon3': '#CD2990',
'MAROON3': '#CD2990',
'maroon4': '#8B1C62',
'MAROON4': '#8B1C62',
'medium aquamarine': '#66CDAA',
'MEDIUM AQUAMARINE': '#66CDAA',
'medium blue': '#0000CD',
'MEDIUM BLUE': '#0000CD',
'medium orchid': '#BA55D3',
'MEDIUM ORCHID': '#BA55D3',
'medium purple': '#9370DB',
'MEDIUM PURPLE': '#9370DB',
'medium sea green': '#3CB371',
'MEDIUM SEA GREEN': '#3CB371',
'medium slate blue': '#7B68EE',
'MEDIUM SLATE BLUE': '#7B68EE',
'medium spring green': '#00FA9A',
'MEDIUM SPRING GREEN': '#00FA9A',
'medium turquoise': '#48D1CC',
'MEDIUM TURQUOISE': '#48D1CC',
'medium violet red': '#C71585',
'MEDIUM VIOLET RED': '#C71585',
'MediumAquamarine': '#66CDAA',
'mediumaquamarine': '#66CDAA',
'MEDIUMAQUAMARINE': '#66CDAA',
'MediumBlue': '#0000CD',
'mediumblue': '#0000CD',
'MEDIUMBLUE': '#0000CD',
'MediumOrchid': '#BA55D3',
'mediumorchid': '#BA55D3',
'MEDIUMORCHID': '#BA55D3',
'MediumOrchid1': '#E066FF',
'mediumorchid1': '#E066FF',
'MEDIUMORCHID1': '#E066FF',
'MediumOrchid2': '#D15FEE',
'mediumorchid2': '#D15FEE',
'MEDIUMORCHID2': '#D15FEE',
'MediumOrchid3': '#B452CD',
'mediumorchid3': '#B452CD',
'MEDIUMORCHID3': '#B452CD',
'MediumOrchid4': '#7A378B',
'mediumorchid4': '#7A378B',
'MEDIUMORCHID4': '#7A378B',
'MediumPurple': '#9370DB',
'mediumpurple': '#9370DB',
'MEDIUMPURPLE': '#9370DB',
'MediumPurple1': '#AB82FF',
'mediumpurple1': '#AB82FF',
'MEDIUMPURPLE1': '#AB82FF',
'MediumPurple2': '#9F79EE',
'mediumpurple2': '#9F79EE',
'MEDIUMPURPLE2': '#9F79EE',
'MediumPurple3': '#8968CD',
'mediumpurple3': '#8968CD',
'MEDIUMPURPLE3': '#8968CD',
'MediumPurple4': '#5D478B',
'mediumpurple4': '#5D478B',
'MEDIUMPURPLE4': '#5D478B',
'MediumSeaGreen': '#3CB371',
'mediumseagreen': '#3CB371',
'MEDIUMSEAGREEN': '#3CB371',
'MediumSlateBlue': '#7B68EE',
'mediumslateblue': '#7B68EE',
'MEDIUMSLATEBLUE': '#7B68EE',
'MediumSpringGreen': '#00FA9A',
'mediumspringgreen': '#00FA9A',
'MEDIUMSPRINGGREEN': '#00FA9A',
'MediumTurquoise': '#48D1CC',
'mediumturquoise': '#48D1CC',
'MEDIUMTURQUOISE': '#48D1CC',
'MediumVioletRed': '#C71585',
'mediumvioletred': '#C71585',
'MEDIUMVIOLETRED': '#C71585',
'midnight blue': '#191970',
'MIDNIGHT BLUE': '#191970',
'MidnightBlue': '#191970',
'midnightblue': '#191970',
'MIDNIGHTBLUE': '#191970',
'mint cream': '#F5FFFA',
'MINT CREAM': '#F5FFFA',
'MintCream': '#F5FFFA',
'mintcream': '#F5FFFA',
'MINTCREAM': '#F5FFFA',
'misty rose': '#FFE4E1',
'MISTY ROSE': '#FFE4E1',
'MistyRose': '#FFE4E1',
'mistyrose': '#FFE4E1',
'MISTYROSE': '#FFE4E1',
'MistyRose1': '#FFE4E1',
'mistyrose1': '#FFE4E1',
'MISTYROSE1': '#FFE4E1',
'MistyRose2': '#EED5D2',
'mistyrose2': '#EED5D2',
'MISTYROSE2': '#EED5D2',
'MistyRose3': '#CDB7B5',
'mistyrose3': '#CDB7B5',
'MISTYROSE3': '#CDB7B5',
'MistyRose4': '#8B7D7B',
'mistyrose4': '#8B7D7B',
'MISTYROSE4': '#8B7D7B',
'moccasin': '#FFE4B5',
'MOCCASIN': '#FFE4B5',
'navajo white': '#FFDEAD',
'NAVAJO WHITE': '#FFDEAD',
'NavajoWhite': '#FFDEAD',
'navajowhite': '#FFDEAD',
'NAVAJOWHITE': '#FFDEAD',
'NavajoWhite1': '#FFDEAD',
'navajowhite1': '#FFDEAD',
'NAVAJOWHITE1': '#FFDEAD',
'NavajoWhite2': '#EECFA1',
'navajowhite2': '#EECFA1',
'NAVAJOWHITE2': '#EECFA1',
'NavajoWhite3': '#CDB38B',
'navajowhite3': '#CDB38B',
'NAVAJOWHITE3': '#CDB38B',
'NavajoWhite4': '#8B795E',
'navajowhite4': '#8B795E',
'NAVAJOWHITE4': '#8B795E',
'navy': '#000080',
'NAVY': '#000080',
'navy blue': '#000080',
'NAVY BLUE': '#000080',
'NavyBlue': '#000080',
'navyblue': '#000080',
'NAVYBLUE': '#000080',
'old lace': '#FDF5E6',
'OLD LACE': '#FDF5E6',
'OldLace': '#FDF5E6',
'oldlace': '#FDF5E6',
'OLDLACE': '#FDF5E6',
'olive drab': '#6B8E23',
'OLIVE DRAB': '#6B8E23',
'OliveDrab': '#6B8E23',
'olivedrab': '#6B8E23',
'OLIVEDRAB': '#6B8E23',
'OliveDrab1': '#C0FF3E',
'olivedrab1': '#C0FF3E',
'OLIVEDRAB1': '#C0FF3E',
'OliveDrab2': '#B3EE3A',
'olivedrab2': '#B3EE3A',
'OLIVEDRAB2': '#B3EE3A',
'OliveDrab3': '#9ACD32',
'olivedrab3': '#9ACD32',
'OLIVEDRAB3': '#9ACD32',
'OliveDrab4': '#698B22',
'olivedrab4': '#698B22',
'OLIVEDRAB4': '#698B22',
'orange': '#FFA500',
'ORANGE': '#FFA500',
'orange red': '#FF4500',
'ORANGE RED': '#FF4500',
'orange1': '#FFA500',
'ORANGE1': '#FFA500',
'orange2': '#EE9A00',
'ORANGE2': '#EE9A00',
'orange3': '#CD8500',
'ORANGE3': '#CD8500',
'orange4': '#8B5A00',
'ORANGE4': '#8B5A00',
'OrangeRed': '#FF4500',
'orangered': '#FF4500',
'ORANGERED': '#FF4500',
'OrangeRed1': '#FF4500',
'orangered1': '#FF4500',
'ORANGERED1': '#FF4500',
'OrangeRed2': '#EE4000',
'orangered2': '#EE4000',
'ORANGERED2': '#EE4000',
'OrangeRed3': '#CD3700',
'orangered3': '#CD3700',
'ORANGERED3': '#CD3700',
'OrangeRed4': '#8B2500',
'orangered4': '#8B2500',
'ORANGERED4': '#8B2500',
'orchid': '#DA70D6',
'ORCHID': '#DA70D6',
'orchid1': '#FF83FA',
'ORCHID1': '#FF83FA',
'orchid2': '#EE7AE9',
'ORCHID2': '#EE7AE9',
'orchid3': '#CD69C9',
'ORCHID3': '#CD69C9',
'orchid4': '#8B4789',
'ORCHID4': '#8B4789',
'pale goldenrod': '#EEE8AA',
'PALE GOLDENROD': '#EEE8AA',
'pale green': '#98FB98',
'PALE GREEN': '#98FB98',
'pale turquoise': '#AFEEEE',
'PALE TURQUOISE': '#AFEEEE',
'pale violet red': '#DB7093',
'PALE VIOLET RED': '#DB7093',
'PaleGoldenrod': '#EEE8AA',
'palegoldenrod': '#EEE8AA',
'PALEGOLDENROD': '#EEE8AA',
'PaleGreen': '#98FB98',
'palegreen': '#98FB98',
'PALEGREEN': '#98FB98',
'PaleGreen1': '#9AFF9A',
'palegreen1': '#9AFF9A',
'PALEGREEN1': '#9AFF9A',
'PaleGreen2': '#90EE90',
'palegreen2': '#90EE90',
'PALEGREEN2': '#90EE90',
'PaleGreen3': '#7CCD7C',
'palegreen3': '#7CCD7C',
'PALEGREEN3': '#7CCD7C',
'PaleGreen4': '#548B54',
'palegreen4': '#548B54',
'PALEGREEN4': '#548B54',
'PaleTurquoise': '#AFEEEE',
'paleturquoise': '#AFEEEE',
'PALETURQUOISE': '#AFEEEE',
'PaleTurquoise1': '#BBFFFF',
'paleturquoise1': '#BBFFFF',
'PALETURQUOISE1': '#BBFFFF',
'PaleTurquoise2': '#AEEEEE',
'paleturquoise2': '#AEEEEE',
'PALETURQUOISE2': '#AEEEEE',
'PaleTurquoise3': '#96CDCD',
'paleturquoise3': '#96CDCD',
'PALETURQUOISE3': '#96CDCD',
'PaleTurquoise4': '#668B8B',
'paleturquoise4': '#668B8B',
'PALETURQUOISE4': '#668B8B',
'PaleVioletRed': '#DB7093',
'palevioletred': '#DB7093',
'PALEVIOLETRED': '#DB7093',
'PaleVioletRed1': '#FF82AB',
'palevioletred1': '#FF82AB',
'PALEVIOLETRED1': '#FF82AB',
'PaleVioletRed2': '#EE799F',
'palevioletred2': '#EE799F',
'PALEVIOLETRED2': '#EE799F',
'PaleVioletRed3': '#CD687F',
'palevioletred3': '#CD687F',
'PALEVIOLETRED3': '#CD687F',
'PaleVioletRed4': '#8B475D',
'palevioletred4': '#8B475D',
'PALEVIOLETRED4': '#8B475D',
'papaya whip': '#FFEFD5',
'PAPAYA WHIP': '#FFEFD5',
'PapayaWhip': '#FFEFD5',
'papayawhip': '#FFEFD5',
'PAPAYAWHIP': '#FFEFD5',
'peach puff': '#FFDAB9',
'PEACH PUFF': '#FFDAB9',
'PeachPuff': '#FFDAB9',
'peachpuff': '#FFDAB9',
'PEACHPUFF': '#FFDAB9',
'PeachPuff1': '#FFDAB9',
'peachpuff1': '#FFDAB9',
'PEACHPUFF1': '#FFDAB9',
'PeachPuff2': '#EECBAD',
'peachpuff2': '#EECBAD',
'PEACHPUFF2': '#EECBAD',
'PeachPuff3': '#CDAF95',
'peachpuff3': '#CDAF95',
'PEACHPUFF3': '#CDAF95',
'PeachPuff4': '#8B7765',
'peachpuff4': '#8B7765',
'PEACHPUFF4': '#8B7765',
'peru': '#CD853F',
'PERU': '#CD853F',
'pink': '#FFC0CB',
'PINK': '#FFC0CB',
'pink1': '#FFB5C5',
'PINK1': '#FFB5C5',
'pink2': '#EEA9B8',
'PINK2': '#EEA9B8',
'pink3': '#CD919E',
'PINK3': '#CD919E',
'pink4': '#8B636C',
'PINK4': '#8B636C',
'plum': '#DDA0DD',
'PLUM': '#DDA0DD',
'plum1': '#FFBBFF',
'PLUM1': '#FFBBFF',
'plum2': '#EEAEEE',
'PLUM2': '#EEAEEE',
'plum3': '#CD96CD',
'PLUM3': '#CD96CD',
'plum4': '#8B668B',
'PLUM4': '#8B668B',
'powder blue': '#B0E0E6',
'POWDER BLUE': '#B0E0E6',
'PowderBlue': '#B0E0E6',
'powderblue': '#B0E0E6',
'POWDERBLUE': '#B0E0E6',
'purple': '#A020F0',
'PURPLE': '#A020F0',
'purple1': '#9B30FF',
'PURPLE1': '#9B30FF',
'purple2': '#912CEE',
'PURPLE2': '#912CEE',
'purple3': '#7D26CD',
'PURPLE3': '#7D26CD',
'purple4': '#551A8B',
'PURPLE4': '#551A8B',
'red': '#FF0000',
'RED': '#FF0000',
'red1': '#FF0000',
'RED1': '#FF0000',
'red2': '#EE0000',
'RED2': '#EE0000',
'red3': '#CD0000',
'RED3': '#CD0000',
'red4': '#8B0000',
'RED4': '#8B0000',
'rosy brown': '#BC8F8F',
'ROSY BROWN': '#BC8F8F',
'RosyBrown': '#BC8F8F',
'rosybrown': '#BC8F8F',
'ROSYBROWN': '#BC8F8F',
'RosyBrown1': '#FFC1C1',
'rosybrown1': '#FFC1C1',
'ROSYBROWN1': '#FFC1C1',
'RosyBrown2': '#EEB4B4',
'rosybrown2': '#EEB4B4',
'ROSYBROWN2': '#EEB4B4',
'RosyBrown3': '#CD9B9B',
'rosybrown3': '#CD9B9B',
'ROSYBROWN3': '#CD9B9B',
'RosyBrown4': '#8B6969',
'rosybrown4': '#8B6969',
'ROSYBROWN4': '#8B6969',
'royal blue': '#4169E1',
'ROYAL BLUE': '#4169E1',
'RoyalBlue': '#4169E1',
'royalblue': '#4169E1',
'ROYALBLUE': '#4169E1',
'RoyalBlue1': '#4876FF',
'royalblue1': '#4876FF',
'ROYALBLUE1': '#4876FF',
'RoyalBlue2': '#436EEE',
'royalblue2': '#436EEE',
'ROYALBLUE2': '#436EEE',
'RoyalBlue3': '#3A5FCD',
'royalblue3': '#3A5FCD',
'ROYALBLUE3': '#3A5FCD',
'RoyalBlue4': '#27408B',
'royalblue4': '#27408B',
'ROYALBLUE4': '#27408B',
'saddle brown': '#8B4513',
'SADDLE BROWN': '#8B4513',
'SaddleBrown': '#8B4513',
'saddlebrown': '#8B4513',
'SADDLEBROWN': '#8B4513',
'salmon': '#FA8072',
'SALMON': '#FA8072',
'salmon1': '#FF8C69',
'SALMON1': '#FF8C69',
'salmon2': '#EE8262',
'SALMON2': '#EE8262',
'salmon3': '#CD7054',
'SALMON3': '#CD7054',
'salmon4': '#8B4C39',
'SALMON4': '#8B4C39',
'sandy brown': '#F4A460',
'SANDY BROWN': '#F4A460',
'SandyBrown': '#F4A460',
'sandybrown': '#F4A460',
'SANDYBROWN': '#F4A460',
'sea green': '#2E8B57',
'SEA GREEN': '#2E8B57',
'SeaGreen': '#2E8B57',
'seagreen': '#2E8B57',
'SEAGREEN': '#2E8B57',
'SeaGreen1': '#54FF9F',
'seagreen1': '#54FF9F',
'SEAGREEN1': '#54FF9F',
'SeaGreen2': '#4EEE94',
'seagreen2': '#4EEE94',
'SEAGREEN2': '#4EEE94',
'SeaGreen3': '#43CD80',
'seagreen3': '#43CD80',
'SEAGREEN3': '#43CD80',
'SeaGreen4': '#2E8B57',
'seagreen4': '#2E8B57',
'SEAGREEN4': '#2E8B57',
'seashell': '#FFF5EE',
'SEASHELL': '#FFF5EE',
'seashell1': '#FFF5EE',
'SEASHELL1': '#FFF5EE',
'seashell2': '#EEE5DE',
'SEASHELL2': '#EEE5DE',
'seashell3': '#CDC5BF',
'SEASHELL3': '#CDC5BF',
'seashell4': '#8B8682',
'SEASHELL4': '#8B8682',
'sienna': '#A0522D',
'SIENNA': '#A0522D',
'sienna1': '#FF8247',
'SIENNA1': '#FF8247',
'sienna2': '#EE7942',
'SIENNA2': '#EE7942',
'sienna3': '#CD6839',
'SIENNA3': '#CD6839',
'sienna4': '#8B4726',
'SIENNA4': '#8B4726',
'sky blue': '#87CEEB',
'SKY BLUE': '#87CEEB',
'SkyBlue': '#87CEEB',
'skyblue': '#87CEEB',
'SKYBLUE': '#87CEEB',
'SkyBlue1': '#87CEFF',
'skyblue1': '#87CEFF',
'SKYBLUE1': '#87CEFF',
'SkyBlue2': '#7EC0EE',
'skyblue2': '#7EC0EE',
'SKYBLUE2': '#7EC0EE',
'SkyBlue3': '#6CA6CD',
'skyblue3': '#6CA6CD',
'SKYBLUE3': '#6CA6CD',
'SkyBlue4': '#4A708B',
'skyblue4': '#4A708B',
'SKYBLUE4': '#4A708B',
'slate blue': '#6A5ACD',
'SLATE BLUE': '#6A5ACD',
'slate gray': '#708090',
'SLATE GRAY': '#708090',
'slate grey': '#708090',
'SLATE GREY': '#708090',
'SlateBlue': '#6A5ACD',
'slateblue': '#6A5ACD',
'SLATEBLUE': '#6A5ACD',
'SlateBlue1': '#836FFF',
'slateblue1': '#836FFF',
'SLATEBLUE1': '#836FFF',
'SlateBlue2': '#7A67EE',
'slateblue2': '#7A67EE',
'SLATEBLUE2': '#7A67EE',
'SlateBlue3': '#6959CD',
'slateblue3': '#6959CD',
'SLATEBLUE3': '#6959CD',
'SlateBlue4': '#473C8B',
'slateblue4': '#473C8B',
'SLATEBLUE4': '#473C8B',
'SlateGray': '#708090',
'slategray': '#708090',
'SLATEGRAY': '#708090',
'SlateGray1': '#C6E2FF',
'slategray1': '#C6E2FF',
'SLATEGRAY1': '#C6E2FF',
'SlateGray2': '#B9D3EE',
'slategray2': '#B9D3EE',
'SLATEGRAY2': '#B9D3EE',
'SlateGray3': '#9FB6CD',
'slategray3': '#9FB6CD',
'SLATEGRAY3': '#9FB6CD',
'SlateGray4': '#6C7B8B',
'slategray4': '#6C7B8B',
'SLATEGRAY4': '#6C7B8B',
'SlateGrey': '#708090',
'slategrey': '#708090',
'SLATEGREY': '#708090',
'snow': '#FFFAFA',
'SNOW': '#FFFAFA',
'snow1': '#FFFAFA',
'SNOW1': '#FFFAFA',
'snow2': '#EEE9E9',
'SNOW2': '#EEE9E9',
'snow3': '#CDC9C9',
'SNOW3': '#CDC9C9',
'snow4': '#8B8989',
'SNOW4': '#8B8989',
'spring green': '#00FF7F',
'SPRING GREEN': '#00FF7F',
'SpringGreen': '#00FF7F',
'springgreen': '#00FF7F',
'SPRINGGREEN': '#00FF7F',
'SpringGreen1': '#00FF7F',
'springgreen1': '#00FF7F',
'SPRINGGREEN1': '#00FF7F',
'SpringGreen2': '#00EE76',
'springgreen2': '#00EE76',
'SPRINGGREEN2': '#00EE76',
'SpringGreen3': '#00CD66',
'springgreen3': '#00CD66',
'SPRINGGREEN3': '#00CD66',
'SpringGreen4': '#008B45',
'springgreen4': '#008B45',
'SPRINGGREEN4': '#008B45',
'steel blue': '#4682B4',
'STEEL BLUE': '#4682B4',
'SteelBlue': '#4682B4',
'steelblue': '#4682B4',
'STEELBLUE': '#4682B4',
'SteelBlue1': '#63B8FF',
'steelblue1': '#63B8FF',
'STEELBLUE1': '#63B8FF',
'SteelBlue2': '#5CACEE',
'steelblue2': '#5CACEE',
'STEELBLUE2': '#5CACEE',
'SteelBlue3': '#4F94CD',
'steelblue3': '#4F94CD',
'STEELBLUE3': '#4F94CD',
'SteelBlue4': '#36648B',
'steelblue4': '#36648B',
'STEELBLUE4': '#36648B',
'tan': '#D2B48C',
'TAN': '#D2B48C',
'tan1': '#FFA54F',
'TAN1': '#FFA54F',
'tan2': '#EE9A49',
'TAN2': '#EE9A49',
'tan3': '#CD853F',
'TAN3': '#CD853F',
'tan4': '#8B5A2B',
'TAN4': '#8B5A2B',
'thistle': '#D8BFD8',
'THISTLE': '#D8BFD8',
'thistle1': '#FFE1FF',
'THISTLE1': '#FFE1FF',
'thistle2': '#EED2EE',
'THISTLE2': '#EED2EE',
'thistle3': '#CDB5CD',
'THISTLE3': '#CDB5CD',
'thistle4': '#8B7B8B',
'THISTLE4': '#8B7B8B',
'tomato': '#FF6347',
'TOMATO': '#FF6347',
'tomato1': '#FF6347',
'TOMATO1': '#FF6347',
'tomato2': '#EE5C42',
'TOMATO2': '#EE5C42',
'tomato3': '#CD4F39',
'TOMATO3': '#CD4F39',
'tomato4': '#8B3626',
'TOMATO4': '#8B3626',
'turquoise': '#40E0D0',
'TURQUOISE': '#40E0D0',
'turquoise1': '#00F5FF',
'TURQUOISE1': '#00F5FF',
'turquoise2': '#00E5EE',
'TURQUOISE2': '#00E5EE',
'turquoise3': '#00C5CD',
'TURQUOISE3': '#00C5CD',
'turquoise4': '#00868B',
'TURQUOISE4': '#00868B',
'violet': '#EE82EE',
'VIOLET': '#EE82EE',
'violet red': '#D02090',
'VIOLET RED': '#D02090',
'VioletRed': '#D02090',
'violetred': '#D02090',
'VIOLETRED': '#D02090',
'VioletRed1': '#FF3E96',
'violetred1': '#FF3E96',
'VIOLETRED1': '#FF3E96',
'VioletRed2': '#EE3A8C',
'violetred2': '#EE3A8C',
'VIOLETRED2': '#EE3A8C',
'VioletRed3': '#CD3278',
'violetred3': '#CD3278',
'VIOLETRED3': '#CD3278',
'VioletRed4': '#8B2252',
'violetred4': '#8B2252',
'VIOLETRED4': '#8B2252',
'wheat': '#F5DEB3',
'WHEAT': '#F5DEB3',
'wheat1': '#FFE7BA',
'WHEAT1': '#FFE7BA',
'wheat2': '#EED8AE',
'WHEAT2': '#EED8AE',
'wheat3': '#CDBA96',
'WHEAT3': '#CDBA96',
'wheat4': '#8B7E66',
'WHEAT4': '#8B7E66',
'white': '#FFFFFF',
'WHITE': '#FFFFFF',
'white smoke': '#F5F5F5',
'WHITE SMOKE': '#F5F5F5',
'WhiteSmoke': '#F5F5F5',
'whitesmoke': '#F5F5F5',
'WHITESMOKE': '#F5F5F5',
'yellow': '#FFFF00',
'YELLOW': '#FFFF00',
'yellow green': '#9ACD32',
'YELLOW GREEN': '#9ACD32',
'yellow1': '#FFFF00',
'YELLOW1': '#FFFF00',
'yellow2': '#EEEE00',
'YELLOW2': '#EEEE00',
'yellow3': '#CDCD00',
'YELLOW3': '#CDCD00',
'yellow4': '#8B8B00',
'YELLOW4': '#8B8B00',
'YellowGreen': '#9ACD32',
'yellowgreen': '#9ACD32',
'YELLOWGREEN': '#9ACD32'
}
