#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['dataquality',
 'dataquality.clients',
 'dataquality.core',
 'dataquality.core.integrations',
 'dataquality.loggers',
 'dataquality.schemas',
 'dataquality.utils']

package_data = \
{'': ['*']}

install_requires = \
['jsonlines==2.0.0',
 'pydantic==1.8.2',
 'requests==2.26.0',
 'types-requests==2.25.2',
 'minio==7.1.0',
 'pandas>=0.20.0',
 'gorilla==0.3.0',
 'pyarrow==5.0.0',
 'vaex==4.5.0',
 'diskcache==5.2.1',
 'resource==0.2.1']

extras_require = \
{'dev': ['flake8 >=3.8.4',
         'black >=20.8b1',
         'isort >=5.8.0',
         'autoflake >=1.4',
         'jupyter==1.0.0'],
 'doc': ['mkdocs >=1.1.2,<2.0.0', 'mkdocs-material >=5.4.0,<6.0.0'],
 'test': ['pytest >=5.2',
          'mypy >=0.812',
          'coverage >=5.5',
          'pytest-cov >=2.11.1',
          'scikit-learn == 1.0',
          'pytorch-lightning ==1.4.9',
          'torch ==1.9.1',
          'transformers ==4.11.3']}

setup(name='dataquality',
      version='0.0.3',
      description='dataquality',
      author='Galileo Technologies, Inc',
      author_email='team@rungalileo.io',
      url='https://www.github.com/rungalileo/dataquality',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.7',
     )
