# Author(s): Kristo Mela
# This source code is licensed under the MIT license. See LICENSE in the repository root directory.
# Copyright 2022 Kristo Mela
# -*- coding: utf-8 -*-
"""
Created on Wed Mar 14 22:50:51 2018

Constants for EN 1993

@author: kmela
"""

# Constants: Young's modulus, Shear modulus, density
# Units: N, mm, i.e. MPa =N/mm^2

# Young's modulus Mpa
E = 210.0e3

# Shear modulus Mpa
G = 81.0e3

# Poisson's ratio MPa
NU = 0.3

# Density kg/mm^3
density = 7850.0e-9

# Partial safety factors
gammaM0 = 1.0
gammaM1 = 1.0
gammaM2 = 1.25
gammaM5 = 1.0

# Safety factor for fire
gammaMfi = 1.0
