""" Contains all the data models used in inputs/outputs """

from .ack import Ack
from .aggregation import Aggregation
from .annotate_binary_form import AnnotateBinaryForm
from .annotate_binary_with_plan_ref_multipart_data import AnnotateBinaryWithPlanRefMultipartData
from .annotate_documents_with_many import AnnotateDocumentsWithMany
from .annotate_format_binary_with_plan_ref_multipart_data import AnnotateFormatBinaryWithPlanRefMultipartData
from .annotate_text_with_many import AnnotateTextWithMany
from .annotated_doc_annotation import AnnotatedDocAnnotation
from .annotated_doc_annotation_properties import AnnotatedDocAnnotationProperties
from .annotated_doc_category import AnnotatedDocCategory
from .annotated_doc_category_properties import AnnotatedDocCategoryProperties
from .annotated_document import AnnotatedDocument
from .annotated_document_metadata import AnnotatedDocumentMetadata
from .annotation import Annotation
from .annotation_facets import AnnotationFacets
from .annotation_id import AnnotationId
from .annotation_metrics import AnnotationMetrics
from .annotation_plan import AnnotationPlan
from .annotation_status import AnnotationStatus
from .annotation_term import AnnotationTerm
from .annotation_term_properties import AnnotationTermProperties
from .annotator import Annotator
from .annotator_multimap import AnnotatorMultimap
from .bearer_token import BearerToken
from .bucket import Bucket
from .categories_facets import CategoriesFacets
from .category import Category
from .category_id import CategoryId
from .category_metrics import CategoryMetrics
from .category_status import CategoryStatus
from .classification_config import ClassificationConfig
from .classification_options import ClassificationOptions
from .config_patch_options import ConfigPatchOptions
from .convert_annotation_plan import ConvertAnnotationPlan
from .convert_format_annotation_plan import ConvertFormatAnnotationPlan
from .converter import Converter
from .converter_parameters import ConverterParameters
from .corpus_metrics import CorpusMetrics
from .create_lexicon_response_200 import CreateLexiconResponse200
from .create_project_from_archive_multipart_data import CreateProjectFromArchiveMultipartData
from .create_term_response_200 import CreateTermResponse200
from .created_by_count import CreatedByCount
from .credentials import Credentials
from .delete_group_result import DeleteGroupResult
from .delete_response import DeleteResponse
from .doc_alt_text import DocAltText
from .doc_annotation import DocAnnotation
from .doc_annotation_status import DocAnnotationStatus
from .doc_category import DocCategory
from .doc_category_status import DocCategoryStatus
from .doc_sentence import DocSentence
from .document import Document
from .document_facets import DocumentFacets
from .document_hit import DocumentHit
from .document_hits import DocumentHits
from .document_metadata import DocumentMetadata
from .engine_config import EngineConfig
from .engine_config_import_summary import EngineConfigImportSummary
from .engine_name import EngineName
from .experiment import Experiment
from .experiment_parameters import ExperimentParameters
from .experiment_patch import ExperimentPatch
from .experiment_patch_parameters import ExperimentPatchParameters
from .format_binary_form import FormatBinaryForm
from .format_documents_with_many import FormatDocumentsWithMany
from .format_text_with_many import FormatTextWithMany
from .formatter import Formatter
from .formatter_parameters import FormatterParameters
from .gazetteer import Gazetteer
from .gazetteer_parameters import GazetteerParameters
from .gazetteer_patch import GazetteerPatch
from .gazetteer_patch_parameters import GazetteerPatchParameters
from .generated_label_hint import GeneratedLabelHint
from .get_app_state_response_200 import GetAppStateResponse200
from .get_engine_parameters_schema_response_200 import GetEngineParametersSchemaResponse200
from .get_project_engine_parameters_schema_response_200 import GetProjectEngineParametersSchemaResponse200
from .get_segment_context_context_output import GetSegmentContextContextOutput
from .get_services_distinct_values_response_200_item import GetServicesDistinctValuesResponse200Item
from .get_suggestions_response_200 import GetSuggestionsResponse200
from .group_desc import GroupDesc
from .group_name import GroupName
from .group_patch import GroupPatch
from .group_share import GroupShare
from .http_service_metadata import HttpServiceMetadata
from .http_service_metadata_operations import HttpServiceMetadataOperations
from .http_service_record import HttpServiceRecord
from .import_archive_multipart_data import ImportArchiveMultipartData
from .import_models_multipart_data import ImportModelsMultipartData
from .input_document import InputDocument
from .input_document_metadata import InputDocumentMetadata
from .input_label import InputLabel
from .job_status import JobStatus
from .job_type import JobType
from .label import Label
from .label_count import LabelCount
from .label_update import LabelUpdate
from .launch_document_import_multipart_data import LaunchDocumentImportMultipartData
from .launch_document_import_segmentation_policy import LaunchDocumentImportSegmentationPolicy
from .launch_project_restoration_from_backup_multipart_data import LaunchProjectRestorationFromBackupMultipartData
from .launch_uploaded_document_import_segmentation_policy import LaunchUploadedDocumentImportSegmentationPolicy
from .lexicon import Lexicon
from .lexicon_update import LexiconUpdate
from .maybe_create_projects_and_import_models_from_archive_multipart_data import (
    MaybeCreateProjectsAndImportModelsFromArchiveMultipartData,
)
from .metadata_count import MetadataCount
from .metadata_definition import MetadataDefinition
from .metadata_definition_entry import MetadataDefinitionEntry
from .model_metrics import ModelMetrics
from .model_metrics_options import ModelMetricsOptions
from .models_metrics import ModelsMetrics
from .named_annotation_plan import NamedAnnotationPlan
from .new_experiment import NewExperiment
from .new_experiment_parameters import NewExperimentParameters
from .new_gazetteer import NewGazetteer
from .new_gazetteer_parameters import NewGazetteerParameters
from .new_group_desc import NewGroupDesc
from .new_named_annotation_plan import NewNamedAnnotationPlan
from .new_role import NewRole
from .new_suggester import NewSuggester
from .new_suggester_parameters import NewSuggesterParameters
from .new_user import NewUser
from .operation_count import OperationCount
from .partial_label import PartialLabel
from .partial_lexicon import PartialLexicon
from .plan_patch import PlanPatch
from .project_bean import ProjectBean
from .project_config_creation import ProjectConfigCreation
from .project_config_creation_properties import ProjectConfigCreationProperties
from .project_property import ProjectProperty
from .project_status import ProjectStatus
from .quality_figures import QualityFigures
from .relation import Relation
from .report import Report
from .report_classes import ReportClasses
from .request_jwt_token_project_access_mode import RequestJwtTokenProjectAccessMode
from .role_desc import RoleDesc
from .role_update import RoleUpdate
from .search_total import SearchTotal
from .search_total_relation import SearchTotalRelation
from .segment import Segment
from .segment_context import SegmentContext
from .segment_contexts import SegmentContexts
from .segment_hit import SegmentHit
from .segment_hits import SegmentHits
from .segment_metadata import SegmentMetadata
from .share_mode import ShareMode
from .sherpa_job_bean import SherpaJobBean
from .sherpa_job_bean_status import SherpaJobBeanStatus
from .sherpa_job_bean_type import SherpaJobBeanType
from .simple_metadata import SimpleMetadata
from .suggester import Suggester
from .suggester_parameters import SuggesterParameters
from .suggester_patch import SuggesterPatch
from .suggester_patch_parameters import SuggesterPatchParameters
from .suggestion_facets import SuggestionFacets
from .term import Term
from .term_hit import TermHit
from .term_hit_term import TermHitTerm
from .term_hits import TermHits
from .term_import import TermImport
from .term_importer_spec import TermImporterSpec
from .term_importer_spec_parameters import TermImporterSpecParameters
from .text_count import TextCount
from .upload_files_multipart_data import UploadFilesMultipartData
from .uploaded_file import UploadedFile
from .uploaded_file_info import UploadedFileInfo
from .user_permissions_update import UserPermissionsUpdate
from .user_profile import UserProfile
from .user_profile_update import UserProfileUpdate
from .user_response import UserResponse
from .with_annotator import WithAnnotator
from .with_annotator_condition import WithAnnotatorCondition
from .with_annotator_parameters import WithAnnotatorParameters
from .with_processor import WithProcessor
from .with_processor_condition import WithProcessorCondition
from .with_processor_parameters import WithProcessorParameters
