from opentelemetry import metrics
from opentelemetry.sdk.metrics import MeterProvider
from opentelemetry.exporter.otlp.proto.http.metric_exporter import OTLPMetricExporter
from opentelemetry.sdk.metrics.export import PeriodicExportingMetricReader
from opentelemetry.sdk.metrics.export import InMemoryMetricReader
from csvpath.managers.listener import Listener


class Metrics:
    def __init__(self, listener: Listener, exporting=True):
        self.listener = listener
        self.reader = None
        self.provider = None
        self.meter = None
        if exporting:
            self.reader = PeriodicExportingMetricReader(OTLPMetricExporter())
            self.provider = MeterProvider(metric_readers=[self.reader])
            metrics.set_meter_provider(self.provider)
        else:
            self.reader = InMemoryMetricReader()
            self.provider = MeterProvider(metric_readers=[self.reader])
            metrics.set_meter_provider(self.provider)

        self.meter = metrics.get_meter("csvpath")
        # Create metrics
        self.runs_started = self.meter.create_counter(
            "runs_started", description="Number of named-files started"
        )
        self.runs_completed = self.meter.create_counter(
            "runs_completed", description="Number of named-files completed"
        )
        self.errors = self.meter.create_counter(
            "errors", description="Number of errors found at the end of a csvpath's run"
        )
        self.files = self.meter.create_counter(
            "files_generated",
            description="Number of result files generated by an instance",
        )
        self.valid = self.meter.create_counter(
            "valid_files", description="Number of named-files considered valid"
        )
        self.files_expected = self.meter.create_counter(
            "files_expected",
            description="Were all the files expected actually produced?",
        )
        self.size = self.meter.create_histogram(
            "named_file_size_distribution",
            description="Distribution of processed file sizes",
        )
        self.bytes = self.meter.create_counter(
            "bytes", description="Number of bytes in the named-files"
        )
