# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest 1.0.20.34  # noqa: E501
    The version of the OpenAPI document: 0.8.11
    Contact: ravi@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from symbol_openapi_client.api_client import ApiClient
from symbol_openapi_client.exceptions import (
    ApiTypeError,
    ApiValueError
)


class RestrictionMosaicRoutesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_mosaic_address_restriction(self, mosaic_id, account_id, **kwargs):  # noqa: E501
        """Get mosaic address restrictions for a given mosaic and account identifier.  # noqa: E501

        Get mosaic address restriction.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mosaic_address_restriction(mosaic_id, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str mosaic_id: Mosaic identifier. (required)
        :param str account_id: Account public key or address enconded using a 32-character set. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MosaicAddressRestrictionDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_mosaic_address_restriction_with_http_info(mosaic_id, account_id, **kwargs)  # noqa: E501

    def get_mosaic_address_restriction_with_http_info(self, mosaic_id, account_id, **kwargs):  # noqa: E501
        """Get mosaic address restrictions for a given mosaic and account identifier.  # noqa: E501

        Get mosaic address restriction.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mosaic_address_restriction_with_http_info(mosaic_id, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str mosaic_id: Mosaic identifier. (required)
        :param str account_id: Account public key or address enconded using a 32-character set. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MosaicAddressRestrictionDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['mosaic_id', 'account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mosaic_address_restriction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'mosaic_id' is set
        if self.api_client.client_side_validation and ('mosaic_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['mosaic_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `mosaic_id` when calling `get_mosaic_address_restriction`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['account_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `account_id` when calling `get_mosaic_address_restriction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mosaic_id' in local_var_params:
            path_params['mosaicId'] = local_var_params['mosaic_id']  # noqa: E501
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/restrictions/mosaic/{mosaicId}/address/{accountId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MosaicAddressRestrictionDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mosaic_address_restrictions(self, mosaic_id, **kwargs):  # noqa: E501
        """Get mosaic address restrictions for a given mosaic and account identifiers array.  # noqa: E501

        Get mosaic address restrictions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mosaic_address_restrictions(mosaic_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str mosaic_id: Mosaic identifier. (required)
        :param AccountIds account_ids:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[MosaicAddressRestrictionDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_mosaic_address_restrictions_with_http_info(mosaic_id, **kwargs)  # noqa: E501

    def get_mosaic_address_restrictions_with_http_info(self, mosaic_id, **kwargs):  # noqa: E501
        """Get mosaic address restrictions for a given mosaic and account identifiers array.  # noqa: E501

        Get mosaic address restrictions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mosaic_address_restrictions_with_http_info(mosaic_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str mosaic_id: Mosaic identifier. (required)
        :param AccountIds account_ids:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[MosaicAddressRestrictionDTO], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['mosaic_id', 'account_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mosaic_address_restrictions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'mosaic_id' is set
        if self.api_client.client_side_validation and ('mosaic_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['mosaic_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `mosaic_id` when calling `get_mosaic_address_restrictions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mosaic_id' in local_var_params:
            path_params['mosaicId'] = local_var_params['mosaic_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'account_ids' in local_var_params:
            body_params = local_var_params['account_ids']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/restrictions/mosaic/{mosaicId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MosaicAddressRestrictionDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mosaic_global_restriction(self, mosaic_id, **kwargs):  # noqa: E501
        """Get mosaic global restriction for a given mosaic identifier.  # noqa: E501

        Get mosaic global restriction.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mosaic_global_restriction(mosaic_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str mosaic_id: Mosaic identifier. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MosaicGlobalRestrictionDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_mosaic_global_restriction_with_http_info(mosaic_id, **kwargs)  # noqa: E501

    def get_mosaic_global_restriction_with_http_info(self, mosaic_id, **kwargs):  # noqa: E501
        """Get mosaic global restriction for a given mosaic identifier.  # noqa: E501

        Get mosaic global restriction.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mosaic_global_restriction_with_http_info(mosaic_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str mosaic_id: Mosaic identifier. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MosaicGlobalRestrictionDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['mosaic_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mosaic_global_restriction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'mosaic_id' is set
        if self.api_client.client_side_validation and ('mosaic_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['mosaic_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `mosaic_id` when calling `get_mosaic_global_restriction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mosaic_id' in local_var_params:
            path_params['mosaicId'] = local_var_params['mosaic_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/restrictions/mosaic/{mosaicId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MosaicGlobalRestrictionDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mosaic_global_restrictions(self, mosaic_ids, **kwargs):  # noqa: E501
        """Get mosaic global restrictions for an array of mosaics.  # noqa: E501

        Get mosaic global restrictions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mosaic_global_restrictions(mosaic_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param MosaicIds mosaic_ids: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[MosaicGlobalRestrictionDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_mosaic_global_restrictions_with_http_info(mosaic_ids, **kwargs)  # noqa: E501

    def get_mosaic_global_restrictions_with_http_info(self, mosaic_ids, **kwargs):  # noqa: E501
        """Get mosaic global restrictions for an array of mosaics.  # noqa: E501

        Get mosaic global restrictions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mosaic_global_restrictions_with_http_info(mosaic_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param MosaicIds mosaic_ids: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[MosaicGlobalRestrictionDTO], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['mosaic_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mosaic_global_restrictions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'mosaic_ids' is set
        if self.api_client.client_side_validation and ('mosaic_ids' not in local_var_params or  # noqa: E501
                                                        local_var_params['mosaic_ids'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `mosaic_ids` when calling `get_mosaic_global_restrictions`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'mosaic_ids' in local_var_params:
            body_params = local_var_params['mosaic_ids']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/restrictions/mosaic', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MosaicGlobalRestrictionDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
