from setuptools import find_packages, setup

with open("README.md", "r") as fh:
    long_description = fh.read()

setup(
    name='apatterson189_google_api_helpers',
    packages=find_packages(include=['google_api_helpers']),
    version='0.1.5',
    description='LIbrary of helpers for using google apis',
    long_description=long_description,
    long_description_content_type="text/markdown",
    author='Albert Patterson',
    license='MIT',
    install_requires=[
        'atomicwrites==1.4.0',
        'attrs==20.2.0',
        'autopep8==1.5.4',
        'cachetools==4.1.1',
        'certifi==2020.6.20',
        'chardet==3.0.4',
        'google-api-core==1.22.4',
        'google-api-python-client==1.12.3',
        'google-auth==1.22.1',
        'google-auth-httplib2==0.0.4',
        'google-auth-oauthlib==0.4.1',
        'googleapis-common-protos==1.52.0',
        'httplib2==0.18.1',
        'idna==2.10',
        'importlib-metadata==2.0.0',
        'iniconfig==1.1.1',
        'more-itertools==8.5.0',
        'oauthlib==3.1.0',
        'packaging==20.4',
        'pluggy==0.13.1',
        'protobuf==3.13.0',
        'py==1.9.0',
        'pyasn1==0.4.8',
        'pyasn1-modules==0.2.8',
        'pycodestyle==2.6.0',
        'pyparsing==2.4.7',
        'pytz==2020.1',
        'requests==2.24.0',
        'requests-oauthlib==1.3.0',
        'rsa==4.6',
        'six==1.15.0',
        'toml==0.10.1',
        'uritemplate==3.0.1',
        'urllib3==1.25.10',
        'wcwidth==0.2.5',
        'zipp==3.3.1',
    ],
    setup_requires=['pytest-runner'],
    tests_require=['pytest==6.1.1'],
    test_suite='test',
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.6',
)
