phys_units = {
    'bohr': {'unit': 'Bohr', 'xml': 'Bohr', 'dim': 'L', 'value':    1.0000000000000000},
    'm': {'unit': 'm', 'xml': 'm', 'dim': 'L', 'value':    18897261345.835495},
    'cm': {'unit': 'cm', 'xml': 'cm', 'dim': 'L', 'value':    188972613.45835495},
    'nm': {'unit': 'nm', 'xml': 'nm', 'dim': 'L', 'value':    18.897261345835496},
    'ang': {'unit': 'A', 'xml': 'A', 'dim': 'L', 'value':    1.8897261345835497},
    'me': {'unit': 'm_e', 'xml': 'm_e', 'dim': 'M', 'value':    1.0000000000000000},
    'amu': {'unit': 'amu', 'xml': 'amu', 'dim': 'M', 'value':    1822.8884832732924},
    'kg': {'unit': 'kg', 'xml': 'kg', 'dim': 'M', 'value':    1.0977692384992151E+030},
    'g': {'unit': 'g', 'xml': 'g', 'dim': 'M', 'value':    1.0977692384992152E+027},
    'aut': {'unit': 'aut', 'xml': 'aut', 'dim': 'T', 'value':    1.0000000000000000},
    's': {'unit': 's', 'xml': 's', 'dim': 'T', 'value':    41341373466675104.},
    'ms': {'unit': 'ms', 'xml': 'ms', 'dim': 'T', 'value':    41341373466675.102},
    'mus': {'unit': 'mus', 'xml': 'mus', 'dim': 'T', 'value':    41341373466.675102},
    'ns': {'unit': 'ns', 'xml': 'ns', 'dim': 'T', 'value':    41341373.466675110},
    'ps': {'unit': 'ps', 'xml': 'ps', 'dim': 'T', 'value':    41341.373466675104},
    'fs': {'unit': 'fs', 'xml': 'fs', 'dim': 'T', 'value':    41.341373466675108},
    'e': {'unit': 'e', 'xml': 'e', 'dim': 'C', 'value':    1.0000000000000000},
    'c': {'unit': 'Coulomb', 'xml': 'Coulomb', 'dim': 'C', 'value':    6.2415094796077179E+018},
    'hartree': {'unit': 'Ha', 'xml': 'Ha', 'dim': 'E', 'value':    1.0000000000000000},
    'mhartree': {'unit': 'mHa', 'xml': 'mHa', 'dim': 'E', 'value':    1.0000000000000000E-003},
    'ev': {'unit': 'eV', 'xml': 'eV', 'dim': 'E', 'value':    3.6749324387552830E-002},
    'mev': {'unit': 'meV', 'xml': 'meV', 'dim': 'E', 'value':    3.6749324387552833E-005},
    'ry': {'unit': 'Ry', 'xml': 'Ry', 'dim': 'E', 'value':   0.50000000000000000},
    'mry': {'unit': 'mRy', 'xml': 'mRy', 'dim': 'E', 'value':    5.0000000000000001E-004},
    'kj/mol': {'unit': 'kJ/mol', 'xml': 'kJ.mol-1', 'dim': 'E', 'value':    3.8087988555913219E-004},
    'kcal/mol': {'unit': 'kcal/mol', 'xml': 'kcal.mol-1', 'dim': 'E', 'value':    1.5936014411794092E-003},
    'j': {'unit': 'J', 'xml': 'J', 'dim': 'E', 'value':    2.2937125653409008E+017},
    'erg': {'unit': 'erg', 'xml': 'erg', 'dim': 'E', 'value':    22937125653.409008},
    'hz': {'unit': 'Hz', 'xml': 'Hz', 'dim': 'E', 'value':    1.5198298412229587E-016},
    'mhz': {'unit': 'MHz', 'xml': 'MHz', 'dim': 'E', 'value':    1.5198298412229585E-010},
    'ghz': {'unit': 'GHz', 'xml': 'GHz', 'dim': 'E', 'value':    1.5198298412229587E-007},
    'thz': {'unit': 'THz', 'xml': 'THz', 'dim': 'E', 'value':    1.5198298412229586E-004},
    'cm-1': {'unit': 'cm-1', 'xml': 'cm-1', 'dim': 'E', 'value':    4.5563352384198048E-006},
    'k': {'unit': 'K', 'xml': 'K', 'dim': 'E', 'value':    3.1668151438446095E-006},
    'hartree/bohr': {'unit': 'Ha/Bohr', 'xml': 'Ha.Bohr-1', 'dim': 'F', 'value':    1.0000000000000000},
    'ev/ang': {'unit': 'eV/A', 'xml': 'eV.A-1', 'dim': 'F', 'value':    1.9446904879500702E-002},
    'n': {'unit': 'N', 'xml': 'N', 'dim': 'F', 'value':    12137804.115443323},
    'auv': {'unit': 'auv', 'xml': 'auv', 'dim': 'V', 'value':    1.0000000000000000},
    'ang/ps': {'unit': 'A/ps', 'xml': 'A.ps-1', 'dim': 'V', 'value':    4.5710289139446233E-005},
    'ang/fs': {'unit': 'A/fs', 'xml': 'A.fs-1', 'dim': 'V', 'value':    4.5710289139446227E-002},
    'bohr/ps': {'unit': 'Bohr/ps', 'xml': 'Bohr.ps-1', 'dim': 'V', 'value':    2.4188843188920432E-005},
    'bohr/fs': {'unit': 'Bohr/fs', 'xml': 'Bohr.fs-1', 'dim': 'V', 'value':    2.4188843188920429E-002},
    'm/s': {'unit': 'm/s', 'xml': 'm.s-1', 'dim': 'V', 'value':    4.5710289139446228E-007},
    'hartree/bohr**3': {'unit': 'Ha/Bohr**3', 'xml': 'Ha.Bohr-3', 'dim': 'P', 'value':    1.0000000000000000},
    'ev/ang**3': {'unit': 'eV/A**3', 'xml': 'eV.A-3', 'dim': 'P', 'value':    5.4456879450794178E-003},
    'pa': {'unit': 'Pa', 'xml': 'Pa', 'dim': 'P', 'value':    3.3989312932198673E-014},
    'mpa': {'unit': 'MPa', 'xml': 'MPa', 'dim': 'P', 'value':    3.3989312932198670E-008},
    'gpa': {'unit': 'GPa', 'xml': 'GPa', 'dim': 'P', 'value':    3.3989312932198671E-005},
    'atm': {'unit': 'Atm', 'xml': 'Atm', 'dim': 'P', 'value':    3.4439680505664796E-009},
    'bar': {'unit': 'bar', 'xml': 'bar', 'dim': 'P', 'value':    3.3989312932198673E-009},
    'mbar': {'unit': 'Mbar', 'xml': 'Mbar', 'dim': 'P', 'value':    3.3989312932198672E-003},
    '1/bohr': {'unit': '1/Bohr', 'xml': 'Bohr-1', 'dim': '1/L', 'value':    1.0000000000000000},
    '1/m': {'unit': '1/m', 'xml': 'm-1', 'dim': '1/L', 'value':    5.2917720811453775E-011},
    '1/nm': {'unit': '1/nm', 'xml': 'nm-1', 'dim': '1/L', 'value':    5.2917720811453774E-002},
    '1/ang': {'unit': '1/A', 'xml': 'A-1', 'dim': '1/L', 'value':   0.52917720811453772},
    'a0': {'unit': 'Bohr', 'xml': 'Bohr', 'dim': 'L', 'value':    1.0000000000000000},
    'ha': {'unit': 'Ha', 'xml': 'Ha', 'dim': 'E', 'value':    1.0000000000000000},
    'dyne': {'unit': 'dyne', 'xml': 'dyne', 'dim': 'F', 'value':    121.37804115443323},
    'ha/bohr**2': {'unit': 'Ha/Bohr**2', 'xml': 'Ha.Bohr-2', 'dim': 'F/L', 'value':    1.0000000000000000},
    'ev/ang**2': {'unit': 'eV/A**2', 'xml': 'eV.A-2', 'dim': 'F/L', 'value':    1.0290858830603163E-002},
    'n/m': {'unit': 'N/m', 'xml': 'N.m-1', 'dim': 'F/L', 'value':    6.4230492944514445E-004},
    'dyne/cm': {'unit': 'dyne/cm', 'xml': 'dyne.cm-1', 'dim': 'F/L', 'value':    6.4230492944514447E-007},
    'bohr**3': {'unit': 'Bohr**3', 'xml': 'Bohr3', 'dim': 'L**3', 'value':    1.0000000000000000},
    'm**3': {'unit': 'm**3', 'xml': 'm3', 'dim': 'L**3', 'value':    6.7483346012800010E+030},
    'cm**3': {'unit': 'cm**3', 'xml': 'cm3', 'dim': 'L**3', 'value':    6.7483346012800008E+024},
    'nm**3': {'unit': 'nm**3', 'xml': 'nm3', 'dim': 'L**3', 'value':    6748.3346012800021},
    'ang**3': {'unit': 'A**3', 'xml': 'A3', 'dim': 'L**3', 'value':    6.7483346012800025},
    'acu': {'unit': 'Acu', 'xml': 'Acu', 'dim': 'C/T', 'value':    1.0000000000000000},
    'ampere': {'unit': 'Ampere', 'xml': 'Ampere', 'dim': 'C/T', 'value':    1.8030452016266951E-032},
    'acd': {'unit': 'Acd', 'xml': 'Acd', 'dim': 'C/TLL', 'value':    1.0000000000000000},
    'amperemetre2': {'unit': 'Amperemetre2', 'xml': 'Ampere.m2', 'dim': 'C/TLL', 'value':    5.0490407495549401E-053},
    'amfd': {'unit': 'amfd', 'xml': 'amfd', 'dim': 'ET/CLL', 'value':    1.0000000000000000},
    'tesla': {'unit': 'Tesla', 'xml': 'Tesla', 'dim': 'ET/CLL', 'value':    1.5091903732428514E+033},
    'gauss': {'unit': 'Gauss', 'xml': 'Gauss', 'dim': 'ET/CLL', 'value':    1.5091903732428515E+029},
    'agr': {'unit': 'agr', 'xml': 'agr', 'dim': 'E/CLL', 'value':    1.0000000000000000},
    'radsectesla': {'unit': 'RadSecTesla', 'xml': 'Rad.Sec.Tesla', 'dim': 'E/CLL', 'value':    5.6856297851273598E-012},
    'mhztesla': {'unit': 'MHzTesla', 'xml': 'MHz.Tesla', 'dim': 'E/CLL', 'value':    3.5723865527974852E-017},
    'bohr**2': {'unit': 'Bohr**2', 'xml': 'Bohr2', 'dim': 'L**2', 'value':    1.0000000000000000},
    'fm**2': {'unit': 'fm**2', 'xml': 'fm2', 'dim': 'L**2', 'value':    3.5710648637280836E-010},
    'barn': {'unit': 'Barn', 'xml': 'Barn', 'dim': 'L**2', 'value':    3.5710648637280830E-008},
    'adu': {'unit': 'Adu', 'xml': 'Adu', 'dim': 'CL', 'value':    1.0000000000000000},
    'debye': {'unit': 'D', 'xml': 'Debye', 'dim': 'CL', 'value':   0.39343029713127986},
    'e**2/me': {'unit': 'e**2/m_e', 'xml': 'e2.m_e-1', 'dim': 'C**2/M', 'value':    1.0000000000000000},
    'e**2/amu': {'unit': 'e**2/amu', 'xml': 'e2.amu-1', 'dim': 'C**2/M', 'value':    5.4857990994837901E-004},
    'debye**2/ang**2/amu': {'unit': '(D/A)**2/amu', 'xml': 'D2.A-2.amu-1', 'dim': 'C**2/M', 'value':    2.3778133548598092E-005},
    'km/mol': {'unit': 'km/mol', 'xml': 'km.mol-1', 'dim': 'C**2/M', 'value':    5.6271481628920065E-007},
    'hartree/bohr/e': {'unit': 'Ha/Bohr/e', 'xml': 'Ha.Bohr-1.e-1', 'dim': 'F/C', 'value':    1.0000000000000000},
    'ev/ang/e': {'unit': 'eV/A/e', 'xml': 'eV.A-1.e-1', 'dim': 'F/C', 'value':    1.9446904879500702E-002},
    'n/c': {'unit': 'N/Coulomb', 'xml': 'N.Coulomb-1', 'dim': 'F/C', 'value':    7.5758219448161070E+025},
    'tpa': {'unit': 'TPa', 'xml': 'TPa', 'dim': 'P', 'value':    3.3989312932198673E-002},
    'ppa': {'unit': 'PPa', 'xml': 'PPa', 'dim': 'P', 'value':    33.989312932198672},
    'j/mol/k': {'unit': 'J/mol/K', 'xml': 'Jmol-1K-1', 'dim': 'none', 'value':   0.12027221933034352},
    'c/mol/k': {'unit': 'c/mol/K', 'xml': 'cmol-1K-1', 'dim': 'none', 'value':   0.50321896567815727},
    'r': {'unit': 'R', 'xml': 'R', 'dim': 'none', 'value':    1.0000000000000000},
}

atomic_units = {
    'L': 'bohr',
    'M': 'me',
    'T': 'aut',
    'C': 'e',
    'E': 'hartree',
    'F': 'hartree/bohr',
    'V': 'auv',
    'P': 'hartree/bohr**3',
    '1/L': '1/bohr',
    'F/L': 'ha/bohr**2',
    'L**3': 'bohr**3',
    'LL': 'bohr**2',
    'C/T': 'acu',
    'C/TLL': 'acd',
    'ET/CLL': 'amfd',
    'E/CLL': 'agr',
    'CL': 'adu',
    'C**2/M': 'e**2/m_e',
}

default_units = {
    'L': 'ang',
    'M': 'amu',
    'T': 'ps',
    'C': 'e',
    'E': 'ev',
    'F': 'ev/ang',
    'V': 'ang/ps',
    'P': 'gpa',
    '1/L': '1/ang',
    'F/L': 'ev/ang**2',
    'L**3': 'ang**3',
    'LL': 'barn',
    'C/T': 'ampere',
    'C/TLL': 'amperemetre2',
    'ET/CLL': 'tesla',
    'E/CLL': 'radsectesla',
    'CL': 'debye',
    'C**2/M': 'debye**2/ang**2/amu',
}
