# Generated by Django 3.1.14 on 2022-03-19 23:21

from django.db import migrations
from nautobot.dcim.choices import LocationStatusChoices
from nautobot.extras.management import export_statuses_from_choiceset


def populate_location_status(app, schema):

    Status = app.get_model("extras.Status")
    Location = app.get_model("dcim.Location")
    ContentType = app.get_model("contenttypes.ContentType")

    location_content_type = ContentType.objects.get_for_model(Location)
    choices = export_statuses_from_choiceset(LocationStatusChoices)

    # Create Location Statuses and add dcim.Location to its content_types
    for choice_kwargs in choices:
        try:
            obj, created = Status.objects.get_or_create(**choice_kwargs)
        except Exception as err:
            raise SystemExit(
                f"Unexpected error while running data migration to populate status for dcim.location: {err}"
            )

        obj.content_types.add(location_content_type)


def reverse_populate_location_status(app, schema_editor):
    Status = app.get_model("extras.Status")
    Location = app.get_model("dcim.Location")
    ContentType = app.get_model("contenttypes.ContentType")

    location_content_type = ContentType.objects.get_for_model(Location)

    for status in Status.objects.filter(content_types__in=[location_content_type]):
        status.content_types.remove(location_content_type)


class Migration(migrations.Migration):

    dependencies = [
        ("dcim", "0013_location_location_type"),
    ]

    operations = [
        migrations.RunPython(populate_location_status, reverse_populate_location_status),
    ]
