# Contributing to CleanVision

All kinds of contributions to CleanVision are greatly appreciated. If you're not looking to write code, submitting a [feature request](#feature-requests) or
[bug report](#bug-reports) is a great way to contribute. If you want to get
your hands dirty, you can submit [Pull Requests](#pull-requests), either working on your
own ideas or addressing [existing issues][issues].

If you are unsure or confused about anything, please go ahead and submit your
issue or pull request anyways! We appreciate all contributions, and we'll do
our best to incorporate your feedback or code into CleanVision. 
You can also chat with our developers in [Slack](https://cleanlab.ai/slack).

Detailed contributing instructions can be found in the [Development Guide](DEVELOPMENT.md), please read this carefully!


## Feature Requests

Do you have an idea for an awesome new feature for CleanVision? Let us know by
[submitting a feature request][issue].

If you are inclined to do so, you're welcome to [fork][fork] CleanVision, work on
implementing the feature yourself, and submit a patch. In this case, it's
*highly recommended* that you first [open an issue][issue] describing your
enhancement to get early feedback on the new feature that you are implementing.
This will help avoid wasted efforts and ensure that your work is incorporated
into the CleanVision code base.

## Bug Reports

Did something go wrong with CleanVision? Sorry about that! Bug reports are greatly
appreciated!

When you [submit a bug report][issue], please include as much context as you
can. This includes information like Python version, CleanVision version, an error
message or stack trace, and detailed steps to reproduce the bug (if possible, including toy data that reproduces the error). The more information you can include, the better.

## Pull Requests

Want to write code to help improve CleanVision? Awesome!

If there are [open issues][issues], you're more than welcome to work on those (a good place to start is those tagged "good first issue"). If you have your own ideas, that's great too! In that case, before working on substantial changes to the code base, it is *highly recommended* that you first
[open an issue][issue] describing what you intend to work on.

To contribute your code to the library, you'll want to [fork the repo](https://docs.github.com/en/get-started/quickstart/fork-a-repo), push your changes to your fork, and finally create a new [Pull Request][pr].

Detailed development instructions, such as how to run the tests, are available
in [DEVELOPMENT.md](DEVELOPMENT.md).

---

If you have any questions about contributing to CleanVision, feel free to
[ask][discussions]!

[issue]: https://github.com/cleanlab/cleanvision/issues/new
[issues]: https://github.com/cleanlab/cleanvision/issues
[fork]: https://github.com/cleanlab/cleanvision/fork
[pr]: https://github.com/cleanlab/cleanvision/pulls
[discussions]: https://github.com/cleanlab/cleanvision/discussions
